/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.perk;

import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TimeHelper;

public class PerkVoodooPoppet
extends Perk {
    public PerkVoodooPoppet() {
        super("voodoo_poppet", new ResourceLocation("tombstone", "textures/item/voodoo_poppet.png"));
    }

    @Override
    public int getLevelMax() {
        return 5;
    }

    @Override
    public boolean isDisabled(@Nullable Player player) {
        return (Boolean)SharedConfigTombstone.allowed_magic_items.allowVoodooPoppet.get() == false;
    }

    @Override
    public String getTranslationKey() {
        return "tombstone.item.voodoo_poppet";
    }

    @Override
    public Component getTooltip(int level, int actualLevel, int levelWithBonus) {
        if (level == actualLevel || actualLevel == 0 && level == 1 || level == levelWithBonus) {
            return new TextComponent("+" + level * 10 + "% ").m_7220_(this.getDescription());
        }
        if (level == actualLevel + 1) {
            return new TextComponent("+" + level * 10 + "%");
        }
        return TextComponent.f_131282_;
    }

    @Override
    public int getLevelBonus(Player player) {
        return TimeHelper.isDateAroundHalloween() ? 5 : 0;
    }

    @Override
    public Component getSpecialInfo(int levelWithBonus) {
        return LangKey.TOOLTIP_CHANCE_TRIGGER.getText(50 + levelWithBonus * 10);
    }
}

