/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.proxy;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import ovh.corail.tombstone.block.SoulType;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.CustomToast;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.UpdateServerMessage;
import ovh.corail.tombstone.particle.ParticleBoneShield;
import ovh.corail.tombstone.particle.ParticleCasting;
import ovh.corail.tombstone.particle.ParticleShadowStep;
import ovh.corail.tombstone.particle.ParticleShield;
import ovh.corail.tombstone.proxy.IProxy;
import ovh.corail.tombstone.registry.ModParticleTypes;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy
implements IProxy {
    private boolean isConfigDirty = false;
    private PlayerPreference lastPlayerPreference;

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void produceGraveSmoke(Level level, double x, double y, double z) {
        if (ConfigTombstone.client.fogDensity.get() != ConfigTombstone.Client.FogDensity.NONE) {
            Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ModParticleTypes.GRAVE_SMOKE, x + (double)(level.f_46441_.nextFloat() - level.f_46441_.nextFloat()) + 0.5, y - (double)0.1f, z + (double)(level.f_46441_.nextFloat() - level.f_46441_.nextFloat()) + 0.5, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void produceShadowStep(LivingEntity entity) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && mc.f_91074_.equals((Object)entity) && mc.f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
            return;
        }
        if (mc.f_91073_ != null && !entity.m_20159_() && !entity.m_5803_()) {
            IntStream.rangeClosed(1, 6).forEach(i -> mc.f_91061_.m_107344_((Particle)new ParticleShadowStep(mc.f_91073_, entity, (double)i / 6.0)));
        }
    }

    @Override
    public void produceShield(LivingEntity entity) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && !entity.m_20159_() && !entity.m_5803_()) {
            IntStream.rangeClosed(1, 4).forEach(i -> mc.f_91061_.m_107344_((Particle)new ParticleShield(mc.f_91073_, entity, 0.25 * (double)i)));
        }
    }

    @Override
    public void produceBoneShield(LivingEntity entity) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && !entity.m_20159_() && !entity.m_5803_()) {
            IntStream.rangeClosed(1, 5).forEach(i -> mc.f_91061_.m_107344_((Particle)new ParticleBoneShield(mc.f_91073_, entity, 0.2 * (double)i, i % 2 == 0)));
        }
    }

    @Override
    public void produceGraveSoul(Level level, BlockPos pos, SoulType soulType) {
        level.m_7106_((ParticleOptions)ModParticleTypes.GRAVE_SOUL, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)soulType.ordinal(), 0.0, 0.0);
    }

    @Override
    public void produceParticleCasting(LivingEntity caster, Predicate<LivingEntity> predic) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (caster != null && level != null) {
            for (int i = 1; i <= 2; ++i) {
                ParticleCasting particle = new ParticleCasting(level, caster, predic, 0.0, (double)i * 0.5);
                mc.f_91061_.m_107344_((Particle)particle);
                particle = new ParticleCasting(level, caster, predic, 0.5, (double)(i + 1) * 0.5);
                mc.f_91061_.m_107344_((Particle)particle);
                particle = new ParticleCasting(level, caster, predic, 1.0, (double)i * 0.5);
                mc.f_91061_.m_107344_((Particle)particle);
                particle = new ParticleCasting(level, caster, predic, 1.5, (double)(i + 1) * 0.5);
                mc.f_91061_.m_107344_((Particle)particle);
                particle = new ParticleCasting(level, caster, predic, 2.0, (double)i * 0.5);
                mc.f_91061_.m_107344_((Particle)particle);
            }
        }
    }

    @Override
    public void produceSmokeColumn(Level level, Vec3 vec) {
        level.m_7106_((ParticleOptions)ModParticleTypes.SMOKE_COLUMN, vec.f_82479_, vec.f_82480_, vec.f_82481_, 0.0, 0.0, 0.0);
    }

    @Override
    public void markConfigDirty() {
        this.isConfigDirty = true;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.isConfigDirty) {
            this.isConfigDirty = false;
            if (Minecraft.m_91087_().f_91074_ == null) {
                this.lastPlayerPreference = PlayerPreference.fromClientConfig();
            } else if (this.lastPlayerPreference.hasChangedFromConfig()) {
                LangKey.sendMessage((Component)new TextComponent("Syncing Preferences on Server"), (Player)Minecraft.m_91087_().f_91074_);
                this.lastPlayerPreference = PlayerPreference.fromClientConfig();
                PacketHandler.sendToServer(new UpdateServerMessage(this.lastPlayerPreference, false));
            }
        }
    }

    @Override
    public PlayerPreference initPlayerPreference() {
        this.lastPlayerPreference = PlayerPreference.fromClientConfig();
        return this.lastPlayerPreference;
    }

    @Override
    public Optional<Level> getClientWorld() {
        return Optional.ofNullable(Minecraft.m_91087_().f_91073_);
    }

    @Override
    @Nullable
    public Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    @Override
    public void addToast(ItemStack initial, ItemStack added, Component description) {
        CustomToast.INSTANCE.addCombination(initial, added, description);
    }
}

