/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.entity.GraveGuardian;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModItems;

@OnlyIn(value=Dist.CLIENT)
public class GraveGuardianArmorLayer<T extends GraveGuardian, M extends SkeletonModel<T>>
extends HumanoidArmorLayer<T, M, SkeletonModel<T>> {
    private final SkeletonModel<T> innerModel;
    private final SkeletonModel<T> outerModel;

    public GraveGuardianArmorLayer(RenderLayerParent<T, M> parent, EntityRendererProvider.Context context) {
        this(parent, new SkeletonModel(context.m_174023_(ModelLayers.f_171248_)), new SkeletonModel(context.m_174023_(ModelLayers.f_171249_)));
    }

    public GraveGuardianArmorLayer(RenderLayerParent<T, M> parent, SkeletonModel<T> innerModel, SkeletonModel<T> outerModel) {
        super(parent, innerModel, outerModel);
        this.innerModel = innerModel;
        this.outerModel = outerModel;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, T graveGuardian, float p_117100_, float p_117101_, float p_117102_, float p_117103_, float p_117104_, float p_117105_) {
        this.renderArmorPiece(poseStack, bufferSource, graveGuardian, EquipmentSlot.CHEST, light, this.getArmorModel(EquipmentSlot.CHEST));
        this.renderArmorPiece(poseStack, bufferSource, graveGuardian, EquipmentSlot.LEGS, light, this.getArmorModel(EquipmentSlot.LEGS));
        this.renderArmorPiece(poseStack, bufferSource, graveGuardian, EquipmentSlot.FEET, light, this.getArmorModel(EquipmentSlot.FEET));
        this.renderArmorPiece(poseStack, bufferSource, graveGuardian, EquipmentSlot.HEAD, light, this.getArmorModel(EquipmentSlot.HEAD));
    }

    private void renderArmorPiece(PoseStack poseStack, MultiBufferSource bufferSource, T graveGuardian, EquipmentSlot slot, int light, SkeletonModel<T> model) {
        if (slot == EquipmentSlot.HEAD && TimeHelper.isDateAroundChristmas()) {
            poseStack.m_85836_();
            ((SkeletonModel)this.m_117386_()).m_5585_().m_104299_(poseStack);
            CustomHeadLayer.m_174483_((PoseStack)poseStack, (boolean)false);
            Minecraft.m_91087_().m_91292_().m_109322_(graveGuardian, new ItemStack((ItemLike)ModItems.christmas_hat), ItemTransforms.TransformType.HEAD, false, poseStack, bufferSource, 0xF000F0);
            poseStack.m_85849_();
            return;
        }
        ItemStack stack = ((GraveGuardian)((Object)graveGuardian)).m_6844_(slot);
        Item item = stack.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            if (armor.m_40402_() == slot) {
                float b;
                float g;
                float r;
                model = (SkeletonModel)this.getArmorModelHook((LivingEntity)graveGuardian, stack, slot, (HumanoidModel)model);
                ((SkeletonModel)this.m_117386_()).m_102872_((HumanoidModel)model);
                this.m_117125_((HumanoidModel)model, slot);
                boolean hasFoil = false;
                VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)bufferSource, (RenderType)RenderType.m_110431_((ResourceLocation)this.getArmorResource((Entity)graveGuardian, stack, slot, null)), (boolean)false, (boolean)hasFoil);
                if (TimeHelper.isDateAroundHalloween()) {
                    r = 1.0f;
                    g = 0.4f;
                    b = 0.0f;
                    light = 0xF000F0;
                } else if (TimeHelper.isDateAroundChristmas()) {
                    r = 1.0f;
                    g = 0.0f;
                    b = 0.0f;
                    light = 0xF000F0;
                } else {
                    r = 0.0f;
                    g = 1.0f;
                    b = 1.0f;
                }
                model.m_7695_(poseStack, vertexconsumer, light, OverlayTexture.f_118083_, r, g, b, 1.0f);
            }
        } else if (stack.m_41720_() == Items.f_42055_) {
            poseStack.m_85836_();
            ((SkeletonModel)this.m_117386_()).m_5585_().m_104299_(poseStack);
            CustomHeadLayer.m_174483_((PoseStack)poseStack, (boolean)false);
            Minecraft.m_91087_().m_91292_().m_109322_(graveGuardian, stack, ItemTransforms.TransformType.HEAD, false, poseStack, bufferSource, 0xF000F0);
            poseStack.m_85849_();
        }
    }

    private SkeletonModel<T> getArmorModel(EquipmentSlot slot) {
        return slot == EquipmentSlot.LEGS ? this.innerModel : this.outerModel;
    }
}

