/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.combine;

import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import ovh.corail.tombstone.helper.TimeHelper;

class CyclableIngredient {
    private final Long2ObjectFunction<ItemStack> cyclableIngredient;
    private final Predicate<ItemStack> isIngredient;
    private final Supplier<Ingredient> supplierIngredient;
    private final boolean cycling;

    CyclableIngredient(ItemStack stack) {
        this.cyclableIngredient = time -> stack;
        this.isIngredient = aStack -> aStack.m_150930_(stack.m_41720_());
        this.supplierIngredient = () -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack});
        this.cycling = false;
    }

    CyclableIngredient(Tag.Named<Item> tag) {
        this.cyclableIngredient = time -> this.fromTag(time, tag);
        this.isIngredient = aStack -> aStack.m_150922_((Tag)tag);
        this.supplierIngredient = () -> Ingredient.m_43911_((Tag)tag);
        this.cycling = true;
    }

    ItemStack fromTag(long time, Tag.Named<Item> tag) {
        int count = tag.m_6497_().size();
        return new ItemStack((ItemLike)tag.m_6497_().get(Mth.m_14045_((int)((int)(time % ((long)count * 60L)) / 60), (int)0, (int)(count - 1))));
    }

    Ingredient asIngredient() {
        return this.supplierIngredient.get();
    }

    boolean isIngredient(ItemStack stack) {
        return this.isIngredient.test(stack);
    }

    ItemStack get() {
        return (ItemStack)this.cyclableIngredient.apply(this.cycling ? TimeHelper.systemTime() / 50L : 0L);
    }
}

