/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import java.lang.reflect.Method;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.helper.Helper;

public final class CompatibilityDruidCraft {
    public static final CompatibilityDruidCraft instance = new CompatibilityDruidCraft();
    private final Class<?> classTameableMonsterEntity;
    private final Method methodGetOwnerId;
    private final Method methodSetTamedBy;
    private boolean failed;

    private CompatibilityDruidCraft() {
        Class<?> clazz = this.classTameableMonsterEntity = SupportMods.DRUIDCRAFT.isLoaded() ? Helper.getClass("com.vulp.druidcraft.entities.TameableMonsterEntity") : null;
        if (this.classTameableMonsterEntity != null) {
            this.methodGetOwnerId = Helper.getMethod(this.classTameableMonsterEntity, "getOwnerId", new Class[0]);
            this.methodSetTamedBy = Helper.getMethod(this.classTameableMonsterEntity, "setTamedBy", Player.class);
        } else {
            this.methodSetTamedBy = null;
            this.methodGetOwnerId = null;
        }
        this.failed = this.methodGetOwnerId == null || this.methodSetTamedBy == null;
    }

    public boolean isTameable(Entity entity) {
        if (!this.failed) {
            ResourceLocation typeRL = entity.m_6095_().getRegistryName();
            return typeRL != null && typeRL.m_135827_().equals(SupportMods.DRUIDCRAFT.m_7912_()) && entity.getClass().isAssignableFrom(this.classTameableMonsterEntity);
        }
        return false;
    }

    @Nullable
    public UUID getOwnerId(Entity entity) {
        if (!this.failed) {
            try {
                return (UUID)this.methodGetOwnerId.invoke((Object)entity, new Object[0]);
            }
            catch (Throwable ignored) {
                this.failed = true;
            }
        }
        return null;
    }

    public void setTameBy(Player player, Entity entity) {
        if (!this.failed) {
            try {
                this.methodSetTamedBy.invoke((Object)entity, player);
            }
            catch (Throwable ignored) {
                this.failed = true;
            }
        }
    }
}

