/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.event;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVModifierEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.enchantment.TombstoneEnchantment;
import ovh.corail.tombstone.gui.GuiKnowledge;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.MarkerHandler;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.ResetPerkMessage;
import ovh.corail.tombstone.particle.ParticleGhost;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModItems;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="tombstone", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ClientEventHandler {
    public static final KeyMapping KEYBIND_KNOWLEDGE = new KeyMapping(LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.f_84822_, "Corail Tombstone");
    private static boolean isFirstGuiGameOver = false;
    private static boolean requireRemovalVisibility = false;
    private static boolean requireRemovalNightVision = false;
    private static boolean hasWaterVision = false;
    private static boolean delayedGui = false;
    public static boolean hasTrueSight = false;
    private static long nextGhostTime = -1L;
    public static Pair<LivingEntity, PoseStack> renderInfo = null;
    public static String toDisplay;
    private static long LAST_PACKET;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91104_()) {
            return;
        }
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            requireRemovalNightVision = false;
            hasWaterVision = false;
            hasTrueSight = false;
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            MarkerHandler.instance.update(mc);
            toDisplay = null;
            hasTrueSight = EffectHelper.isPotionActive((LivingEntity)mc.f_91074_, ModEffects.ghostly_shape, 4) || EffectHelper.isPotionActive((LivingEntity)mc.f_91074_, ModEffects.true_sight);
            hasWaterVision = hasTrueSight || EffectHelper.isPotionActive((LivingEntity)mc.f_91074_, ModEffects.aquatic_life) && Minecraft.m_91087_().f_91063_.m_109153_().m_167685_() == FogType.WATER;
            boolean bl = requireRemovalNightVision = hasTrueSight && !EffectHelper.isPotionActive((LivingEntity)mc.f_91074_, MobEffects.f_19611_);
            if (requireRemovalNightVision) {
                mc.f_91074_.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 1200, 0, true, false));
            }
        } else {
            if (requireRemovalNightVision) {
                requireRemovalNightVision = false;
                mc.f_91074_.m_6234_(MobEffects.f_19611_);
            }
            if ((KEYBIND_KNOWLEDGE.m_90859_() || delayedGui) && (mc.f_91080_ == null || mc.f_91080_ instanceof ChatScreen)) {
                mc.f_91074_.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> {
                    delayedGui = false;
                    mc.m_91152_((Screen)new GuiKnowledge(mc.f_91074_, (ITBCapability)cap));
                });
            }
            if (((Boolean)ConfigTombstone.client.allowHalloweenGhost.get()).booleanValue() && TimeHelper.isDateAroundHalloween()) {
                if (Helper.isNight((Level)mc.f_91073_)) {
                    long time = TimeHelper.worldTicks((Level)mc.f_91073_);
                    if (nextGhostTime == -1L || time > nextGhostTime) {
                        if (nextGhostTime > -1L && CooldownHandler.INSTANCE.noCooldown((Player)mc.f_91074_, CooldownType.NEXT_PRAY)) {
                            Vec3 ghostVec = mc.f_91074_.m_20182_().m_82520_((Helper.RANDOM.nextDouble() - 0.5) * 18.0, 0.0, (Helper.RANDOM.nextDouble() - 0.5) * 18.0);
                            mc.f_91061_.m_107344_((Particle)new ParticleGhost(mc.f_91073_, ghostVec.f_82479_, ghostVec.f_82480_, ghostVec.f_82481_, 0.0, 0.0));
                        }
                        nextGhostTime = time + (long)Helper.RANDOM.nextInt(6000) + 60L;
                    }
                } else {
                    nextGhostTime = -1L;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiRender(ScreenEvent.DrawScreenEvent event) {
        if (requireRemovalNightVision) {
            Optional.ofNullable(Minecraft.m_91087_().f_91074_).ifPresent(p -> p.m_6234_(MobEffects.f_19611_));
            requireRemovalNightVision = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onClientChatEvent(ClientChatEvent event) {
        if ("/tbgui".equals(event.getMessage())) {
            delayedGui = true;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderLivingPre(RenderLivingEvent.Pre<?, EntityModel<?>> event) {
        if (event.getEntity().m_6095_() == EntityType.f_20532_ && (EffectHelper.isPotionActive(event.getEntity(), ModEffects.ghostly_shape) || EffectHelper.isUnstableIntangibilityActive(event.getEntity()))) {
            renderInfo = Pair.of((Object)event.getEntity(), (Object)event.getPoseStack());
        }
        if (hasTrueSight && event.getEntity().m_20145_()) {
            if (Optional.ofNullable(Minecraft.m_91087_().f_91074_).map(arg_0 -> ((LivingEntity)event.getEntity()).m_20177_(arg_0)).orElse(false).booleanValue()) {
                event.getEntity().m_6842_(false);
                requireRemovalVisibility = true;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderLivingPost(RenderLivingEvent.Post<?, EntityModel<?>> event) {
        if (requireRemovalVisibility) {
            event.getEntity().m_6842_(true);
            requireRemovalVisibility = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiOpened(ScreenOpenEvent event) {
        LocalPlayer player;
        if (event.getScreen() instanceof DeathScreen && ((Boolean)ConfigTombstone.client.skipRespawnScreen.get()).booleanValue() && (player = Minecraft.m_91087_().f_91074_) != null && !player.f_19853_.m_6106_().m_5466_()) {
            isFirstGuiGameOver = !isFirstGuiGameOver;
            event.setCanceled(true);
            if (!isFirstGuiGameOver) {
                player.m_7583_();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        FluidState fluidState;
        boolean isWater;
        if ((hasTrueSight || hasWaterVision) && ((isWater = (fluidState = event.getCamera().getBlockAtCamera().m_60819_()).m_76153_((Tag)FluidTags.f_13131_)) || hasTrueSight && fluidState.m_76153_((Tag)FluidTags.f_13132_))) {
            event.setCanceled(true);
            event.setDensity(192.0f * (isWater ? 1.0f : 0.09375f));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onRenderFog(EntityViewRenderEvent.FogColors event) {
        if (hasTrueSight || hasWaterVision) {
            FluidState fluidState = event.getCamera().getBlockAtCamera().m_60819_();
            if (fluidState.m_76153_((Tag)FluidTags.f_13131_)) {
                event.setRed(0.09f);
                event.setGreen(0.42f);
                event.setBlue(0.93f);
            } else if (fluidState.m_76153_((Tag)FluidTags.f_13132_) && hasTrueSight) {
                event.setRed(1.0f);
                event.setGreen(0.32f);
                event.setBlue(0.09f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderBlockLayer(RenderBlockOverlayEvent event) {
        if ((hasTrueSight || hasWaterVision) && (event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.WATER || event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.FIRE && hasTrueSight)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleTooltip(ItemTooltipEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (event.getItemStack().m_150930_(Items.f_151058_)) {
            event.getToolTip().add(1, new TranslatableComponent("tombstone.item.enchanted_bundle.desc").m_6270_(StyleType.TOOLTIP_USE));
        }
        if (!SupportMods.ENCH_DESC.isLoaded() && ((Boolean)ConfigTombstone.client.showInfoOnEnchantment.get()).booleanValue() && event.getItemStack().m_41782_()) {
            boolean isEnchantedBook = event.getItemStack().m_150930_(Items.f_42690_);
            if (!isEnchantedBook && ModEnchantments.getEnchantments().values().stream().allMatch(TombstoneEnchantment::isEnabled)) {
                return;
            }
            ListTag taglist = isEnchantedBook ? EnchantedBookItem.m_41163_((ItemStack)event.getItemStack()) : event.getItemStack().m_41785_();
            List list = IntStream.range(0, taglist.size()).mapToObj(arg_0 -> ((ListTag)taglist).m_128728_(arg_0)).map(nbt -> nbt.m_128461_("id")).filter(id -> !id.isEmpty() && ModEnchantments.getEnchantments().containsKey(id)).map(ModEnchantments.getEnchantments()::get).collect(Collectors.toList());
            for (TombstoneEnchantment enchant : list) {
                IntStream.range(0, event.getToolTip().size()).filter(line -> {
                    Component currentTooltip = (Component)event.getToolTip().get(line);
                    return currentTooltip instanceof TranslatableComponent && enchant.m_44704_().equals(((TranslatableComponent)currentTooltip).m_131328_());
                }).findFirst().ifPresent(line -> {
                    List<Component> infos = enchant.getTooltipInfos(isEnchantedBook);
                    for (Component info : infos) {
                        event.getToolTip().add(++line, info);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void render(RenderLevelLastEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && mc.f_91073_ != null) {
            MarkerHandler.instance.render(mc, event.getPoseStack());
        }
    }

    @SubscribeEvent
    public static void renderOverlay(RenderGameOverlayEvent.Post event) {
        if (toDisplay != null && event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            Minecraft mc = Minecraft.m_91087_();
            PoseStack poseStack = new PoseStack();
            int halfWidth = mc.m_91268_().m_85445_() / 2;
            int minY = 50;
            int halfLength = mc.f_91062_.m_92895_(toDisplay) / 2;
            Objects.requireNonNull(mc.f_91062_);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)(halfWidth - halfLength - 2), (int)(minY - 2), (int)(halfWidth + halfLength + 2), (int)(minY + 9 + 1), (int)Integer.MIN_VALUE);
            GuiComponent.m_93208_((PoseStack)poseStack, (Font)mc.f_91062_, (String)toDisplay, (int)halfWidth, (int)minY, (int)-8347488);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onFieldOfView(FOVModifierEvent event) {
        if (!event.getEntity().m_6117_() && event.getEntity().m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ModItems.christmas_hat) && event.getEntity().m_150110_().m_35947_() != 0.0f) {
            event.setNewfov(event.getNewfov() - 0.25f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onClickAttack(InputEvent.ClickInputEvent event) {
        if (event.isAttack() && event.getHand() == InteractionHand.MAIN_HAND) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ != null && mc.f_91074_ != null && mc.f_91074_.m_21205_().m_150930_((Item)ModItems.ankh_of_pray)) {
                BlockState state;
                BlockHitResult result;
                event.setCanceled(true);
                if (mc.f_91077_ != null && mc.f_91077_.m_6662_() == HitResult.Type.BLOCK && (result = (BlockHitResult)mc.f_91077_).m_82448_((Entity)mc.f_91074_) < 25.0 && ModBlocks.DECORATIVE_GRAVES.containsValue((state = mc.f_91073_.m_8055_(result.m_82425_())).m_60734_()) && mc.f_91073_.m_46467_() >= LAST_PACKET + 20L) {
                    LAST_PACKET = mc.f_91073_.m_46467_();
                    PacketHandler.sendToServer(new ResetPerkMessage(result.m_82450_(), result.m_82434_(), result.m_82425_(), result.m_82436_()));
                    mc.f_91074_.m_6674_(InteractionHand.MAIN_HAND);
                }
                event.setSwingHand(false);
            }
        }
    }

    static {
        LAST_PACKET = 0L;
    }
}

