/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemScrollBuff;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.loot.DelayedNBTFunction;
import ovh.corail.tombstone.loot.InOpenWaterCondition;
import ovh.corail.tombstone.loot.TriggerCatMorningFunction;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

@Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class LootHelper {
    private static void addEntry(LootPool.Builder builder, Item item, int weight, Consumer<CompoundTag> consumer) {
        builder.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item).m_79711_(0).m_79707_(weight).m_5577_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)((CompoundTag)Util.m_137469_((Object)new CompoundTag(), consumer)))));
    }

    private static void addEnchantedEntry(LootPool.Builder builder, Item item, int weight) {
        LootHelper.addEntry(builder, item, weight, nbt -> nbt.m_128379_("enchant", true));
    }

    private static void addAncientTablet(LootPool.Builder builder, ItemTablet item, int weight) {
        LootHelper.addEntry(builder, item, weight, nbt -> nbt.m_128379_("ancient", true));
    }

    private static void addDelayedNBTEntry(LootPool.Builder builder, Item item, int weight) {
        builder.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item).m_79711_(0).m_79707_(weight).m_5577_((LootItemFunction.Builder)new DelayedNBTFunction.Builder()));
    }

    private static void addLostEntries(LootTable table) {
        LootPool.Builder builder = new LootPool.Builder().name("tombstone:lost_treasure");
        builder.m_6509_(InOpenWaterCondition.builder());
        int weight = 0;
        LootItem.m_79579_((ItemLike)ModItems.essence_of_undeath).m_79711_(0).m_79707_(10);
        weight += 10;
        if (ModItems.tablet_of_recall.isEnabled()) {
            LootHelper.addAncientTablet(builder, ModItems.tablet_of_recall, 3);
            weight += 3;
        }
        if (ModItems.tablet_of_home.isEnabled()) {
            LootHelper.addAncientTablet(builder, ModItems.tablet_of_home, 3);
            weight += 3;
        }
        if (ModItems.tablet_of_assistance.isEnabled()) {
            LootHelper.addAncientTablet(builder, ModItems.tablet_of_assistance, 3);
            weight += 3;
        }
        if (ModItems.scroll_of_knowledge.isEnabled()) {
            LootHelper.addDelayedNBTEntry(builder, ModItems.scroll_of_knowledge, 50);
            weight += 50;
        }
        if (ModItems.tablet_of_cupidity.isEnabled()) {
            LootHelper.addAncientTablet(builder, ModItems.tablet_of_cupidity, 3);
            weight += 3;
        }
        if (ModItems.voodoo_poppet.isEnabled()) {
            LootHelper.addDelayedNBTEntry(builder, ModItems.voodoo_poppet, 10);
            weight += 10;
        }
        if (ModItems.familiar_receptacle.isEnabled()) {
            LootHelper.addDelayedNBTEntry(builder, ModItems.familiar_receptacle, 10);
            weight += 10;
        }
        LootHelper.addDelayedNBTEntry(builder, (Item)ModItems.fishing_rod_of_misadventure, 20);
        weight += 20;
        int lostTabletChance = (Integer)SharedConfigTombstone.loot.chanceLootLostTablet.get();
        if (ModItems.lost_tablet.isEnabled() && lostTabletChance > 0) {
            builder.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.lost_tablet).m_79711_(0).m_79707_(lostTabletChance));
            weight += lostTabletChance;
        }
        if (weight > 0) {
            if (weight < 1000) {
                builder.m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79711_(0).m_79707_(1000 - weight));
            }
            table.addPool(builder.m_79082_());
        }
    }

    private static void addChestEntries(LootTable table) {
        LootPool.Builder builder = new LootPool.Builder().name("tombstone:chest_treasure");
        int weight = 0;
        for (Map.Entry<ItemScrollBuff.SpellBuff, Item> entry : ModItems.scroll_buff.entrySet()) {
            if (!entry.getKey().isEnabled()) continue;
            LootHelper.addEnchantedEntry(builder, entry.getValue(), 10);
            weight += 10;
        }
        if (ModItems.scroll_of_knowledge.isEnabled()) {
            LootHelper.addDelayedNBTEntry(builder, ModItems.scroll_of_knowledge, 50);
            weight += 50;
        }
        if (ModItems.tablet_of_cupidity.isEnabled()) {
            LootHelper.addEnchantedEntry(builder, ModItems.tablet_of_cupidity, 10);
            weight += 10;
        }
        if (ModItems.tablet_of_home.isEnabled()) {
            LootHelper.addEnchantedEntry(builder, ModItems.tablet_of_home, 10);
            weight += 10;
        }
        if (ModItems.voodoo_poppet.isEnabled()) {
            LootHelper.addDelayedNBTEntry(builder, ModItems.voodoo_poppet, 10);
            weight += 10;
        }
        if (ModItems.familiar_receptacle.isEnabled()) {
            LootHelper.addDelayedNBTEntry(builder, ModItems.familiar_receptacle, 10);
            weight += 10;
        }
        if (weight > 0) {
            if (weight < 1000) {
                builder.m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79711_(0).m_79707_(1000 - weight));
            }
            table.addPool(builder.m_79082_());
        }
    }

    private static void addCatMorningEntries(LootTable table) {
        LootPool.Builder builder = new LootPool.Builder().name("tombstone:cat_morning");
        builder.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.grave_dust).m_79711_(0).m_79707_(100).m_5577_((LootItemFunction.Builder)new TriggerCatMorningFunction.Builder()).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))));
        builder.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.essence_of_undeath).m_79711_(0).m_79707_(1));
        int weight = 101;
        if (TimeHelper.isDateAroundHalloween()) {
            builder.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.lollipop).m_79711_(0).m_79707_(500).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)5.0f))));
            weight += 500;
        }
        builder.m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79711_(0).m_79707_(1000 - weight));
        table.addPool(builder.m_79082_());
    }

    public static void handleMobDrops(Collection<ItemEntity> drops, LivingEntity entity, ServerPlayer player) {
        Random rng = Helper.RANDOM;
        int boneCollectorLevel = EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.bone_collector);
        double chanceModifier = 1.0 + (double)boneCollectorLevel * 0.3;
        if (EntityHelper.isUndead(entity)) {
            boolean isBoss;
            if ((Integer)ConfigTombstone.loot.chanceGraveDust.get() > 0 && LootHelper.checkLoot(rng, (double)((Integer)ConfigTombstone.loot.chanceGraveDust.get()).intValue() * chanceModifier)) {
                LootHelper.addDropToEntity(drops, entity, new ItemStack((ItemLike)ModItems.grave_dust, rng.nextInt(2) + 1));
                ModTriggers.GRAVE_DUST_FROM_UNDEAD.trigger(player);
            }
            if (LootHelper.checkLoot(rng, (double)((isBoss = EntityHelper.isBoss(entity)) ? 20 : 5) * chanceModifier)) {
                LootHelper.addDropToEntity(drops, entity, new ItemStack((ItemLike)ModItems.essence_of_undeath));
            }
            if (isBoss) {
                if ((Integer)ConfigTombstone.loot.chanceSoulReceptacleOnBoss.get() > 0 && LootHelper.checkLoot(rng, (double)((Integer)ConfigTombstone.loot.chanceSoulReceptacleOnBoss.get()).intValue() * chanceModifier)) {
                    LootHelper.addDropToEntity(drops, entity, new ItemStack((ItemLike)ModItems.soul_receptacle));
                }
                if ((Integer)ConfigTombstone.loot.chanceRandomScrollOnBoss.get() > 0 && LootHelper.checkLoot(rng, (double)((Integer)ConfigTombstone.loot.chanceRandomScrollOnBoss.get()).intValue() * chanceModifier)) {
                    ItemScrollBuff.SpellBuff.getRandomEnchantedScroll().ifPresent(scroll -> LootHelper.addDropToEntity(drops, entity, scroll));
                }
                if (ModItems.voodoo_poppet.isEnabled() && (Integer)ConfigTombstone.loot.chanceVoodooPoppetOnBoss.get() > 0 && LootHelper.checkLoot(rng, (double)((Integer)ConfigTombstone.loot.chanceVoodooPoppetOnBoss.get()).intValue() * chanceModifier)) {
                    LootHelper.addDropToEntity(drops, entity, ModItems.voodoo_poppet.createWithRandomProtections(Helper.RANDOM.nextInt(5) + 1));
                }
                if (ModItems.familiar_receptacle.isEnabled() && (Integer)ConfigTombstone.loot.chanceFamiliarReceptacleOnBoss.get() > 0 && LootHelper.checkLoot(rng, (double)((Integer)ConfigTombstone.loot.chanceFamiliarReceptacleOnBoss.get()).intValue() * chanceModifier)) {
                    LootHelper.addDropToEntity(drops, entity, ModItems.familiar_receptacle.createWithRandomFamiliar());
                }
            }
        }
        if (TimeHelper.isDateAroundHalloween() && entity instanceof Enemy && LootHelper.checkLoot(rng, 100.0 * chanceModifier)) {
            LootHelper.addDropToEntity(drops, entity, new ItemStack((ItemLike)ModItems.lollipop, rng.nextInt(3) + 1));
        }
    }

    private static boolean checkLoot(Random rng, double chance) {
        return chance >= 1000.0 || (double)rng.nextInt(1000) < chance;
    }

    private static void addDropToEntity(Collection<ItemEntity> drops, LivingEntity entity, ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            drops.add(new ItemEntity(entity.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), stack));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLootTableLoad(LootTableLoadEvent event) {
        if (event.getName().equals((Object)BuiltInLootTables.f_78721_)) {
            LootHelper.addLostEntries(event.getTable());
        } else if (event.getName().equals((Object)BuiltInLootTables.f_78724_)) {
            LootHelper.addCatMorningEntries(event.getTable());
        } else if (!event.getName().equals((Object)BuiltInLootTables.f_78740_) && Optional.ofNullable(event.getName()).map(ResourceLocation::m_135815_).filter(name -> name.startsWith("chests") && !name.startsWith("chests/village/") && !name.contains("supply")).isPresent()) {
            LootHelper.addChestEntries(event.getTable());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDrops(LivingDropsEvent event) {
        if (event.getEntityLiving() != null && !event.getEntityLiving().f_19853_.m_5776_() && event.getEntityLiving().m_6095_() != EntityType.f_20532_) {
            Optional.ofNullable(event.getSource()).filter(d -> EntityHelper.isValidServerPlayer(d.m_7639_())).map(d -> (ServerPlayer)d.m_7639_()).ifPresent(player -> LootHelper.handleMobDrops(event.getDrops(), event.getEntityLiving(), player));
        }
    }
}

