/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.gui.CompendiumData;
import ovh.corail.tombstone.gui.CustomButton;
import ovh.corail.tombstone.gui.TBScreen;
import ovh.corail.tombstone.helper.FontHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TimeHelper;

@OnlyIn(value=Dist.CLIENT)
public final class ScreenCompendium
extends TBScreen {
    private CompendiumData currentInfo;
    @Nullable
    private CompendiumData.CompendiumLabel hoveredInfo = null;
    private int currentPage = 0;
    private Button previousPage;
    private Button nextPage;
    private Button showRecipe;
    private DisplayType displayType = DisplayType.DESCRIPTION;
    private long delay = 0L;

    ScreenCompendium() {
        this(CompendiumData.CompendiumLabel.COMPENDIUM);
    }

    public ScreenCompendium(CompendiumData.CompendiumLabel currentInfo) {
        super((Component)LangKey.MESSAGE_COMPENDIUM.getText(new Object[0]));
        this.currentInfo = CompendiumData.getInfo(currentInfo);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new CustomButton(this.halfWidth - 35, this.guiBottom - 25, 70, 15, (Component)LangKey.MESSAGE_BACK.getText(new Object[0]), pressable -> {
            if (this.currentInfo.isIndex()) {
                this.getThePlayer().m_6915_();
            } else {
                this.updateInfoAndButtons(CompendiumData.CompendiumLabel.COMPENDIUM);
            }
        }));
        this.previousPage = new PageButton(this.halfWidth - 23 - 65, this.guiBottom - 25, false, pressable -> this.changePage(this.currentPage - 1), true);
        this.m_142416_((GuiEventListener)this.previousPage);
        this.nextPage = new PageButton(this.halfWidth + 65, this.guiBottom - 25, true, pressable -> this.changePage(this.currentPage + 1), true);
        this.m_142416_((GuiEventListener)this.nextPage);
        Objects.requireNonNull(this);
        this.m_142416_((GuiEventListener)new CustomButton(this.halfWidth - 230 / 4 - 35, this.guiTop + 34, 70, 15, (Component)LangKey.MESSAGE_DESCRIPTION.getText(new Object[0]), pressable -> {
            if (this.displayType != DisplayType.DESCRIPTION) {
                this.displayType = DisplayType.DESCRIPTION;
                this.updateButtons();
            }
        }, () -> this.displayType == DisplayType.DESCRIPTION));
        Objects.requireNonNull(this);
        this.showRecipe = new CustomButton(this.halfWidth + 230 / 4 - 35, this.guiTop + 34, 70, 15, (Component)LangKey.MESSAGE_RECIPE.getText(new Object[0]), pressable -> {
            if (this.displayType != DisplayType.RECIPE) {
                this.displayType = DisplayType.RECIPE;
                this.updateButtons();
            }
        }, () -> this.displayType == DisplayType.RECIPE);
        this.m_142416_((GuiEventListener)this.showRecipe);
        Objects.requireNonNull(this);
        this.m_142416_((GuiEventListener)new CustomButton(this.guiLeft + 230 + 5, this.guiTop + 20, 90, 11, (Component)new TextComponent("Support Corail 31"), pressable -> {
            long worldTick;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null && this.delay <= (worldTick = TimeHelper.worldTicks((Level)level))) {
                try {
                    this.delay = worldTick + 100L;
                    Util.m_137581_().m_137648_(new URI("https://www.patreon.com/Corail31"));
                }
                catch (Throwable t) {
                    pressable.f_93623_ = false;
                }
            }
        }, () -> true));
        this.updateButtons();
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0 && this.hoveredInfo != null) {
            this.updateInfoAndButtons(this.hoveredInfo);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    private void changePage(int pageNum) {
        if (pageNum >= 0 && pageNum < this.currentInfo.getPageMax()) {
            this.currentPage = pageNum;
            this.updateButtons();
        }
    }

    private void updateInfoAndButtons(CompendiumData.CompendiumLabel info) {
        this.currentInfo = CompendiumData.getInfo(info);
        this.currentPage = 0;
        this.displayType = DisplayType.DESCRIPTION;
        this.updateButtons();
    }

    private void updateButtons() {
        this.previousPage.f_93624_ = this.displayType == DisplayType.DESCRIPTION && this.currentPage > 0;
        this.previousPage.f_93623_ = this.previousPage.f_93624_;
        this.nextPage.f_93624_ = this.displayType == DisplayType.DESCRIPTION && this.currentPage < this.currentInfo.getPageMax() - 1;
        this.nextPage.f_93623_ = this.nextPage.f_93624_;
        this.showRecipe.f_93624_ = !this.currentInfo.getRecipes().isEmpty();
        this.showRecipe.f_93623_ = this.showRecipe.f_93624_;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this.f_96547_);
        ScreenCompendium.m_93172_((PoseStack)poseStack, (int)(this.guiLeft + 5), (int)(this.guiTop + 5), (int)(this.guiLeft + 230 - 5), (int)(this.guiTop + 20 + 9), (int)0x55000000);
        FontHelper.drawCentered(poseStack, this.f_96547_, this.currentInfo.getTitle(), (float)this.halfWidth, (float)(this.guiTop + 15), -1);
        if (!this.currentInfo.isIndex()) {
            TextComponent textComponent = new TextComponent(this.currentPage + 1 + "/" + this.currentInfo.getPageMax());
            Objects.requireNonNull(this);
            FontHelper.drawFantasy(poseStack, this.f_96547_, (Component)textComponent, this.guiLeft + 230 - 30, this.guiTop + 8, -1);
        }
        if (!this.currentInfo.getIcon().m_41619_()) {
            ScreenCompendium.m_93172_((PoseStack)poseStack, (int)(this.guiLeft + 8), (int)(this.guiTop + 8), (int)(this.guiLeft + 26), (int)(this.guiTop + 26), (int)0x10FFFFFF);
            RenderSystem.m_157456_((int)0, (ResourceLocation)FRAME);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ScreenCompendium.m_93133_((PoseStack)poseStack, (int)(this.guiLeft + 7), (int)(this.guiTop + 7), (float)0.0f, (float)0.0f, (int)21, (int)21, (int)21, (int)21);
            this.f_96542_.m_115203_(this.currentInfo.getIcon(), this.guiLeft + 9, this.guiTop + 9);
        }
        if (this.displayType == DisplayType.RECIPE) {
            ScreenCompendium.m_93172_((PoseStack)poseStack, (int)(this.guiLeft + 5), (int)(this.guiTop + 55), (int)(this.guiRight - 5), (int)(this.guiBottom + 119), (int)0x55000000);
            List<CompendiumData.CompendiumRecipe> recipes = this.currentInfo.getRecipes();
            for (int i = 0; i < Math.min(recipes.size(), 6); ++i) {
                CompendiumData.CompendiumRecipe recipe = recipes.get(i);
                recipe.render(this.f_96542_, poseStack, this.guiLeft + 20 + i % 3 * 70, this.guiTop + 65 + i / 3 * 70);
            }
        } else {
            this.drawDescription(poseStack);
        }
        Objects.requireNonNull(this);
        int minX = this.guiLeft + 230 + 5;
        int minY = this.guiTop + 40;
        this.hoveredInfo = null;
        for (CompendiumData.CompendiumLabel link : this.currentInfo.getLinks()) {
            int maxX = minX + this.f_96547_.m_92852_((FormattedText)link.getTitle());
            Objects.requireNonNull(this.f_96547_);
            int maxY = minY + 9;
            boolean isHovered = false;
            if (this.hoveredInfo == null && mouseX >= minX && mouseX <= maxX && mouseY >= minY && mouseY <= maxY) {
                this.hoveredInfo = link;
                isHovered = true;
            }
            this.f_96547_.m_92889_(poseStack, link.getTitle(), (float)minX, (float)(minY + 1), isHovered ? -1875 : -1);
            minY = maxY + 1;
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    private void drawDescription(PoseStack poseStack) {
        int minX = this.guiLeft + 10;
        int minY = this.guiTop + 60;
        List<FormattedCharSequence> lines = this.currentInfo.getPage(this.currentPage);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this.f_96547_);
        ScreenCompendium.m_93172_((PoseStack)poseStack, (int)(minX - 5), (int)(minY - 5), (int)(this.guiLeft + 230 - 5), (int)(minY + 5 + (9 + 1) * lines.size()), (int)0x55000000);
        for (int i = 0; i < lines.size(); ++i) {
            FormattedCharSequence line = lines.get(i);
            float f = minX;
            Objects.requireNonNull(this.f_96547_);
            this.f_96547_.m_92877_(poseStack, line, f, (float)(minY + 2 + i * (9 + 1)), -1);
        }
    }

    static enum DisplayType {
        DESCRIPTION,
        RECIPE;

    }
}

