/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.item.IDisableable;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.helper.UpdaterHandler;
import ovh.corail.tombstone.item.ItemScrollBuff;
import ovh.corail.tombstone.loot.CheckEnableFunction;
import ovh.corail.tombstone.loot.DelayedNBTFunction;
import ovh.corail.tombstone.loot.InOpenWaterCondition;
import ovh.corail.tombstone.loot.IsHalloweenFunction;
import ovh.corail.tombstone.loot.TriggerCatMorningFunction;
import ovh.corail.tombstone.mixin.accessor.LootTableAccessor;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

@Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class LootHelper {
    private static final List<LootTable> CHEST_TABLES = new ArrayList<LootTable>();
    private static final Map<UpdaterHandler.PoolType, LootTable> CUSTOM_LOOTTABLES = new ConcurrentHashMap<UpdaterHandler.PoolType, LootTable>();

    private static void addEntry(LootPool.Builder builder, Item item, int weight, LootItemFunction.Builder ... functions) {
        LootPoolSingletonContainer.Builder lootBuilder = LootItem.m_79579_((ItemLike)item).m_79711_(0).m_79707_(weight);
        if (item instanceof IDisableable) {
            builder.m_5577_((LootItemFunction.Builder)new CheckEnableFunction.Builder());
        }
        Arrays.stream(functions).forEach(arg_0 -> ((LootPoolSingletonContainer.Builder)lootBuilder).m_5577_(arg_0));
        builder.m_79076_((LootPoolEntryContainer.Builder)lootBuilder);
    }

    private static void addEntry(LootPool.Builder builder, Item item, int weight, Consumer<CompoundTag> consumer, LootItemFunction.Builder ... functions) {
        LootPoolSingletonContainer.Builder lootBuilder = LootItem.m_79579_((ItemLike)item).m_79711_(0).m_79707_(weight).m_5577_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)((CompoundTag)Util.m_137469_((Object)new CompoundTag(), consumer))));
        if (item instanceof IDisableable) {
            builder.m_5577_((LootItemFunction.Builder)new CheckEnableFunction.Builder());
        }
        Arrays.stream(functions).forEach(arg_0 -> ((LootPoolSingletonContainer.Builder)lootBuilder).m_5577_(arg_0));
        builder.m_79076_((LootPoolEntryContainer.Builder)lootBuilder);
    }

    private static void addEnchantedEntry(LootPool.Builder builder, Item item, int weight, LootItemFunction.Builder ... functions) {
        LootHelper.addEntry(builder, item, weight, (CompoundTag nbt) -> nbt.m_128379_("enchant", true), functions);
    }

    private static void addAncientEntry(LootPool.Builder builder, Item item, int weight, LootItemFunction.Builder ... functions) {
        LootHelper.addEntry(builder, item, weight, (CompoundTag nbt) -> nbt.m_128379_("ancient", true), functions);
    }

    private static void addEnchantedAncientEntry(LootPool.Builder builder, Item item, int weight, LootItemFunction.Builder ... functions) {
        LootHelper.addEntry(builder, item, weight, (CompoundTag nbt) -> {
            nbt.m_128379_("enchant", true);
            nbt.m_128379_("ancient", true);
        }, functions);
    }

    private static void addDelayedNBTEntry(LootPool.Builder builder, Item item, int weight) {
        LootHelper.addEntry(builder, item, weight, new LootItemFunction.Builder[]{new DelayedNBTFunction.Builder()});
    }

    private static LootPool getLostTreasureLootPool() {
        LootPool.Builder builder = new LootPool.Builder().name("tombstone:lost_treasure");
        builder.m_6509_(InOpenWaterCondition.builder());
        int weight = 0;
        LootHelper.addEntry(builder, (Item)ModItems.essence_of_undeath, 10, new LootItemFunction.Builder[0]);
        weight += 10;
        LootHelper.addEntry(builder, Items.f_151058_, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addEntry(builder, (Item)ModItems.bag_of_seeds, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addAncientEntry(builder, ModItems.tablet_of_recall, 3, new LootItemFunction.Builder[0]);
        weight += 3;
        LootHelper.addAncientEntry(builder, ModItems.tablet_of_home, 3, new LootItemFunction.Builder[0]);
        weight += 3;
        LootHelper.addAncientEntry(builder, ModItems.tablet_of_assistance, 3, new LootItemFunction.Builder[0]);
        weight += 3;
        LootHelper.addDelayedNBTEntry(builder, ModItems.scroll_of_knowledge, 20);
        weight += 20;
        LootHelper.addAncientEntry(builder, ModItems.tablet_of_cupidity, 3, new LootItemFunction.Builder[0]);
        weight += 3;
        LootHelper.addDelayedNBTEntry(builder, ModItems.magic_scroll, 50);
        weight += 50;
        LootHelper.addEntry(builder, (Item)ModItems.familiar_stone, 10, new LootItemFunction.Builder[0]);
        weight += 10;
        LootHelper.addDelayedNBTEntry(builder, ModItems.voodoo_poppet, 10);
        weight += 10;
        LootHelper.addDelayedNBTEntry(builder, ModItems.familiar_receptacle, 10);
        weight += 10;
        LootHelper.addDelayedNBTEntry(builder, (Item)ModItems.fishing_rod_of_misadventure, 20);
        weight += 20;
        LootHelper.addEntry(builder, (Item)ModItems.lost_tablet, 100, new LootItemFunction.Builder[0]);
        if ((weight += 100) < 1000) {
            builder.m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79711_(0).m_79707_(1000 - weight));
        }
        return builder.m_79082_();
    }

    private static LootPool getChestTreasureLootPool() {
        LootPool.Builder builder = new LootPool.Builder().name("tombstone:chest_treasure");
        int weight = 0;
        LootHelper.addEntry(builder, Items.f_151058_, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addEntry(builder, (Item)ModItems.bag_of_seeds, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        for (Map.Entry<ItemScrollBuff.SpellBuff, Item> entry : ModItems.EnumItem.scroll_buff.entrySet()) {
            LootHelper.addEnchantedEntry(builder, entry.getValue(), 10, new LootItemFunction.Builder[0]);
            weight += 10;
        }
        LootHelper.addDelayedNBTEntry(builder, ModItems.scroll_of_knowledge, 20);
        weight += 20;
        LootHelper.addEnchantedEntry(builder, ModItems.tablet_of_cupidity, 10, new LootItemFunction.Builder[0]);
        weight += 10;
        LootHelper.addEnchantedEntry(builder, ModItems.tablet_of_home, 10, new LootItemFunction.Builder[0]);
        weight += 10;
        LootHelper.addDelayedNBTEntry(builder, ModItems.magic_scroll, 50);
        weight += 50;
        LootHelper.addEntry(builder, (Item)ModItems.familiar_stone, 10, new LootItemFunction.Builder[0]);
        weight += 10;
        LootHelper.addDelayedNBTEntry(builder, ModItems.voodoo_poppet, 10);
        weight += 10;
        LootHelper.addDelayedNBTEntry(builder, ModItems.familiar_receptacle, 10);
        if ((weight += 10) < 1000) {
            builder.m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79711_(0).m_79707_(1000 - weight));
        }
        return builder.m_79082_();
    }

    private static LootPool getCatMorningLootPool() {
        LootPool.Builder builder = new LootPool.Builder().name("tombstone:cat_morning");
        LootHelper.addEntry(builder, (Item)ModItems.grave_dust, 100, new LootItemFunction.Builder[]{new TriggerCatMorningFunction.Builder(), SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))});
        LootHelper.addEntry(builder, (Item)ModItems.essence_of_undeath, 1, new LootItemFunction.Builder[0]);
        LootHelper.addEntry(builder, Items.f_151058_, 20, new LootItemFunction.Builder[0]);
        int weight = 121;
        LootHelper.addEntry(builder, (Item)ModItems.bag_of_seeds, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addEntry(builder, (Item)ModItems.familiar_stone, 50, new LootItemFunction.Builder[0]);
        weight += 50;
        LootHelper.addEntry(builder, (Item)ModItems.lollipop, 500, new LootItemFunction.Builder[]{new IsHalloweenFunction.Builder(), new DelayedNBTFunction.Builder()});
        builder.m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79711_(0).m_79707_(1000 - (weight += 500)));
        return builder.m_79082_();
    }

    private static LootPool getUndeadMobLootPool() {
        LootPool.Builder builder = new LootPool.Builder().name("tombstone:undead_mob");
        int weight = 0;
        LootHelper.addEntry(builder, (Item)ModItems.grave_dust, 100, new LootItemFunction.Builder[]{SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))});
        weight += 100;
        LootHelper.addEntry(builder, Items.f_151058_, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addEntry(builder, (Item)ModItems.bag_of_seeds, 10, new LootItemFunction.Builder[0]);
        weight += 10;
        LootHelper.addDelayedNBTEntry(builder, ModItems.magic_scroll, 20);
        weight += 20;
        LootHelper.addEntry(builder, (Item)ModItems.essence_of_undeath, 5, new LootItemFunction.Builder[0]);
        weight += 5;
        LootHelper.addEntry(builder, (Item)ModItems.familiar_stone, 10, new LootItemFunction.Builder[0]);
        if ((weight += 10) < 1000) {
            builder.m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79711_(0).m_79707_(1000 - weight));
        }
        return builder.m_79082_();
    }

    private static LootPool getUndeadBossLootPool() {
        LootPool.Builder builder = new LootPool.Builder().name("tombstone:undead_boss");
        int weight = 0;
        LootHelper.addEnchantedEntry(builder, ModItems.magic_scroll, 100, new LootItemFunction.Builder[]{new DelayedNBTFunction.Builder()});
        weight += 100;
        LootHelper.addEntry(builder, (Item)ModItems.essence_of_undeath, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addEntry(builder, (Item)ModItems.familiar_stone, 50, new LootItemFunction.Builder[0]);
        weight += 50;
        LootHelper.addEntry(builder, (Item)ModItems.soul_receptacle, 50, new LootItemFunction.Builder[0]);
        weight += 50;
        for (Map.Entry<ItemScrollBuff.SpellBuff, Item> entry : ModItems.EnumItem.scroll_buff.entrySet()) {
            LootHelper.addEnchantedAncientEntry(builder, entry.getValue(), 10, new LootItemFunction.Builder[0]);
            weight += 10;
        }
        LootHelper.addEnchantedAncientEntry(builder, ModItems.magic_scroll, 50, new LootItemFunction.Builder[]{new DelayedNBTFunction.Builder()});
        weight += 50;
        LootHelper.addEntry(builder, (Item)ModItems.voodoo_poppet, 100, new LootItemFunction.Builder[]{new DelayedNBTFunction.Builder()});
        weight += 100;
        LootHelper.addEntry(builder, (Item)ModItems.familiar_receptacle, 100, new LootItemFunction.Builder[]{new DelayedNBTFunction.Builder()});
        if ((weight += 100) < 1000) {
            builder.m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79711_(0).m_79707_(1000 - weight));
        }
        return builder.m_79082_();
    }

    public static void handleMobDrops(Collection<ItemEntity> drops, LivingEntity entity, ServerPlayer player, DamageSource damageSource) {
        if (EntityHelper.isUndead(entity)) {
            LootContext.Builder builder = new LootContext.Builder(player.m_183503_()).m_78977_(entity.m_21187_()).m_78972_(LootContextParams.f_81460_, (Object)entity.m_20182_()).m_78963_(player.m_36336_()).m_78972_(LootContextParams.f_81455_, (Object)entity).m_78972_(LootContextParams.f_81457_, (Object)damageSource).m_78984_(LootContextParams.f_81458_, (Object)damageSource.m_7639_()).m_78984_(LootContextParams.f_81459_, (Object)damageSource.m_7640_());
            if (entity.f_20888_ != null) {
                builder = builder.m_78972_(LootContextParams.f_81456_, (Object)entity.f_20888_);
            }
            LootContext context = builder.m_78975_(LootContextParamSets.f_81415_);
            boolean isBoss = EntityHelper.isBoss(entity);
            UpdaterHandler.PoolType poolType = isBoss ? UpdaterHandler.PoolType.UNDEAD_BOSS : UpdaterHandler.PoolType.UNDEAD_MOB;
            int rolls = (isBoss ? 5 : 1) + (Helper.RANDOM.nextInt(100) <= EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.treasure_seeker) * 15 ? 1 : 0);
            IntStream.range(0, rolls).forEach(i -> {
                ItemStack stack = LootHelper.getLootTable(poolType).m_79129_(context).stream().findFirst().orElse(ItemStack.f_41583_);
                if (!stack.m_41619_()) {
                    if (stack.m_150930_((Item)ModItems.grave_dust)) {
                        ModTriggers.GRAVE_DUST_FROM_UNDEAD.trigger(player);
                    }
                    drops.add(new ItemEntity(entity.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), stack));
                }
            });
        }
        if (TimeHelper.isDateAroundHalloween() && EntityHelper.isEnemy((Entity)entity) && Helper.RANDOM.nextInt(1000) < 50) {
            drops.add(new ItemEntity(entity.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), ModItems.lollipop.getRandomItemStack()));
        }
    }

    private static boolean addPool(LootTable table, LootPool lootPool) {
        List<LootPool> pools = ((LootTableAccessor)table).getPools();
        String poolName = lootPool.getName();
        if (pools.stream().noneMatch(p -> p == lootPool || poolName.equals(p.getName()))) {
            pools.add(lootPool);
            return true;
        }
        return false;
    }

    public static LootTable getLootTable(UpdaterHandler.PoolType poolType) {
        return CUSTOM_LOOTTABLES.getOrDefault((Object)poolType, LootTable.f_79105_);
    }

    private static void initLostTreasureLootTable(LootTable lootTable) {
        LootPool lootPool = UpdaterHandler.instance.loadLootPool(UpdaterHandler.PoolType.LOST_TREASURE);
        if (lootPool == null) {
            lootPool = LootHelper.getLostTreasureLootPool();
            UpdaterHandler.instance.saveLootPool(UpdaterHandler.PoolType.LOST_TREASURE, lootPool);
        }
        LootHelper.addPool(lootTable, lootPool);
        ModTombstone.LOGGER.debug("Injecting Lost Treasure LootTable");
    }

    private static void initCatMorningLootTable(LootTable lootTable) {
        LootPool lootPool = UpdaterHandler.instance.loadLootPool(UpdaterHandler.PoolType.CAT_MORNING);
        if (lootPool == null) {
            lootPool = LootHelper.getCatMorningLootPool();
            UpdaterHandler.instance.saveLootPool(UpdaterHandler.PoolType.CAT_MORNING, lootPool);
        }
        LootHelper.addPool(lootTable, lootPool);
        ModTombstone.LOGGER.debug("Injecting Cat Morning LootTable");
    }

    private static void initChestTreasureLootTable() {
        if (CHEST_TABLES.size() > 0) {
            LootPool lootPool = UpdaterHandler.instance.loadLootPool(UpdaterHandler.PoolType.CHEST_TREASURE);
            if (lootPool == null) {
                lootPool = LootHelper.getChestTreasureLootPool();
                UpdaterHandler.instance.saveLootPool(UpdaterHandler.PoolType.CHEST_TREASURE, lootPool);
            }
            for (LootTable lootTable : CHEST_TABLES) {
                LootHelper.addPool(lootTable, lootPool);
            }
            CHEST_TABLES.clear();
            ModTombstone.LOGGER.debug("Injecting Treasure Chest LootTable");
        }
    }

    private static void initCustomLootTables() {
        UpdaterHandler.PoolType[] poolTypes;
        for (UpdaterHandler.PoolType poolType : poolTypes = new UpdaterHandler.PoolType[]{UpdaterHandler.PoolType.UNDEAD_MOB, UpdaterHandler.PoolType.UNDEAD_BOSS}) {
            LootPool lootPool = UpdaterHandler.instance.loadLootPool(poolType);
            if (lootPool == null) {
                lootPool = LootHelper.getDefaultLootPool(poolType);
                UpdaterHandler.instance.saveLootPool(poolType, lootPool);
            }
            LootTable lootTable = new LootTable.Builder().m_79167_();
            lootTable.setLootTableId(new ResourceLocation("tombstone", poolType.getFilename()));
            CUSTOM_LOOTTABLES.put(poolType, lootTable);
            LootHelper.addPool(lootTable, lootPool);
        }
    }

    private static LootPool getDefaultLootPool(UpdaterHandler.PoolType poolType) {
        return switch (poolType) {
            default -> throw new IncompatibleClassChangeError();
            case UpdaterHandler.PoolType.LOST_TREASURE -> LootHelper.getLostTreasureLootPool();
            case UpdaterHandler.PoolType.CAT_MORNING -> LootHelper.getCatMorningLootPool();
            case UpdaterHandler.PoolType.CHEST_TREASURE -> LootHelper.getChestTreasureLootPool();
            case UpdaterHandler.PoolType.UNDEAD_MOB -> LootHelper.getUndeadMobLootPool();
            case UpdaterHandler.PoolType.UNDEAD_BOSS -> LootHelper.getUndeadBossLootPool();
        };
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLootTableLoad(LootTableLoadEvent event) {
        if (event.getName().equals((Object)BuiltInLootTables.f_78721_)) {
            CallbackHandler.addFastCallback(() -> {
                LootHelper.initCustomLootTables();
                LootHelper.initLostTreasureLootTable(event.getTable());
                LootHelper.initChestTreasureLootTable();
            });
        } else if (event.getName().equals((Object)BuiltInLootTables.f_78724_)) {
            CallbackHandler.addFastCallback(() -> LootHelper.initCatMorningLootTable(event.getTable()));
        } else if (Optional.of(event.getName()).map(rl -> !event.getName().equals((Object)BuiltInLootTables.f_78740_) && (rl.m_135827_().equals("minecraft") ? rl.m_135815_().startsWith("chests") && !rl.m_135815_().startsWith("chests/village/") && !rl.m_135815_().contains("supply") : rl.m_135815_().contains("chest") && !rl.m_135815_().contains("supply"))).orElse(false).booleanValue()) {
            CHEST_TABLES.add(event.getTable());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDrops(LivingDropsEvent event) {
        if (event.getEntityLiving() != null && !event.getEntityLiving().f_19853_.m_5776_() && event.getEntityLiving().m_6095_() != EntityType.f_20532_) {
            Optional.ofNullable(event.getSource()).filter(d -> EntityHelper.isValidServerPlayer(d.m_7639_())).map(d -> (ServerPlayer)d.m_7639_()).ifPresent(player -> LootHelper.handleMobDrops(event.getDrops(), event.getEntityLiving(), player, event.getSource()));
        }
    }
}

