/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModPerks;

public final class PlayerStatusHandler {
    private static final Map<UUID, PlayerStatus> PLAYER_STATUS = new ConcurrentHashMap<UUID, PlayerStatus>();

    public static PlayerStatus getPlayerStatus(ServerPlayer player) {
        return PLAYER_STATUS.computeIfAbsent(player.m_36316_().getId(), uuid -> PlayerStatusHandler.createStatus(player));
    }

    private static PlayerStatus createStatus(ServerPlayer player) {
        int lvl;
        double modifierDiscretion = Optional.ofNullable(player.m_21124_(ModEffects.discretion)).map(effect -> Mth.m_14008_((double)((double)(effect.m_19564_() + 1) * 0.1), (double)0.01, (double)1.0)).orElse(0.0);
        double modifierHighPriority = 1.0 - modifierDiscretion;
        if (!player.m_20159_() && (lvl = EntityHelper.getShadowStepLevel((Player)player)) > 0) {
            double shadowStepModifier = (double)lvl / ((double)ModEnchantments.shadow_step.m_6586_() * 2.0);
            modifierHighPriority *= Mth.m_14008_((double)((double)player.m_6073_() - shadowStepModifier), (double)0.01, (double)1.0);
        }
        if ((lvl = EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.shadow_walker)) > 0) {
            modifierHighPriority *= 1.0 - (double)lvl * 0.1;
        }
        double modifierLowPriority = 1.0;
        if (EffectHelper.isPotionActive((LivingEntity)player, ModEffects.diversion) || EffectHelper.isPotionActive((LivingEntity)player, ModEffects.ghostly_shape)) {
            modifierLowPriority = 0.0;
        } else {
            MobEffectInstance bait = player.m_21124_(ModEffects.bait);
            if (bait != null) {
                modifierLowPriority *= Math.min((double)bait.m_19564_() + 1.0, 2.0);
            }
        }
        return new PlayerStatus(modifierHighPriority, modifierLowPriority);
    }

    public static void clear() {
        PLAYER_STATUS.clear();
    }

    public record PlayerStatus(double visibleFactorHighPriority, double visibleFactorLowPriority) {
    }
}

