/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ConfiguredStructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.helper.Helper;

public final class SupportStructures
extends Enum<SupportStructures> {
    public static final /* enum */ SupportStructures VILLAGE = new SupportStructures("village", ConfiguredStructureTags.f_207637_);
    public static final /* enum */ SupportStructures DESERT_TEMPLE = new SupportStructures("desert_pyramid", BuiltinStructures.f_209850_);
    public static final /* enum */ SupportStructures IGLOO_TEMPLE = new SupportStructures("igloo", BuiltinStructures.f_209851_);
    public static final /* enum */ SupportStructures JUNGLE_TEMPLE = new SupportStructures("jungle_pyramid", BuiltinStructures.f_209849_);
    public static final /* enum */ SupportStructures MANSION = new SupportStructures("mansion", BuiltinStructures.f_209848_);
    public static final /* enum */ SupportStructures MONUMENT = new SupportStructures("monument", BuiltinStructures.f_209856_);
    public static final /* enum */ SupportStructures STRONGHOLD = new SupportStructures("stronghold", BuiltinStructures.f_209855_, 35);
    public static final /* enum */ SupportStructures END_CITY = new SupportStructures("end_city", BuiltinStructures.f_209861_);
    public static final /* enum */ SupportStructures MINESHAFT = new SupportStructures("mineshaft", ConfiguredStructureTags.f_207638_, 37);
    public static final /* enum */ SupportStructures FORTRESS = new SupportStructures("fortress", BuiltinStructures.f_209859_, 35);
    public static final /* enum */ SupportStructures SWAMP_HUT = new SupportStructures("swamp_hut", BuiltinStructures.f_209854_);
    public static final /* enum */ SupportStructures OCEAN_RUIN = new SupportStructures("ocean_ruin", ConfiguredStructureTags.f_207641_);
    public static final /* enum */ SupportStructures BURIED_TREASURE = new SupportStructures("buried_treasure", BuiltinStructures.f_209862_);
    public static final /* enum */ SupportStructures SHIPWRECK = new SupportStructures("shipwreck", ConfiguredStructureTags.f_207639_);
    public static final /* enum */ SupportStructures PILLAGER_OUTPOST = new SupportStructures("pillager_outpost", BuiltinStructures.f_209845_);
    public static final /* enum */ SupportStructures RUINED_PORTAL = new SupportStructures("ruined_portal", ConfiguredStructureTags.f_207640_);
    public static final /* enum */ SupportStructures NETHER_FOSSIL = new SupportStructures("nether_fossil", BuiltinStructures.f_209860_);
    public static final /* enum */ SupportStructures BASTION_REMNANT = new SupportStructures("bastion_remnant", BuiltinStructures.f_209863_, 35);
    private static final Map<ResourceKey<Level>, Object2BooleanMap<ResourceLocation>> STRUCTURES_BY_WORLD;
    private static final Map<String, Component> STRUCTURE_NAMES;
    public static final int DEFAULT_Y = 68;
    private final String identifier;
    @Nullable
    private TagKey<ConfiguredStructureFeature<?, ?>> tagKey = null;
    @Nullable
    private ResourceKey<ConfiguredStructureFeature<?, ?>> resourceKey = null;
    private final int y;
    private static final /* synthetic */ SupportStructures[] $VALUES;

    public static SupportStructures[] values() {
        return (SupportStructures[])$VALUES.clone();
    }

    public static SupportStructures valueOf(String name) {
        return Enum.valueOf(SupportStructures.class, name);
    }

    private SupportStructures(String identifier, ResourceKey<ConfiguredStructureFeature<?, ?>> tagKey) {
        this(identifier, tagKey, 68);
    }

    private SupportStructures(String identifier, ResourceKey<ConfiguredStructureFeature<?, ?>> resourceKey, int y) {
        this.identifier = identifier;
        this.resourceKey = resourceKey;
        this.y = y;
    }

    private SupportStructures(String identifier, TagKey<ConfiguredStructureFeature<?, ?>> tagKey) {
        this(identifier, tagKey, 68);
    }

    private SupportStructures(String identifier, TagKey<ConfiguredStructureFeature<?, ?>> tagKey, int y) {
        this.identifier = identifier;
        this.tagKey = tagKey;
        this.y = y;
    }

    public String getName() {
        return this.identifier;
    }

    public boolean is(String structureId) {
        Pair<String, String> rl = Helper.parseRLString(structureId);
        return this.is((String)rl.getLeft(), (String)rl.getRight());
    }

    public boolean is(ResourceLocation structureId) {
        return this.is(structureId.m_135827_(), structureId.m_135815_());
    }

    public boolean is(String domain, String path) {
        return SupportStructures.isVanillaDomain(domain) && path.contains(this.getName());
    }

    public int getY() {
        return this.y;
    }

    public HolderSet<ConfiguredStructureFeature<?, ?>> asHolderSet(ServerLevel level) {
        if (this.tagKey != null) {
            return (HolderSet)Helper.asHolderSet(level, this.tagKey).get();
        }
        assert (this.resourceKey != null);
        HolderSet<ConfiguredStructureFeature<?, ?>> res = Helper.asHolderSet(level, this.resourceKey);
        assert (res != null);
        return res;
    }

    private static boolean isVanillaDomain(String domain) {
        return "minecraft".equals(domain);
    }

    @Nullable
    private static SupportStructures getVanillaStructure(String domain, String path) {
        return SupportStructures.isVanillaDomain(domain) ? (SupportStructures)Stream.of(SupportStructures.values()).filter(p -> p.is(path)).findFirst().orElse(null) : null;
    }

    public static int getY(ResourceLocation structureRL) {
        return SupportStructures.getY(structureRL.m_135827_(), structureRL.m_135815_());
    }

    public static int getY(String structureRLString) {
        Pair<String, String> rl = Helper.parseRLString(structureRLString);
        return SupportStructures.getY((String)rl.getLeft(), (String)rl.getRight());
    }

    public static int getY(String domain, String path) {
        SupportStructures struct = SupportStructures.getVanillaStructure(domain, path);
        return struct != null ? struct.getY() : (domain.equals("quark") ? 37 : 68);
    }

    @Nullable
    public static HolderSet<ConfiguredStructureFeature<?, ?>> getRandomVanillaStructure(ServerLevel level, Predicate<SupportStructures> predic) {
        return Helper.getRandomInList(Arrays.stream(SupportStructures.values()).filter(predic).collect(Collectors.toList())).map(supportStructures -> supportStructures.asHolderSet(level)).orElse(null);
    }

    @Nullable
    public static HolderSet<ConfiguredStructureFeature<?, ?>> getRandomStructure(ServerLevel level, Predicate<ResourceLocation> predic) {
        ResourceLocation resourceLocation = Helper.getRandomInList(level.m_5962_().m_175515_(Registry.f_122840_).m_6566_().stream().filter(predic).collect(Collectors.toList())).orElse(null);
        if (resourceLocation != null) {
            SupportStructures supportStructures;
            if (SupportStructures.isVanillaDomain(resourceLocation.m_135827_()) && (supportStructures = (SupportStructures)Arrays.stream(SupportStructures.values()).filter(struct -> struct.is(resourceLocation)).findFirst().orElse(null)) != null) {
                return supportStructures.asHolderSet(level);
            }
            return Helper.asHolderSet(level, resourceLocation);
        }
        return null;
    }

    public static void clear() {
        STRUCTURES_BY_WORLD.clear();
        STRUCTURE_NAMES.clear();
    }

    public static boolean hasStructureInWorld(ServerLevel level, ResourceLocation structureRL, HolderSet<Biome> structureBiomes) {
        return STRUCTURES_BY_WORLD.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), levelRL -> new Object2BooleanOpenHashMap()).computeIfAbsent((Object)structureRL, rl -> {
            Set possibleBiomes = level.m_7726_().m_8481_().m_62218_().m_207840_();
            return structureBiomes.m_203614_().anyMatch(possibleBiomes::contains);
        });
    }

    public static List<ServerLevel> getPossibleWorlds(MinecraftServer server, ResourceLocation structureRL, HolderSet<Biome> structureBiomes) {
        return StreamSupport.stream(server.m_129785_().spliterator(), false).filter(world -> SupportStructures.hasStructureInWorld(world, structureRL, structureBiomes)).collect(Collectors.toList());
    }

    public static Component getStructureName(String structureId) {
        return STRUCTURE_NAMES.computeIfAbsent(structureId, k -> {
            String[] splits = structureId.toLowerCase(Locale.US).split(":");
            TextComponent structureName = new TextComponent(Helper.capitalizeWord(splits[splits.length - 1]));
            return splits.length < 2 || "minecraft".equals(splits[0]) ? structureName : structureName.m_130946_(" [").m_130946_(splits[0]).m_130946_("]");
        });
    }

    private static /* synthetic */ SupportStructures[] $values() {
        return new SupportStructures[]{VILLAGE, DESERT_TEMPLE, IGLOO_TEMPLE, JUNGLE_TEMPLE, MANSION, MONUMENT, STRONGHOLD, END_CITY, MINESHAFT, FORTRESS, SWAMP_HUT, OCEAN_RUIN, BURIED_TREASURE, SHIPWRECK, PILLAGER_OUTPOST, RUINED_PORTAL, NETHER_FOSSIL, BASTION_REMNANT};
    }

    static {
        $VALUES = SupportStructures.$values();
        STRUCTURES_BY_WORLD = new ConcurrentHashMap<ResourceKey<Level>, Object2BooleanMap<ResourceLocation>>();
        STRUCTURE_NAMES = new ConcurrentHashMap<String, Component>();
    }
}

