/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.CastingType;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModSounds;

public abstract class ItemCastableMagic
extends ItemGeneric {
    protected static final Map<UUID, Long> USING = new ConcurrentHashMap<UUID, Long>();
    protected static final Map<UUID, LivingEntity> TARGET = new ConcurrentHashMap<UUID, LivingEntity>();
    protected static final String COOLDOWN_TIME_NBT_LONG = "cooldown_time";

    protected ItemCastableMagic(String name, Item.Properties builder, BooleanSupplier supplierEnabled) {
        super(name, builder, supplierEnabled);
    }

    public Component m_7626_(ItemStack stack) {
        return super.m_7626_(stack).m_6879_().m_6270_(StyleType.MESSAGE_SPECIAL);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return EntityHelper.isValidPlayer(context.m_43723_()) && this.getCastingTarget(stack) != CastingTarget.TARGET_ONLY ? (this.canBlockInteractFirst(context.m_43725_(), context.m_8083_(), stack) ? InteractionResult.PASS : this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_()) : InteractionResult.FAIL;
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        CastingTarget castingTarget = this.getCastingTarget(stack);
        if (castingTarget == CastingTarget.TARGET_OR_SELF || castingTarget == CastingTarget.TARGET_ONLY) {
            if (this.isTargetForCasting(player, target)) {
                if (this.canAffectTarget(stack, target)) {
                    UUID uuid = player.m_36316_().getId();
                    TARGET.put(uuid, target);
                    InteractionResult result = this.m_7203_(player.m_183503_(), player, hand).m_19089_();
                    if (result.m_19080_()) {
                        return InteractionResult.SUCCESS;
                    }
                    TARGET.remove(uuid);
                    return result;
                }
                if (!player.f_19853_.m_5776_()) {
                    LangKey.MESSAGE_CANT_APPLY_EFFECT.sendMessage(player, target.m_7755_());
                }
                EntityHelper.setGlobalItemCooldown(player, this, 10);
                return InteractionResult.SUCCESS;
            }
            if (castingTarget == CastingTarget.TARGET_ONLY) {
                return InteractionResult.SUCCESS;
            }
        }
        return this.m_7203_(player.m_183503_(), player, hand).m_19089_();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        if (this.getCastingTarget(heldStack) == CastingTarget.TARGET_ONLY && TARGET.get(player.m_36316_().getId()) == null || !EntityHelper.isValidPlayer(player)) {
            return InteractionResultHolder.m_19100_((Object)heldStack);
        }
        if (!heldStack.m_150930_((Item)this)) {
            return InteractionResultHolder.m_19098_((Object)heldStack);
        }
        if (EntityHelper.hasGlobalItemCooldown(player, this)) {
            return InteractionResultHolder.m_19096_((Object)heldStack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19090_((Object)heldStack);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        super.m_5551_(stack, level, entity, timeLeft);
        this.resetCasting((Player)entity);
    }

    public ItemStack m_5922_(ItemStack stack, @Nullable Level level, LivingEntity entity) {
        if (EntityHelper.isValidPlayer((Entity)entity)) {
            ServerPlayer player;
            if (stack.m_150930_((Item)this) && EntityHelper.noGlobalItemCooldown((Player)entity, this) && !entity.m_183503_().m_5776_() && this.doEffects((player = (ServerPlayer)entity).m_183503_(), player, stack, TARGET.get(player.m_36316_().getId()))) {
                ModSounds.playSoundAllAround(ModSounds.MAGIC_USE01, SoundSource.PLAYERS, (Level)player.m_183503_(), player.m_142538_(), 0.5f, 0.5f);
                if (!player.m_150110_().f_35937_ && this.canConsumeOnUse()) {
                    stack = this.onConsumeItem((Player)player, stack);
                }
            }
            EntityHelper.setGlobalItemCooldown((Player)entity, this, 10);
            this.resetCasting((Player)entity);
        }
        return stack;
    }

    protected ItemStack onConsumeItem(Player player, ItemStack stack) {
        if (stack.m_41613_() > 1) {
            stack.m_41774_(1);
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int timeLeft) {
        boolean isStarting;
        if (!stack.m_150930_((Item)this) || !EntityHelper.isValidPlayer((Entity)entity)) {
            return;
        }
        Player player = (Player)entity;
        boolean bl = isStarting = timeLeft == this.m_8105_(stack);
        if (isStarting) {
            int concentrationLevel = player.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(cap -> cap.getPerkLevelWithBonus(player, ModPerks.concentration)).orElse(0);
            USING.put(player.m_36316_().getId(), TimeHelper.systemTime() + (long)((float)TimeUnit.SECONDS.toMillis(1L) * ((float)this.m_8105_(stack) / 20.0f * (1.0f - (float)concentrationLevel * 0.15f))));
            if (player.f_19853_.m_5776_()) {
                this.produceParticleCasting(stack, player);
            } else {
                ModSounds.playSoundAllAround(SoundEvents.f_11862_, SoundSource.PLAYERS, player.m_183503_(), player.m_142538_(), 0.5f, 0.5f);
            }
        } else if (!player.f_19853_.m_5776_() && USING.containsKey(player.m_36316_().getId()) && USING.get(player.m_36316_().getId()) < TimeHelper.systemTime() && player.m_6117_() && player.m_21211_().m_150930_((Item)this)) {
            ItemStack resultStack = ForgeEventFactory.onItemUseFinish((LivingEntity)player, (ItemStack)player.m_21211_().m_41777_(), (int)0, (ItemStack)player.m_21211_().m_41671_(player.f_19853_, (LivingEntity)player));
            if (resultStack != player.m_21211_()) {
                player.m_21008_(player.m_7655_(), resultStack);
            }
            player.m_5810_();
        }
    }

    protected void produceParticleCasting(ItemStack stack, Player player) {
        ModTombstone.PROXY.produceParticleCasting(CastingType.SCROLL, Optional.ofNullable(TARGET.get(player.m_36316_().getId())).orElse((LivingEntity)player), p -> !player.m_6117_() || player.m_21252_() == 1);
    }

    public int m_8105_(ItemStack stack) {
        return 80;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    protected abstract boolean doEffects(ServerLevel var1, ServerPlayer var2, ItemStack var3, @Nullable LivingEntity var4);

    protected boolean canBlockInteractFirst(Level level, BlockPos pos, ItemStack stack) {
        return false;
    }

    protected boolean isTargetForCasting(Player player, @Nullable LivingEntity target) {
        return false;
    }

    protected boolean canAffectTarget(ItemStack stack, LivingEntity target) {
        return true;
    }

    protected boolean canConsumeOnUse() {
        return true;
    }

    protected CastingTarget getCastingTarget(ItemStack stack) {
        return CastingTarget.SELF;
    }

    private void resetCasting(Player player) {
        UUID uuid = player.m_36316_().getId();
        USING.remove(uuid);
        TARGET.remove(uuid);
    }

    protected static Item.Properties getBuilder() {
        return ItemGeneric.getBuilder().m_41487_(1).m_41486_();
    }

    static enum CastingTarget {
        SELF,
        AREA,
        TARGET_ONLY,
        TARGET_OR_SELF;

    }
}

