/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.spawner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.village.VillageSiegeEvent;
import net.minecraftforge.eventbus.api.Event;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.event.EventFactory;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;

public final class CustomVillageSiege
extends VillageSiege {
    private SiegeState siegeState = SiegeState.SIEGE_END;
    private boolean hasFailedTrySiege = false;
    private int nextSpawnTime = 0;
    private int siegeCount = 0;
    private int spawnX;
    private int spawnY;
    private int spawnZ;

    private static void sendDevLog(String message) {
        if (((Boolean)ConfigTombstone.village_siege.logSiegeState.get()).booleanValue()) {
            ModTombstone.LOGGER.info(message);
        }
    }

    public boolean startSiege(int chance) {
        if (this.siegeState == SiegeState.SIEGE_START || this.siegeState == SiegeState.SPAWN_MOBS) {
            CustomVillageSiege.sendDevLog("A siege is already in progress");
            return false;
        }
        CustomVillageSiege.sendDevLog("Launching a village siege");
        if (Helper.RANDOM.nextInt(100) < chance) {
            this.siegeState = SiegeState.SIEGE_START;
            CustomVillageSiege.sendDevLog("Random chance: Siege started");
        } else {
            this.siegeState = SiegeState.SIEGE_END;
            CustomVillageSiege.sendDevLog("Random chance: Siege aborted");
        }
        this.hasFailedTrySiege = false;
        return this.siegeState == SiegeState.SIEGE_START;
    }

    public boolean stopSiege() {
        if (this.siegeState == SiegeState.SIEGE_END) {
            CustomVillageSiege.sendDevLog("No siege in progress");
            return false;
        }
        this.siegeState = SiegeState.SIEGE_END;
        this.hasFailedTrySiege = false;
        return true;
    }

    public int m_7995_(ServerLevel serverLevel, boolean spawnHostileMobs, boolean spawnPeacefulMobs) {
        if (!serverLevel.m_46461_() && spawnHostileMobs) {
            float angle = serverLevel.m_46942_(0.0f);
            if ((double)angle == 0.5) {
                this.startSiege((Integer)ConfigTombstone.village_siege.siegeChance.get());
            }
            if (this.siegeState == SiegeState.SIEGE_END) {
                return 0;
            }
            if (this.siegeState == SiegeState.SIEGE_START) {
                if ((Integer)ConfigTombstone.village_siege.delaySiegeTest.get() > 0 && this.hasFailedTrySiege && !TimeHelper.atInterval((Level)serverLevel, (int)((Integer)ConfigTombstone.village_siege.delaySiegeTest.get()))) {
                    return 0;
                }
                if (!this.trySetupSiege(serverLevel)) {
                    return 0;
                }
                if (EventFactory.onVillageSiegeStart(serverLevel, new BlockPos(this.spawnX, this.spawnY, this.spawnZ))) {
                    CustomVillageSiege.sendDevLog("Try to siege: tombstone event canceled");
                    return 0;
                }
                this.siegeState = SiegeState.SPAWN_MOBS;
                CustomVillageSiege.sendDevLog("Spawning " + ConfigTombstone.village_siege.siegeMaxCreature.get() + " zombie" + ((Integer)ConfigTombstone.village_siege.siegeMaxCreature.get() > 1 ? "s" : ""));
            }
            if (this.siegeState == SiegeState.SPAWN_MOBS) {
                if (this.nextSpawnTime > 0) {
                    --this.nextSpawnTime;
                    return 0;
                }
                this.nextSpawnTime = 2;
                if (this.siegeCount > 0) {
                    this.spawnZombie(serverLevel);
                    --this.siegeCount;
                } else {
                    this.siegeState = SiegeState.SIEGE_END;
                    CustomVillageSiege.sendDevLog("Siege ended");
                }
            }
            return 1;
        }
        this.siegeState = SiegeState.SIEGE_END;
        this.hasFailedTrySiege = false;
        return 0;
    }

    private boolean trySetupSiege(ServerLevel serverLevel) {
        ArrayList playerList = new ArrayList(serverLevel.m_6907_());
        if (((Boolean)ConfigTombstone.village_siege.shufflePlayersForSiege.get()).booleanValue()) {
            Collections.shuffle(playerList, Helper.RANDOM);
        }
        for (ServerPlayer player : playerList) {
            BlockPos blockpos;
            if (player.m_5833_() || player.m_7500_() && !((Boolean)ConfigTombstone.village_siege.allowCreativePlayersForSiege.get()).booleanValue() || !serverLevel.m_8802_(blockpos = player.m_142538_()) || Biome.m_204183_((Holder)serverLevel.m_204166_(blockpos)) == Biome.BiomeCategory.MUSHROOM) continue;
            float angle = serverLevel.f_46441_.nextFloat() * ((float)Math.PI * 2);
            float radius = 32.0f;
            this.spawnX = blockpos.m_123341_() + Mth.m_14143_((float)(Mth.m_14089_((float)angle) * radius));
            this.spawnY = blockpos.m_123342_();
            this.spawnZ = blockpos.m_123343_() + Mth.m_14143_((float)(Mth.m_14031_((float)angle) * radius));
            Vec3 siegeLocation = this.findRandomSpawnPos(serverLevel, new BlockPos(this.spawnX, this.spawnY, this.spawnZ));
            if (siegeLocation == null) continue;
            if (MinecraftForge.EVENT_BUS.post((Event)new VillageSiegeEvent((VillageSiege)this, (Level)serverLevel, (Player)player, siegeLocation))) {
                CustomVillageSiege.sendDevLog("Try to siege: forge event canceled");
                break;
            }
            this.nextSpawnTime = 0;
            this.siegeCount = (Integer)ConfigTombstone.village_siege.siegeMaxCreature.get();
            return true;
        }
        this.hasFailedTrySiege = true;
        CustomVillageSiege.sendDevLog("Try to siege: failed");
        return false;
    }

    private void spawnZombie(ServerLevel serverLevel) {
        Vec3 vec3 = this.findRandomSpawnPos(serverLevel, new BlockPos(this.spawnX, this.spawnY, this.spawnZ));
        if (vec3 != null) {
            Zombie mob = (Zombie)EntityType.f_20501_.m_20615_((Level)serverLevel);
            if (mob == null) {
                return;
            }
            mob.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(mob.m_142538_()), MobSpawnType.EVENT, null, null);
            if (((Boolean)ConfigTombstone.village_siege.persistentMobInSiege.get()).booleanValue()) {
                mob.m_21530_();
            }
            if (((Boolean)ConfigTombstone.village_siege.undeadWearHelmInSiege.get()).booleanValue() && mob.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
                Difficulty difficulty = serverLevel.m_46791_();
                mob.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)(difficulty == Difficulty.HARD ? Items.f_42472_ : (difficulty == Difficulty.NORMAL ? Items.f_42468_ : Items.f_42407_))));
            }
            mob.m_7678_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, serverLevel.f_46441_.nextFloat() * 360.0f, 0.0f);
            if (EventFactory.onVillageSiegeZombieSpawn(serverLevel, mob)) {
                return;
            }
            mob.getPersistentData().m_128379_("siege", true);
            serverLevel.m_47205_((Entity)mob);
            if (((Boolean)ConfigTombstone.village_siege.glowingCreatureTest.get()).booleanValue()) {
                EffectHelper.addEffect((LivingEntity)mob, MobEffects.f_19619_, 10000);
            }
        }
    }

    @Nullable
    private Vec3 findRandomSpawnPos(ServerLevel serverWorld, BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            int z;
            int y;
            int x = pos.m_123341_() + serverWorld.f_46441_.nextInt(16) - 8;
            BlockPos blockpos = new BlockPos(x, y = serverWorld.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z = pos.m_123343_() + serverWorld.f_46441_.nextInt(16) - 8), z);
            if (!serverWorld.m_8802_(blockpos) || !Monster.m_33017_((EntityType)EntityType.f_20501_, (ServerLevelAccessor)serverWorld, (MobSpawnType)MobSpawnType.EVENT, (BlockPos)blockpos, (Random)serverWorld.f_46441_)) continue;
            return Vec3.m_82539_((Vec3i)blockpos);
        }
        return null;
    }

    public static enum SiegeState {
        SIEGE_START,
        SIEGE_END,
        SPAWN_MOBS;

    }
}

