/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.tileentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.block.BlockDecorativeGrave;
import ovh.corail.tombstone.block.SoulType;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.entity.GraveGuardian;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEntities;
import ovh.corail.tombstone.tileentity.BlockWritableGrave;

public final class BlockEntityDecorativeGrave
extends BlockWritableGrave {
    private long lastCheckSoul = -1L;

    public BlockEntityDecorativeGrave(BlockPos pos, BlockState state) {
        super(ModBlocks.tile_decorative_grave, pos, state);
    }

    @Override
    public boolean canShowFog() {
        return super.canShowFog() && this.f_58857_ != null && ((ConfigTombstone.Client.FogPeriod)ConfigTombstone.client.fogPeriod.get()).test(this.f_58857_);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, BlockEntityDecorativeGrave grave) {
        SoulType soulType;
        BlockEntityDecorativeGrave.commonTick(level, pos, state, grave);
        if (TimeHelper.atInterval(grave.countTicks, 25) && (soulType = (SoulType)((Object)state.m_61143_(BlockDecorativeGrave.SOUL_TYPE))).hasSoul()) {
            ModTombstone.PROXY.produceGraveSoul(level, pos, soulType, (int)((long)grave.countTicks % 100L) / 25);
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BlockEntityDecorativeGrave grave) {
        BlockEntityDecorativeGrave.commonTick(level, pos, state, grave);
        long worldTicks = TimeHelper.worldTicks(level);
        if (grave.lastCheckSoul <= 0L || grave.lastCheckSoul > worldTicks) {
            grave.lastCheckSoul = worldTicks;
            return;
        }
        long elapsedMinutes = TimeHelper.minuteElapsed(worldTicks, grave.lastCheckSoul);
        if (elapsedMinutes >= (long)((Integer)ConfigTombstone.decorative_grave.timeSoul.get()).intValue()) {
            if (((SoulType)((Object)state.m_61143_(BlockDecorativeGrave.SOUL_TYPE))).hasSoul()) {
                grave.resetCheckSoul();
                return;
            }
            long count = elapsedMinutes / (long)((Integer)ConfigTombstone.decorative_grave.timeSoul.get()).intValue();
            grave.lastCheckSoul += count * (long)TimeHelper.tickFromMinute((Integer)ConfigTombstone.decorative_grave.timeSoul.get());
            double chance = 1.0 - Math.pow(1.0 - (double)((Integer)ConfigTombstone.decorative_grave.chanceSoul.get()).intValue() / 1000.0, count);
            if (chance >= 1.0 || Helper.RANDOM.nextDouble() <= chance) {
                SoulType soulType;
                LightningBolt bolt;
                if (elapsedMinutes == (long)((Integer)ConfigTombstone.decorative_grave.timeSoul.get()).intValue() && (bolt = (LightningBolt)EntityType.f_20465_.m_20615_(level)) != null) {
                    bolt.m_20219_(Vec3.m_82539_((Vec3i)pos));
                    bolt.m_20874_(true);
                    level.m_7967_((Entity)bolt);
                }
                if ((soulType = SoulType.generateSoulType()) == SoulType.STRONG && ((Boolean)ConfigTombstone.decorative_grave.allowGraveGardian.get()).booleanValue() && Helper.RANDOM.nextBoolean() && level.m_6443_(GraveGuardian.class, new AABB(pos).m_82377_((double)((Integer)ConfigTombstone.decorative_grave.distanceBetweenGraveGuardian.get()).intValue(), 20.0, (double)((Integer)ConfigTombstone.decorative_grave.distanceBetweenGraveGuardian.get()).intValue()), entity -> true).isEmpty()) {
                    GraveGuardian graveGuardian = (GraveGuardian)ModEntities.grave_guardian.m_20615_(level);
                    if (graveGuardian != null) {
                        graveGuardian.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                        graveGuardian.m_6518_((ServerLevelAccessor)level, level.m_6436_(pos), MobSpawnType.TRIGGERED, null, null);
                        level.m_7967_((Entity)graveGuardian);
                    }
                } else {
                    level.m_46597_(pos, (BlockState)state.m_61124_(BlockDecorativeGrave.SOUL_TYPE, (Comparable)((Object)soulType)));
                }
            }
        }
    }

    public void resetCheckSoul() {
        this.lastCheckSoul = -1L;
    }

    @Override
    protected CompoundTag writeShared(CompoundTag compound) {
        super.writeShared(compound);
        if (this.lastCheckSoul > 0L) {
            compound.m_128356_("lastCheckSoul", this.lastCheckSoul);
        }
        return compound;
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128425_("lastCheckSoul", 4)) {
            this.lastCheckSoul = compound.m_128454_("lastCheckSoul");
        }
    }
}

