/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.command.CommandTBAcceptTeleport;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TimeHelper;

public final class CommandTBRequestTeleport
extends TombstoneCommand {
    @Override
    protected TombstoneCommand.CommandName getCommandName() {
        return TombstoneCommand.CommandName.REQUEST_TELEPORT;
    }

    @Override
    protected Predicate<CommandSourceStack> getInitialRequirement() {
        return p -> (Integer)ConfigTombstone.general.cooldownRequestTeleport.get() >= 0 || this.defaultPermission.test(p);
    }

    @Override
    LiteralArgumentBuilder<CommandSourceStack> getBuilder(LiteralArgumentBuilder<CommandSourceStack> builder) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.executes(this::showUsage)).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(this::requestTeleport));
    }

    private int requestTeleport(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"target");
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        if (player.equals((Object)target)) {
            throw LangKey.MESSAGE_TELEPORT_SAME_PLAYER.asCommandException(new Object[0]);
        }
        CommandTBRequestTeleport.checkAlive((Entity)target);
        CommandTBRequestTeleport.checkNotSpectator((Entity)target);
        int cd = CooldownHandler.INSTANCE.getCooldown((Player)player, CooldownType.REQUEST_TELEPORT);
        if (cd > 0) {
            LangKey.MESSAGE_COMMAND_IN_COOLDOWN.sendMessage((Player)player, TimeHelper.getTimeStringWithUnit(cd));
            return 0;
        }
        CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.REQUEST_TELEPORT);
        CommandTBAcceptTeleport.addTicket((Player)target, (Player)player, Math.max(120, (Integer)ConfigTombstone.general.cooldownRequestTeleport.get() * 60));
        LangKey.MESSAGE_REQUEST_TO_JOIN_RECEIVER.sendSpecialMessage((Player)target, LangKey.MESSAGE_HERE.createComponentCommand("/tbacceptteleport " + player.m_36316_().getId(), new Object[0]), player.m_7755_());
        LangKey.MESSAGE_REQUEST_TO_JOIN_SENDER.sendMessage((Player)player, target.m_7755_());
        return 1;
    }
}

