/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.effect;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.effect.FeatherFallEffect;
import ovh.corail.tombstone.effect.RestorationEffect;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModTriggers;

public final class GhostlyShapeEffect
extends MobEffect {
    private static final String SWIM_MODIFIER = "6aef7405-aee9-4186-a57e-546c5e142a31";

    public GhostlyShapeEffect() {
        super(MobEffectCategory.NEUTRAL, -14445414);
        ForgeMod.SWIM_SPEED.ifPresent(attribute -> this.m_19472_((Attribute)attribute, SWIM_MODIFIER, 0.5, AttributeModifier.Operation.ADDITION));
    }

    public double m_7048_(int amplifier, AttributeModifier modifier) {
        return modifier.m_22218_();
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        boolean isValidPlayer = EntityHelper.isValidServerPlayer((Entity)entity);
        if (isValidPlayer && ((Boolean)ConfigTombstone.player_death.nerfGhostlyShapeEnemyCollision.get()).booleanValue() && (entity.f_19862_ || entity.f_19863_) && entity.m_9236_().m_6249_((Entity)entity, entity.m_20191_().m_82377_(0.1, 0.0, 0.1), EntityHelper::isEnemy).size() > 0) {
            CallbackHandler.addFastCallback(() -> {
                EffectHelper.clearEffect(entity, this);
                ModTriggers.CANCEL_GHOSTLY_SHAPE.trigger((ServerPlayer)entity);
            });
            return;
        }
        if (entity.m_146888_() > 0) {
            entity.m_146917_(0);
            entity.f_146808_ = false;
            entity.f_146809_ = false;
        }
        entity.f_19865_ = Vec3.f_82478_;
        FeatherFallEffect.performPotionLogic(entity);
        entity.m_20301_(300);
        if (isValidPlayer) {
            RestorationEffect.performPotionLogic((ServerPlayer)entity);
        }
        if (TimeHelper.atInterval((Entity)entity, 20)) {
            EffectHelper.clearBadEffects(entity);
            entity.m_5634_(0.5f);
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

