/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.enchantment.ArmorEnchantment;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.TimeHelper;

public final class EnchantmentBlessing
extends ArmorEnchantment {
    private static final String BLESSING_LAST_PROC_NBT_LONG = "blessing_last_proc";

    public EnchantmentBlessing() {
        super("blessing", Enchantment.Rarity.RARE, EnchantmentCategory.ARMOR, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.HEAD, EquipmentSlot.FEET);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)SharedConfigTombstone.enchantments.enableEnchantmentBlessing.get();
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return (Boolean)SharedConfigTombstone.enchantments.blessingEnchantingTable.get() != false && super.canApplyAtEnchantingTable(stack);
    }

    @Override
    protected void onWearerHit(LivingEntity wearer, Entity attacker, int amplifier) {
        int count = 0;
        int amplifierSum = 0;
        for (EquipmentSlot slot : this.slots) {
            int lvl = wearer.m_6844_(slot).getEnchantmentLevel((Enchantment)this);
            if (lvl <= 0) continue;
            amplifierSum += lvl;
            if (++count == 4) break;
        }
        if (count > 0) {
            CompoundTag persistantData = wearer.getPersistentData();
            boolean valid = !persistantData.m_128425_(BLESSING_LAST_PROC_NBT_LONG, 4);
            int delay = TimeHelper.tickFromSecond(10);
            if (!valid) {
                long timeLeft = persistantData.m_128454_(BLESSING_LAST_PROC_NBT_LONG) - (long)wearer.f_19797_;
                if (timeLeft < 0L) {
                    persistantData.m_128473_(BLESSING_LAST_PROC_NBT_LONG);
                    valid = true;
                } else if (timeLeft > (long)delay) {
                    persistantData.m_128356_(BLESSING_LAST_PROC_NBT_LONG, (long)(wearer.f_19797_ + delay));
                }
            }
            if (valid && wearer.m_217043_().m_188503_(10) < count) {
                int effectDuration;
                int effectAmplifier;
                int amplifierMean = amplifierSum / count;
                if (amplifierMean > 1) {
                    effectAmplifier = wearer.m_217043_().m_188503_(count + 1);
                    effectDuration = TimeHelper.tickFromSecond(30);
                } else {
                    effectAmplifier = 0;
                    effectDuration = TimeHelper.tickFromSecond(30 + amplifierMean * 3);
                }
                EffectHelper.addEffect(wearer, EffectHelper.getRandomEffect(effectDuration, false, true, i -> effectAmplifier));
                persistantData.m_128356_(BLESSING_LAST_PROC_NBT_LONG, (long)(wearer.f_19797_ + delay));
            }
        }
    }
}

