/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.brigadier.CommandDispatcher;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.players.PlayerList;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.command.CommandTBAcceptTeleport;
import ovh.corail.tombstone.command.CommandTBBind;
import ovh.corail.tombstone.command.CommandTBGui;
import ovh.corail.tombstone.command.CommandTBKnowledge;
import ovh.corail.tombstone.command.CommandTBRecovery;
import ovh.corail.tombstone.command.CommandTBRequestTeleport;
import ovh.corail.tombstone.command.CommandTBRestoreInventory;
import ovh.corail.tombstone.command.CommandTBReviveFamiliar;
import ovh.corail.tombstone.command.CommandTBShowLastGrave;
import ovh.corail.tombstone.command.CommandTBSiege;
import ovh.corail.tombstone.command.CommandTBTeleport;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.entity.Cloud;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.SupportStructures;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEntities;
import ovh.corail.tombstone.tileentity.BlockEntityDecorativeGrave;
import ovh.corail.tombstone.tileentity.BlockEntityPlayerGrave;

public final class Helper {
    public static final Random RANDOM = new Random();
    public static final RandomSource RANDOM_SOURCE = RandomSource.m_216327_();
    private static final Map<String, Component> BIOME_NAMES = new HashMap<String, Component>();
    public static final String APRIL_FOOLS_DAY_SLOWNESS_NBT_BOOL = "april_fools_day_slowness";
    private static final ResourceLocation TEXTURE = new ResourceLocation("tombstone", "textures/block/circle.png");

    public static boolean isDisabledPerk(@Nullable Perk perk, @Nullable Player player) {
        return perk == null || perk.isDisabled(player);
    }

    public static boolean existClass(String className) {
        return Helper.getClass(className) != null;
    }

    @Nullable
    public static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Nullable
    public static <T> Field getField(@Nullable Class<? super T> aClass, String fieldName) {
        if (aClass != null) {
            try {
                return ObfuscationReflectionHelper.findField(aClass, (String)fieldName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static Method getMethod(@Nullable Class<?> aClass, String methodName, Class<?> ... parameterTypes) {
        if (aClass != null) {
            try {
                return ObfuscationReflectionHelper.findMethod(aClass, (String)methodName, (Class[])parameterTypes);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isModLoad(String modid) {
        return ModList.get() != null && ModList.get().getModContainerById(modid).isPresent();
    }

    public static BlockPos getCloserValidPos(Level level, BlockPos pos) {
        boolean validY;
        WorldBorder border = level.m_6857_();
        boolean validXZ = border.m_61937_(pos);
        boolean bl = validY = !level.m_151570_(pos);
        if (validXZ && validY) {
            return pos;
        }
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        if (!validXZ) {
            x = Math.min(Math.max(pos.m_123341_(), (int)border.m_61955_()), (int)border.m_61957_());
            z = Math.min(Math.max(pos.m_123343_(), (int)border.m_61956_()), (int)border.m_61958_());
        }
        if (!validY) {
            y = Mth.m_14045_((int)pos.m_123342_(), (int)level.m_141937_(), (int)level.m_151558_());
        }
        return new BlockPos(x, y, z);
    }

    public static boolean isValidPos(@Nullable Level level, BlockPos pos) {
        return level != null && level.m_6857_().m_61937_(pos) && !Helper.isOutsideBuildHeight(level, pos);
    }

    public static boolean isOutsideWorldBorders(Level level, BlockPos pos) {
        return !level.m_6857_().m_61937_(pos);
    }

    public static boolean isOutsideBuildHeight(Level level, BlockPos pos) {
        return level.m_151570_(pos);
    }

    public static boolean isInvalidDimension(MinecraftServer server, ResourceKey<Level> key) {
        return server.m_129880_(key) == null;
    }

    public static <T> Optional<T> getRandomInList(Collection<T> list) {
        return list.isEmpty() ? Optional.empty() : list.stream().skip(RANDOM.nextInt(list.size())).findFirst();
    }

    public static Pair<String, String> parseRLString(String rlString) {
        String[] splits = rlString.split(":");
        boolean noDomain = splits.length == 1;
        return noDomain ? Pair.of((Object)"minecraft", (Object)rlString) : Pair.of((Object)splits[0], (Object)splits[1]);
    }

    public static Optional<HolderSet.Named<Structure>> asHolderSet(ServerLevel level, TagKey<Structure> tagKey) {
        return level.m_9598_().m_175515_(Registries.f_256944_).m_203431_(tagKey);
    }

    @Nullable
    public static HolderSet<Structure> asHolderSet(ServerLevel level, ResourceLocation resourceLocation) {
        return Helper.asHolderSet(level, (ResourceKey<Structure>)ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)resourceLocation));
    }

    @Nullable
    public static HolderSet<Structure> asHolderSet(ServerLevel level, ResourceKey<Structure> resourceKey) {
        return level.m_9598_().m_175515_(Registries.f_256944_).m_203636_(resourceKey).map(xva$0 -> HolderSet.m_205809_((Holder[])new Holder[]{xva$0})).orElse(null);
    }

    public static Pair<Location, ResourceLocation> findNearestStructure(ServerLevel level, BlockPos pos, TagKey<Structure> tagKey, boolean unexplored) {
        return Helper.asHolderSet(level, tagKey).map(holders -> Helper.findNearestStructure(level, pos, (HolderSet<Structure>)holders, unexplored)).orElseGet(() -> Pair.of((Object)Location.ORIGIN, null));
    }

    public static Pair<Location, ResourceLocation> findNearestStructure(ServerLevel level, BlockPos pos, HolderSet<Structure> holderset, boolean unexplored) {
        if (level.m_7654_().m_129910_().m_246337_().m_247749_()) {
            Optional<ResourceLocation> optionalRL;
            BlockPos startingPos = Helper.getCloserValidPos((Level)level, pos);
            com.mojang.datafixers.util.Pair res = level.m_7726_().m_8481_().m_223037_(level, holderset, startingPos, 100, unexplored);
            if (res != null && Helper.isValidPos((Level)level, (BlockPos)res.getFirst()) && (optionalRL = ((Holder)res.getSecond()).m_203543_().map(ResourceKey::m_135782_)).isPresent()) {
                return Pair.of((Object)new Location(((BlockPos)res.getFirst()).m_123341_(), SupportStructures.getY(optionalRL.get()), ((BlockPos)res.getFirst()).m_123343_(), (Level)level), (Object)optionalRL.get());
            }
        }
        return Pair.of((Object)Location.ORIGIN, null);
    }

    public static Location findNearestVillage(ServerLevel level, BlockPos pos) {
        return (Location)Helper.findNearestStructure(level, pos, (TagKey<Structure>)StructureTags.f_215889_, false).getLeft();
    }

    public static Location findNearestBiome(ServerLevel level, BlockPos pos, Predicate<Holder<Biome>> predic) {
        BlockPos startingPos = new BlockPos(pos.m_123341_(), 68, pos.m_123343_());
        for (int nbTry = 0; nbTry < 3; ++nbTry) {
            com.mojang.datafixers.util.Pair result = level.m_215069_(predic, startingPos = Helper.getCloserValidPos((Level)level, startingPos.m_7918_((int)((double)nbTry * RANDOM.nextGaussian() * 5000.0), 0, (int)((double)nbTry * RANDOM.nextGaussian() * 5000.0))), 6400, 32, 64);
            if (result == null || !Helper.isValidPos((Level)level, (BlockPos)result.getFirst())) continue;
            return new Location((BlockPos)result.getFirst(), (Level)level);
        }
        return Location.ORIGIN;
    }

    public static Component getBiomeName(String biomeId) {
        return BIOME_NAMES.computeIfAbsent(biomeId, k -> {
            String[] splits = biomeId.toLowerCase(Locale.US).split(":");
            MutableComponent biomeName = Component.m_237113_((String)Helper.capitalizeWord(splits[splits.length - 1]));
            return splits.length < 2 || "minecraft".equals(splits[0]) ? biomeName : biomeName.m_130946_(" [").m_130946_(splits[0]).m_130946_("]");
        });
    }

    public static <T extends Entity> T teleport(T entity, double x, double y, double z, ServerLevel targetWorld) {
        if (entity.m_9236_().m_5776_() || !entity.m_6084_()) {
            return entity;
        }
        ServerLevel sourceWorld = (ServerLevel)entity.m_9236_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            entity.m_8127_();
            if (player.m_5803_()) {
                player.m_6145_(true, true);
            }
            player.m_9213_((Entity)player);
            targetWorld.m_7726_().m_8387_(TicketType.f_9448_, new ChunkPos(BlockPos.m_274561_((double)x, (double)y, (double)z)), 1, (Object)player.m_19879_());
            if (targetWorld == player.m_9236_()) {
                player.f_8906_.m_9774_(x, y, z, player.m_146908_(), player.m_146909_());
            } else {
                ServerLevel serverworld = player.m_284548_();
                LevelData levelData = targetWorld.m_6106_();
                PlayerList playerList = serverworld.m_7654_().m_6846_();
                player.f_8906_.m_9829_((Packet)new ClientboundRespawnPacket(targetWorld.m_220362_(), targetWorld.m_46472_(), BiomeManager.m_47877_((long)targetWorld.m_7328_()), player.f_8941_.m_9290_(), player.f_8941_.m_9293_(), targetWorld.m_46659_(), targetWorld.m_8584_(), 3, player.m_219759_(), player.m_287157_()));
                player.f_8906_.m_9829_((Packet)new ClientboundChangeDifficultyPacket(levelData.m_5472_(), levelData.m_5474_()));
                playerList.m_11289_(player);
                serverworld.m_143261_(player, Entity.RemovalReason.CHANGED_DIMENSION);
                player.revive();
                player.m_7678_(x, y, z, player.m_146908_(), player.m_146909_());
                player.m_284127_(targetWorld);
                targetWorld.m_8622_(player);
                player.m_9209_(serverworld);
                player.f_8906_.m_9774_(x, y, z, player.m_146908_(), player.m_146909_());
                player.f_8941_.m_9260_(targetWorld);
                player.f_8906_.m_9829_((Packet)new ClientboundPlayerAbilitiesPacket(player.m_150110_()));
                playerList.m_11229_(player, targetWorld);
                playerList.m_11292_(player);
                player.m_21220_().forEach(e -> player.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(player.m_19879_(), e)));
                player.f_8920_ = -1;
                player.f_8917_ = -1.0f;
                player.f_8918_ = -1;
                ForgeEventFactory.firePlayerChangedDimensionEvent((Player)player, (ResourceKey)serverworld.m_46472_(), (ResourceKey)targetWorld.m_46472_());
            }
            return entity;
        }
        entity.m_19877_();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (mob.m_21523_()) {
                mob.m_21455_(true, false);
            }
            mob.m_21573_().m_26573_();
        }
        if (sourceWorld != targetWorld) {
            return (T)Optional.ofNullable(entity.m_6095_().m_20615_((Level)targetWorld)).map(newEntity -> {
                newEntity.m_20361_(entity);
                newEntity.m_7678_(x, y, z, entity.m_146908_(), entity.m_146909_());
                newEntity.m_20256_(Vec3.f_82478_);
                entity.m_142467_(Entity.RemovalReason.CHANGED_DIMENSION);
                targetWorld.m_143334_(newEntity);
                sourceWorld.m_8886_();
                targetWorld.m_8886_();
                return newEntity;
            }).orElse(entity);
        }
        entity.m_7678_(x, y, z, entity.m_146908_(), entity.m_146909_());
        return entity;
    }

    public static <T extends Entity> T teleport(T entity, Location loc, ServerLevel level) {
        return Helper.teleport(entity, (double)loc.x + 0.5, (double)loc.y + 0.1, (double)loc.z + 0.5, level);
    }

    public static <T extends Entity> T teleportToGrave(T entity, Location loc, ServerLevel level) {
        return Helper.teleport(entity, loc.move(Direction.UP, 1), level);
    }

    public static boolean isRuleKeepInventory(@Nullable Entity entity) {
        return entity != null && Helper.isRuleKeepInventory(entity.m_9236_());
    }

    public static boolean isRuleKeepInventory(Level level) {
        return level.m_46469_().m_46207_(GameRules.f_46133_);
    }

    public static boolean hasNoCollision(BlockGetter level, BlockPos pos, BlockState state) {
        return state.m_60812_(level, pos) == Shapes.m_83040_();
    }

    public static boolean canShowTooltip(@Nullable Level level) {
        return level != null && ((Boolean)ConfigTombstone.client.showEnhancedTooltips.get() != false || Screen.m_96638_());
    }

    public static boolean isAprilFoolsDaySnowball(LivingEntity entity, @Nullable DamageSource source) {
        return TimeHelper.isAprilFoolsDay() && EntityHelper.isValidServerPlayer((Entity)entity) && Optional.ofNullable(source).map(DamageSource::m_7640_).map(e -> e.m_6095_() == EntityType.f_20477_ && e.getPersistentData().m_128441_(APRIL_FOOLS_DAY_SLOWNESS_NBT_BOOL)).orElse(false) != false;
    }

    public static void handleAprilFoolsDayGrave(Level level, BlockPos pos) {
        Vec3 centerVec = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_82520_(0.5, 1.0, 0.5);
        Player closestPlayer = level.m_45924_(centerVec.f_82479_, centerVec.f_82480_, centerVec.f_82481_, 20.0, false);
        if (closestPlayer != null) {
            Snowball snowballentity = new Snowball(level, centerVec.f_82479_, centerVec.f_82480_, centerVec.f_82481_);
            if (Helper.canSeeEntity((Entity)closestPlayer, centerVec)) {
                snowballentity.m_37446_(new ItemStack((ItemLike)Items.f_42500_));
                snowballentity.getPersistentData().m_128379_(APRIL_FOOLS_DAY_SLOWNESS_NBT_BOOL, true);
                Vec3 vec = closestPlayer.m_20182_().m_82520_(0.0, (double)closestPlayer.m_20192_(), 0.0).m_82546_(snowballentity.m_20182_());
                snowballentity.m_6686_(vec.f_82479_, vec.f_82480_, vec.f_82481_, 1.5f, 1.0f);
                level.m_7967_((Entity)snowballentity);
            }
        }
    }

    public static boolean canSeeEntity(Entity entity, Vec3 vec3d) {
        Vec3 vec3d1 = entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_(), 0.0);
        return entity.m_9236_().m_45547_(new ClipContext(vec3d, vec3d1, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity)).m_6662_() == HitResult.Type.MISS;
    }

    @Nullable
    public static MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public static boolean isDay(Level level) {
        return !Helper.isNight(level);
    }

    public static boolean isNight(Level level) {
        float angle = level.m_46942_(0.0f);
        return angle >= 0.245f && angle <= 0.755f;
    }

    public static boolean containRL(List<String> listRL, @Nullable ResourceLocation rl) {
        return rl != null && Helper.containRL(listRL, rl.m_135827_(), rl.m_135815_());
    }

    public static boolean containRL(List<String> listRL, String registryName) {
        String[] splits = registryName.split(":");
        if (splits.length == 1) {
            return Helper.containRL(listRL, "minecraft", splits[0]);
        }
        return Helper.containRL(listRL, splits[0], splits[1]);
    }

    public static boolean containRL(List<String> listRL, String domain, String path) {
        return listRL.stream().anyMatch(p -> p.contains(":") ? p.equals(domain + ":" + path) : p.equals(domain));
    }

    public static float[] getRGBColor3F(int color) {
        float[] rgb = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        return rgb;
    }

    public static float[] getRGBColor4F(int color) {
        float[] rgb = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f};
        return rgb;
    }

    public static float[] getHSBtoRGBF(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        float[] rgb = new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
        return rgb;
    }

    public static int combineColor(int ... colors) {
        int r = Mth.m_14107_((double)Arrays.stream(colors).map(c -> c >> 16 & 0xFF).average().orElse(255.0));
        int g = Mth.m_14107_((double)Arrays.stream(colors).map(c -> c >> 8 & 0xFF).average().orElse(255.0));
        int b = Mth.m_14107_((double)Arrays.stream(colors).map(c -> c & 0xFF).average().orElse(255.0));
        return r << 16 | g << 8 | b;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void fillGradient(Matrix4f matrix, int left, int top, int right, int bottom, int color1, int color2, int zLevel, boolean isHorizontal) {
        float[] argb1 = Helper.getRGBColor4F(color1);
        float[] argb2 = Helper.getRGBColor4F(color2);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Helper.makeVertex(matrix, bufferbuilder, right, top, zLevel, isHorizontal ? argb2 : argb1);
        Helper.makeVertex(matrix, bufferbuilder, left, top, zLevel, argb1);
        Helper.makeVertex(matrix, bufferbuilder, left, bottom, zLevel, isHorizontal ? argb1 : argb2);
        Helper.makeVertex(matrix, bufferbuilder, right, bottom, zLevel, argb2);
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void makeVertex(Matrix4f matrix, BufferBuilder bufferbuilder, int x, int y, int zLevel, float[] colorArray) {
        bufferbuilder.m_252986_(matrix, (float)x, (float)y, (float)zLevel).m_85950_(colorArray[0], colorArray[1], colorArray[2], colorArray[3]).m_5752_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderCircle(GuiGraphics guiGraphics, int x, int y, int color, int size) {
        Helper.renderCircle(guiGraphics, x, y, color, -5586716, size);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderCircle(GuiGraphics guiGraphics, int x, int y, int color, int colorBg, int size) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280509_(x + 1, y + 1, x - 1 + size, y - 1 + size, colorBg);
        float[] colors = Helper.getRGBColor4F(color);
        RenderSystem.setShaderColor((float)colors[0], (float)colors[1], (float)colors[2], (float)colors[3]);
        guiGraphics.m_280163_(TEXTURE, x, y, 0.0f, 0.0f, size, size, size, size);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderStackInGui(ItemStack stack, int xPosition, int yPosition, float scale, boolean isSpinning) {
        try {
            boolean flag;
            Minecraft mc = Minecraft.m_91087_();
            BakedModel bakedModel = mc.m_91291_().m_174264_(stack, null, null, 0);
            mc.f_90987_.m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118259_);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            PoseStack poseStack = RenderSystem.getModelViewStack();
            poseStack.m_85836_();
            poseStack.m_85841_(scale, scale, scale);
            poseStack.m_252880_((float)xPosition / scale, (float)yPosition / scale, 100.0f);
            poseStack.m_252880_(8.0f, 8.0f, 0.0f);
            poseStack.m_85841_(16.0f, -16.0f, 16.0f);
            RenderSystem.applyModelViewMatrix();
            PoseStack poseStack1 = new PoseStack();
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            boolean bl = flag = !bakedModel.m_7547_();
            if (flag) {
                Lighting.m_84930_();
            }
            if (isSpinning) {
                // empty if block
            }
            mc.m_91291_().m_115143_(stack, ItemDisplayContext.GUI, false, poseStack1, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, bakedModel);
            bufferSource.m_109911_();
            RenderSystem.enableDepthTest();
            if (flag) {
                Lighting.m_84931_();
            }
            poseStack.m_85849_();
            RenderSystem.applyModelViewMatrix();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void damageItem(ItemStack stack, int amount, ServerPlayer player, InteractionHand hand) {
        stack.m_41622_(amount, (LivingEntity)player, p -> p.m_21190_(hand));
    }

    public static double getDistance(Vec3i vec1, Vec3i vec2) {
        return Math.sqrt(Helper.getDistanceSq(vec1, vec2));
    }

    public static double getDistanceSq(Vec3i vec1, Vec3i vec2) {
        return Helper.getDistanceSq(vec1, vec2.m_123341_(), vec2.m_123342_(), vec2.m_123343_());
    }

    public static double getDistanceSq(Vec3i vec1, int x2, int y2, int z2) {
        return vec1.m_203202_((double)x2, (double)y2, (double)z2);
    }

    public static boolean isPacketToClient(NetworkEvent.Context ctx) {
        return ctx.getDirection().getOriginationSide() == LogicalSide.SERVER && ctx.getDirection().getReceptionSide() == LogicalSide.CLIENT;
    }

    public static boolean isPacketToServer(NetworkEvent.Context ctx) {
        return ctx.getDirection().getOriginationSide() == LogicalSide.CLIENT && ctx.getDirection().getReceptionSide() == LogicalSide.SERVER;
    }

    public static <T> T unsafeNullCast() {
        return null;
    }

    public static String capitalizeWord(String text) {
        StringBuilder builder = new StringBuilder();
        String[] splits = text.toLowerCase(Locale.US).split("\\s|_");
        builder.append(StringUtils.capitalize((String)splits[0]));
        if (splits.length > 1) {
            Arrays.stream(splits, 1, splits.length).forEach(word -> builder.append(" ").append(StringUtils.capitalize((String)word)));
        }
        return builder.toString();
    }

    public static void initCommands(CommandDispatcher<CommandSourceStack> commandDispatcher, CommandBuildContext buildContext) {
        new CommandTBAcceptTeleport().registerCommand(commandDispatcher, buildContext);
        new CommandTBBind().registerCommand(commandDispatcher, buildContext);
        new CommandTBGui().registerCommand(commandDispatcher, buildContext);
        new CommandTBKnowledge().registerCommand(commandDispatcher, buildContext);
        new CommandTBRecovery().registerCommand(commandDispatcher, buildContext);
        new CommandTBRequestTeleport().registerCommand(commandDispatcher, buildContext);
        new CommandTBRestoreInventory().registerCommand(commandDispatcher, buildContext);
        new CommandTBReviveFamiliar().registerCommand(commandDispatcher, buildContext);
        new CommandTBShowLastGrave().registerCommand(commandDispatcher, buildContext);
        new CommandTBSiege().registerCommand(commandDispatcher, buildContext);
        new CommandTBTeleport().registerCommand(commandDispatcher, buildContext);
    }

    public static void spawnRandomMob(ServerLevel level, BlockPos pos) {
        Location spawnPos = new SpawnHelper(level, new BlockPos(pos.m_123341_() + RANDOM.nextInt(19) - 9, pos.m_123342_(), pos.m_123343_() + RANDOM.nextInt(19) - 9)).findSafePlace(2, true);
        if (spawnPos.isOrigin()) {
            return;
        }
        Zombie mob = (Zombie)EntityType.f_20501_.m_20615_((Level)level);
        if (mob != null) {
            mob.m_6863_(true);
            if (TimeHelper.isDateAroundHalloween()) {
                mob.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Blocks.f_50133_));
            }
            mob.m_6518_((ServerLevelAccessor)level, level.m_6436_(mob.m_20183_()), MobSpawnType.TRIGGERED, null, null);
            mob.m_7678_((double)spawnPos.x, (double)spawnPos.y, (double)spawnPos.z, level.f_46441_.m_188501_() * 360.0f, 0.0f);
            level.m_47205_((Entity)mob);
        }
    }

    public static AABB createBounds(BlockPos pos, double range) {
        return new AABB((double)pos.m_123341_() - range, (double)pos.m_123342_() - range, (double)pos.m_123343_() - range, (double)pos.m_123341_() + range, (double)pos.m_123342_() + range, (double)pos.m_123343_() + range);
    }

    @Nullable
    public static BlockPos findGraveAround(Level level, BlockPos startPos) {
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos currentPos = new BlockPos(startPos.m_123341_() + x, startPos.m_123342_() + y, startPos.m_123343_() + z);
                    if (!ModBlocks.isDecorativeGrave(level.m_8055_(currentPos).m_60734_())) continue;
                    return currentPos;
                }
            }
        }
        return null;
    }

    public static Optional<BlockEntityDecorativeGrave> getDecorativeGrave(Level level, BlockPos pos) {
        return level.m_141902_(pos, ModBlocks.tile_decorative_grave);
    }

    public static Optional<BlockEntityPlayerGrave> getPlayerGrave(Level level, BlockPos pos) {
        return level.m_141902_(pos, ModBlocks.tile_grave);
    }

    public static List<ItemStack> getStacks(TagKey<Item> tagKey) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        BuiltInRegistries.f_257033_.m_206058_(tagKey).forEach(holder -> stacks.add(new ItemStack(holder)));
        return stacks;
    }

    public static boolean isDimensionTypeEnd(Level level) {
        return level.m_220362_().equals((Object)BuiltinDimensionTypes.f_223540_);
    }

    public static void castEvokerFangs(LivingEntity caster, @Nullable Entity target, boolean isSpectral) {
        block5: {
            if (target == null || !target.m_6084_()) break block5;
            double d0 = Math.min(target.m_20186_(), caster.m_20186_());
            double d1 = Math.max(target.m_20186_(), caster.m_20186_()) + 1.0;
            float f = (float)Mth.m_14136_((double)(target.m_20189_() - caster.m_20189_()), (double)(target.m_20185_() - caster.m_20185_()));
            if (caster.m_20280_(target) < 9.0) {
                for (int i = 0; i < 5; ++i) {
                    float f1 = f + (float)i * (float)Math.PI * 0.4f;
                    Helper.createSpellEntity(caster, caster.m_20185_() + (double)Mth.m_14089_((float)f1) * 1.5, caster.m_20189_() + (double)Mth.m_14031_((float)f1) * 1.5, d0, d1, f1, 0, isSpectral);
                }
                for (int j = 0; j < 8; ++j) {
                    float f2 = f + (float)j * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    Helper.createSpellEntity(caster, caster.m_20185_() + (double)Mth.m_14089_((float)f2) * 2.5, caster.m_20189_() + (double)Mth.m_14031_((float)f2) * 2.5, d0, d1, f2, 3, isSpectral);
                }
            } else {
                for (int k = 0; k < 16; ++k) {
                    double d2 = 1.25 * (double)(k + 1);
                    Helper.createSpellEntity(caster, caster.m_20185_() + (double)Mth.m_14089_((float)f) * d2, caster.m_20189_() + (double)Mth.m_14031_((float)f) * d2, d0, d1, f, k, isSpectral);
                }
            }
        }
    }

    private static void createSpellEntity(LivingEntity caster, double x, double z, double minY, double maxY, float f, int warmupDelayTicks, boolean isSpectral) {
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)maxY, (double)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = caster.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)caster.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!caster.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = caster.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)caster.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            EvokerFangs evokerFangs = new EvokerFangs(caster.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, f, warmupDelayTicks, caster);
            if (isSpectral) {
                evokerFangs.getPersistentData().m_128379_("spectral", isSpectral);
                Cloud cloud = (Cloud)ModEntities.cloud.m_20615_(caster.m_9236_());
                if (cloud != null) {
                    cloud.setColor(2404516);
                    cloud.m_6034_(x, (double)blockpos.m_123342_() + d0, z);
                    cloud.setMaxDuration(10);
                    caster.m_9236_().m_7967_((Entity)cloud);
                }
            }
            caster.m_9236_().m_7967_((Entity)evokerFangs);
        }
    }

    public static String getRomanNumber(int number) {
        if (number == 0) {
            return "0";
        }
        List<RomanNumeral> romanNumerals = Arrays.stream(RomanNumeral.values()).sorted(Comparator.comparing(e -> e.value).reversed()).toList();
        int i = 0;
        StringBuilder builder = new StringBuilder();
        while (number > 0 && i < romanNumerals.size()) {
            RomanNumeral symbol = romanNumerals.get(i);
            if (symbol.value <= number) {
                builder.append(symbol.name());
                number -= symbol.value;
                continue;
            }
            ++i;
        }
        return builder.toString();
    }

    private static enum RomanNumeral {
        I(1),
        IV(4),
        V(5),
        IX(9),
        X(10),
        XL(40),
        L(50),
        XC(90),
        C(100),
        CD(400),
        D(500),
        CM(900),
        M(1000);

        private final int value;

        private RomanNumeral(int value) {
            this.value = value;
        }
    }
}

