/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.io.Files;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.LootPool;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.Helper;

public final class UpdaterHandler {
    public static final UpdaterHandler instance = new UpdaterHandler();
    private final LevelResource TOMBSTONE_FOLDER = new LevelResource("tombstone");
    private final Gson GSON = Deserializers.m_78800_().create();
    private boolean hasVersionChanged = false;

    private UpdaterHandler() {
    }

    private boolean hasVersionChanged() {
        return this.hasVersionChanged;
    }

    private boolean requireUpdate(PoolType poolType) {
        return poolType == PoolType.LOST_TREASURE;
    }

    public void checkVersion() {
        MinecraftServer server = Helper.getServer();
        if (server != null) {
            File folder = server.m_129843_(this.TOMBSTONE_FOLDER).toFile();
            File file = new File(folder, "version.info");
            if (file.exists()) {
                try {
                    if ("8.5.2".equals(new BufferedReader(new FileReader(file, StandardCharsets.UTF_8)).readLine().trim())) {
                        this.hasVersionChanged = false;
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            folder.mkdirs();
            try (FileWriter fw = new FileWriter(file, StandardCharsets.UTF_8);){
                fw.write("8.5.2");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.hasVersionChanged = true;
        }
    }

    @Nullable
    private File getFile(PoolType poolType, boolean isBakFile) {
        MinecraftServer server = Helper.getServer();
        if (server != null) {
            File folder = new File(server.m_129843_(this.TOMBSTONE_FOLDER).toFile(), "loottables");
            folder.mkdirs();
            return new File(folder, String.format("%s-pool-%s.%s", "tombstone", poolType.filename, isBakFile ? "bak" : "json"));
        }
        return null;
    }

    @Nullable
    public LootPool loadLootPool(PoolType poolType) {
        File file;
        if (!(this.requireUpdate(poolType) && this.hasVersionChanged() || (file = this.getFile(poolType, false)) == null || !file.exists())) {
            LootPool lootPool;
            block9: {
                BufferedReader reader = Files.newReader((File)file, (Charset)StandardCharsets.UTF_8);
                try {
                    lootPool = (LootPool)this.GSON.fromJson((Reader)reader, LootPool.class);
                    if (reader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                reader.close();
            }
            return lootPool;
        }
        return null;
    }

    public void saveLootPool(PoolType poolType, LootPool lootPool) {
        File file = this.getFile(poolType, false);
        if (file != null) {
            File bakFile;
            if (file.exists() && this.requireUpdate(poolType) && this.hasVersionChanged() && (bakFile = this.getFile(poolType, true)) != null) {
                try {
                    Files.copy((File)file, (File)bakFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try (BufferedWriter writer = Files.newWriter((File)file, (Charset)StandardCharsets.UTF_8);){
                writer.write(this.GSON.toJson((Object)lootPool));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static enum PoolType {
        ARCHAEOLOGY("archaeology"),
        LOST_TREASURE("lost_treasure"),
        CAT_MORNING("cat_morning"),
        CHEST_TREASURE("chest_treasure"),
        UNDEAD_MOB("undead_mob"),
        UNDEAD_BOSS("undead_boss");

        private final String filename;

        private PoolType(String filename) {
            this.filename = filename.toLowerCase(Locale.US);
        }

        public String getFilename() {
            return this.filename;
        }
    }
}

