/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.capability.SoulConsumerProvider;
import ovh.corail.tombstone.combine.CombineUpgrade;
import ovh.corail.tombstone.combine.TooltipCombineUpgrade;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.DamageCategory;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTags;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemVoodooPoppet
extends ItemGeneric
implements ISoulConsumer,
IDelayedNBTLoot {
    private static final int LIMIT_VALID = DamageCategory.DARKNESS.ordinal() + 1;
    private static final String POPPET_PROT_PREFIX = "poppet_prot_";

    public ItemVoodooPoppet() {
        super("voodoo_poppet", ItemVoodooPoppet.getBuilder().m_41487_(1).m_41486_(), () -> SharedConfigTombstone.allowed_magic_items.allowVoodooPoppet.get());
        this.withCombineInfo();
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Level level, List<Component> tooltip) {
        this.addItemDesc(tooltip);
        List<DamageCategory> damageTypes = this.getValidDamageTypes().filter(d -> this.hasProtection(stack, (DamageCategory)((Object)d))).toList();
        damageTypes.forEach(d -> tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + "." + d.m_7912_())).m_130948_(StyleType.TOOLTIP_ITEM)));
        boolean enchanted = this.isEnchanted(stack);
        this.addItemUse(tooltip, enchanted ? "3" : (damageTypes.isEmpty() ? "1" : "2"), new Object[0]);
        if (enchanted) {
            ModPerks.witch_doctor.getCurrentBonusInfo(EntityHelper.getPerkLevelWithBonus(ModTombstone.PROXY.getClientPlayer(), ModPerks.witch_doctor)).forEach(info -> tooltip.add((Component)info.m_6881_().m_130948_(StyleType.INFO)));
        }
        super.addTooltipInfo(stack, level, tooltip);
    }

    public Component m_7626_(ItemStack stack) {
        Component name = super.m_7626_(stack);
        return (this.isEnchanted(stack) ? LangKey.MESSAGE_ENCHANTED_ITEM.getText(name) : name.m_6879_()).m_6270_(StyleType.MESSAGE_SPECIAL);
    }

    @Override
    public boolean m_5812_(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.m_150930_((Item)this) && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        if (!this.isEnchanted(stack) && this.getValidDamageTypes().anyMatch(p -> this.hasProtection(stack, (DamageCategory)((Object)p)))) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_ENCHANT_VOODOO_POPPET_SUCCESS.getText(new Object[0]), 1);
        }
        return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_ENCHANT_VOODOO_POPPET_FAILED.getText(new Object[0]));
    }

    public ItemStack createWithRandomProtections(int count) {
        return NBTStackHelper.setBoolean(this.setRandomProtections(new ItemStack((ItemLike)this), count), "enchant", true);
    }

    public Stream<DamageCategory> getValidDamageTypes() {
        return Arrays.stream(DamageCategory.values(), 0, LIMIT_VALID);
    }

    public Stream<DamageCategory> getCraftableDamageTypes() {
        return Arrays.stream(DamageCategory.values(), 0, LIMIT_VALID - 1);
    }

    public ItemStack addProtection(ItemStack stack, DamageCategory damageType) {
        if (stack.m_150930_((Item)this) && !this.isEnchanted(stack) && !this.hasProtection(stack, damageType)) {
            NBTStackHelper.setBoolean(stack, POPPET_PROT_PREFIX + damageType.ordinal(), true);
        }
        return stack;
    }

    public boolean hasProtection(ItemStack stack, DamageCategory damageType) {
        return stack.m_150930_((Item)this) && NBTStackHelper.getBoolean(stack, POPPET_PROT_PREFIX + damageType.ordinal());
    }

    public boolean preventDeath(ServerPlayer player, DamageSource source) {
        DamageCategory damageType = this.getProtection(source);
        if (damageType == null) {
            return false;
        }
        int chance = 50 + EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.witch_doctor) * 10;
        ItemStack voodooPoppet = InventoryHelper.findFirstInInventory((Player)player, p -> this.canPreventDeath((ItemStack)p, damageType));
        if (voodooPoppet.m_41619_()) {
            return false;
        }
        if (Helper.RANDOM.nextInt(100) >= chance) {
            LangKey.MESSAGE_VOODOO_POPPET_PREVENT_DEATH_FAILED.sendMessage((Player)player, new Object[0]);
            return false;
        }
        NBTStackHelper.removeKeyName(voodooPoppet, POPPET_PROT_PREFIX + damageType.ordinal());
        if (this.getValidDamageTypes().noneMatch(d -> this.hasProtection(voodooPoppet, (DamageCategory)((Object)d)))) {
            voodooPoppet.m_41774_(1);
        }
        int duration = TimeHelper.tickFromSecond((Integer)ConfigTombstone.magic_item.durationVoodooPoppetEffects.get());
        LangKey.sendSystemMessage((Player)player, (Component)Component.m_237115_((String)("tombstone.message.prevent_death." + damageType.m_7912_())), StyleType.MESSAGE_SPECIAL);
        ModTriggers.PREVENT_DEATH.get((Object)damageType).trigger(player);
        switch (damageType) {
            case SUFFOCATION: {
                EffectHelper.addEffect((LivingEntity)player, MobEffects.f_19605_, duration, 9, new boolean[0]);
                EffectHelper.addEffect((LivingEntity)player, ModEffects.aquatic_life, duration);
                break;
            }
            case BURN: {
                player.m_20095_();
                EffectHelper.addEffect((LivingEntity)player, MobEffects.f_19605_, duration, 9, new boolean[0]);
                EffectHelper.addEffect((LivingEntity)player, MobEffects.f_19607_, duration);
                break;
            }
            case LIGHTNING: {
                player.m_20095_();
                EffectHelper.addEffect((LivingEntity)player, MobEffects.f_19605_, duration, 9, new boolean[0]);
                EffectHelper.addEffect((LivingEntity)player, ModEffects.lightning_resistance, duration);
                break;
            }
            case FALL: {
                EffectHelper.addEffect((LivingEntity)player, MobEffects.f_19605_, duration, 9, new boolean[0]);
                EffectHelper.addEffect((LivingEntity)player, ModEffects.feather_fall, duration);
                break;
            }
            case COLD: {
                EffectHelper.addEffect((LivingEntity)player, MobEffects.f_19605_, duration, 9, new boolean[0]);
                EffectHelper.addEffect((LivingEntity)player, MobEffects.f_19598_, duration);
                EffectHelper.addEffect((LivingEntity)player, MobEffects.f_19596_, duration);
                break;
            }
            case DARKNESS: {
                EffectHelper.addEffect((LivingEntity)player, MobEffects.f_19605_, duration, 9, new boolean[0]);
                EffectHelper.addEffect((LivingEntity)player, MobEffects.f_19618_, duration);
                EffectHelper.clearBadEffects((LivingEntity)player);
            }
        }
        return true;
    }

    public boolean canPreventDeath(ItemStack stack, DamageCategory damageType) {
        return this.isEnchanted(stack) && NBTStackHelper.getBoolean(stack, POPPET_PROT_PREFIX + damageType.ordinal());
    }

    @Nullable
    public DamageCategory getProtection(DamageSource srcDmg) {
        DamageCategory damageType = DamageCategory.of(srcDmg);
        return this.getValidDamageTypes().filter(d -> d == damageType).findFirst().orElse(null);
    }

    private ItemStack setRandomProtections(ItemStack stack, int count) {
        List<DamageCategory> damages = this.getValidDamageTypes().collect(Collectors.toList());
        if (count < LIMIT_VALID) {
            IntStream.range(0, LIMIT_VALID - count).forEach(i -> damages.remove(Helper.RANDOM.nextInt(damages.size())));
        }
        damages.forEach(d -> this.addProtection(stack, (DamageCategory)((Object)d)));
        return stack;
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, CompoundTag tag, LootContext context) {
        return NBTStackHelper.setBoolean(this.setRandomProtections(stack, Helper.RANDOM.nextInt(5) + 1), "enchant", true);
    }

    @Nullable
    public DamageCategory getProtection(ItemStack ingredient) {
        return ModTags.Items.VOODOO_POPPET_INGREDIENT_BY_TYPE.entrySet().stream().filter(entry -> ingredient.m_204117_((TagKey)entry.getValue())).findFirst().map(Map.Entry::getKey).orElse(null);
    }

    public boolean m_142305_(ItemStack voodooPoppet, ItemStack added, Slot slot, ClickAction action, Player player, SlotAccess slotAccess) {
        DamageCategory damageType;
        if (action == ClickAction.SECONDARY && EntityHelper.isValidPlayer(player) && slot.m_150651_(player) && voodooPoppet.m_150930_((Item)this) && (damageType = this.getProtection(added)) != null) {
            MutableComponent errorMessage;
            Object object = this.isEnchanted(voodooPoppet) ? LangKey.MESSAGE_ENCHANT_ITEM_ALREADY_ENCHANTED.getText(new Object[0]) : (errorMessage = this.hasProtection(voodooPoppet, damageType) ? LangKey.MESSAGE_VOODOO_POPPET_ALREADY_PROTECTED.getText(new Object[0]) : null);
            if (errorMessage != null) {
                ModTombstone.PROXY.addToast(added.m_41777_(), new ItemStack((ItemLike)this), (Component)errorMessage);
            } else {
                boolean isServerSide;
                boolean bl = isServerSide = !player.m_9236_().m_5776_();
                if (isServerSide || player.m_7500_()) {
                    NBTStackHelper.setBoolean(voodooPoppet, POPPET_PROT_PREFIX + damageType.ordinal(), true);
                    added.m_41774_(1);
                    if (isServerSide) {
                        ModTriggers.COMBINE_IN_INVENTORY.trigger((ServerPlayer)player);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        return this.isEnchanted(stack) ? Optional.empty() : Optional.of(new TooltipCombineUpgrade((CombineUpgrade[])ModTags.Items.VOODOO_POPPET_INGREDIENT_BY_TYPE.entrySet().stream().map(entry -> new CombineUpgrade((TagKey<Item>)((TagKey)entry.getValue()), !ModItems.voodoo_poppet.hasProtection(stack, (DamageCategory)((Object)((Object)entry.getKey()))))).toArray(CombineUpgrade[]::new)));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new SoulConsumerProvider(this);
    }
}

