/*
 * Decompiled with CFR 0.152.
 */
package trapcraft;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;
import trapcraft.TrapcraftItems;
import trapcraft.block.BearTrapBlock;
import trapcraft.block.FanBlock;
import trapcraft.block.GrassCoveringBlock;
import trapcraft.block.IgniterBlock;
import trapcraft.block.MagneticChestBlock;
import trapcraft.block.SpikesBlock;
import trapcraft.item.MagneticChestItem;

public class TrapcraftBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"trapcraft");
    public static final DeferredRegister<Item> ITEMS = TrapcraftItems.ITEMS;
    public static final RegistryObject<Block> FAN = TrapcraftBlocks.makeBlockWithItem("fan", FanBlock::new);
    private static final Pair<RegistryObject<Block>, RegistryObject<Item>> MAGNETIC_CHEST_PAIR = TrapcraftBlocks.makeBlockWithItemCustom("magnetic_chest", () -> new MagneticChestBlock(), blockObj -> TrapcraftBlocks.makeMagneticChestItem((Supplier<Block>)blockObj));
    public static final RegistryObject<Block> MAGNETIC_CHEST = (RegistryObject)MAGNETIC_CHEST_PAIR.getLeft();
    public static final RegistryObject<Item> MAGNETIC_CHEST_ITEM = (RegistryObject)MAGNETIC_CHEST_PAIR.getRight();
    public static final RegistryObject<Block> GRASS_COVERING = TrapcraftBlocks.makeBlockWithItem("grass_covering", GrassCoveringBlock::new);
    public static final RegistryObject<Block> BEAR_TRAP = TrapcraftBlocks.makeBlockWithItem("bear_trap", BearTrapBlock::new);
    public static final RegistryObject<Block> SPIKES = TrapcraftBlocks.makeBlockWithItem("spikes", SpikesBlock::new);
    public static final RegistryObject<Block> IGNITER = TrapcraftBlocks.makeBlockWithItem("igniter", IgniterBlock::new);

    private static RegistryObject<Block> makeBlockWithItem(String name, Supplier<Block> blockSupplier) {
        return (RegistryObject)TrapcraftBlocks.makeBlockWithItemCustom(name, blockSupplier, blockObj -> TrapcraftBlocks.makeBlockItem((Supplier<Block>)blockObj)).getLeft();
    }

    private static Pair<RegistryObject<Block>, RegistryObject<Item>> makeBlockWithItemCustom(String name, Supplier<Block> blockSupplier, Function<RegistryObject<Block>, Item> itemFunction) {
        RegistryObject blockObj = BLOCKS.register(name, blockSupplier);
        RegistryObject itemObj = ITEMS.register(name, () -> (Item)itemFunction.apply(blockObj));
        return Pair.of((Object)blockObj, (Object)itemObj);
    }

    private static BlockItem makeMagneticChestItem(Supplier<Block> blockSupplier) {
        return new MagneticChestItem(blockSupplier.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40751_));
    }

    private static BlockItem makeBlockItem(Supplier<Block> blockSupplier) {
        return TrapcraftBlocks.makeBlockItem(blockSupplier, CreativeModeTab.f_40751_);
    }

    private static BlockItem makeBlockItem(Supplier<Block> block, CreativeModeTab group) {
        return new BlockItem(block.get(), new Item.Properties().m_41491_(group));
    }
}

