/*
 * Decompiled with CFR 0.152.
 */
package trapcraft.block.tileentity;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import trapcraft.TrapcraftTileEntityTypes;
import trapcraft.block.FanBlock;
import trapcraft.config.ConfigHandler;

public class FanTileEntity
extends BlockEntity {
    public float speed = 1.0f;
    public double extraRange = 0.0;

    public FanTileEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)TrapcraftTileEntityTypes.FAN.get(), pos, blockState);
    }

    public static void tick(Level level, BlockPos worldPosition, BlockState blockState, FanTileEntity blockEntity) {
        if (!((Boolean)blockState.m_61143_((Property)FanBlock.POWERED)).booleanValue()) {
            return;
        }
        Direction facing = (Direction)blockState.m_61143_((Property)FanBlock.FACING);
        if (level.f_46441_.nextInt(2) == 0) {
            FanTileEntity.spawnParticles(level, blockState, worldPosition);
        }
        List list = level.m_45976_(Entity.class, blockEntity.getDirection(facing));
        for (Entity entity : list) {
            if (entity instanceof Player) {
                Player p = (Player)entity;
                if (p.m_150110_().f_35935_) continue;
            }
            if (!blockEntity.isPathClear(entity, facing)) continue;
            double velocity = (Double)ConfigHandler.SERVER.FAN_ACCELERATION.get();
            double threshholdVelocity = (Double)ConfigHandler.SERVER.FAN_MAX_SPEED.get();
            velocity *= (double)blockEntity.speed;
            if (entity instanceof ItemEntity) {
                threshholdVelocity *= 1.8;
                velocity *= 1.3;
            }
            if (entity instanceof Minecart) {
                velocity *= 0.5;
            }
            if (entity instanceof FallingBlockEntity && facing == Direction.UP) {
                velocity = 0.0;
            }
            if (facing == Direction.UP) {
                threshholdVelocity *= 0.5;
            }
            if (!(Math.abs(entity.m_20184_().m_82507_(facing.m_122434_())) < threshholdVelocity)) continue;
            entity.m_20256_(entity.m_20184_().m_82520_((double)facing.m_122429_() * velocity, (double)facing.m_122430_() * velocity, (double)facing.m_122431_() * velocity));
        }
    }

    public boolean isPathClear(Entity entity, Direction facing) {
        int x = facing.m_122429_() * (Mth.m_14107_((double)entity.m_20185_()) - this.f_58858_.m_123341_());
        int y = facing.m_122430_() * (Mth.m_14107_((double)entity.m_20186_()) - this.f_58858_.m_123342_());
        int z = facing.m_122431_() * (Mth.m_14107_((double)entity.m_20189_()) - this.f_58858_.m_123343_());
        boolean flag = true;
        for (int l2 = 1; l2 < Math.abs(x + y + z); ++l2) {
            if (!Block.m_49863_((LevelReader)this.f_58857_, (BlockPos)this.f_58858_.m_5484_(facing, l2), (Direction)facing.m_122424_())) continue;
            flag = false;
        }
        return flag;
    }

    public String getSliderDisplay() {
        float f = this.speed;
        f *= 100.0f;
        f = (float)Math.round(f) / 100.0f;
        return String.valueOf(f);
    }

    public AABB getDirection(Direction facing) {
        BlockPos endPos = this.f_58858_.m_5484_(facing, Mth.m_14107_((double)((double)((Integer)ConfigHandler.SERVER.FAN_RANGE.get()).intValue() + this.extraRange)));
        if (facing == Direction.WEST) {
            endPos = endPos.m_142082_(0, 1, 1);
        } else if (facing == Direction.NORTH) {
            endPos = endPos.m_142082_(1, 1, 0);
        }
        if (facing == Direction.EAST) {
            endPos = endPos.m_142082_(1, 1, 1);
        } else if (facing == Direction.SOUTH) {
            endPos = endPos.m_142082_(1, 1, 1);
        }
        if (facing == Direction.UP) {
            endPos = endPos.m_142082_(1, 1, 1);
        } else if (facing == Direction.DOWN) {
            endPos = endPos.m_142082_(1, 0, 1);
        }
        return new AABB(this.f_58858_, endPos);
    }

    public static void spawnParticles(Level world, BlockState blockState, BlockPos pos) {
        double x = (float)pos.m_123341_() + world.f_46441_.nextFloat();
        double y = (float)pos.m_123342_() + world.f_46441_.nextFloat();
        double z = (float)pos.m_123343_() + world.f_46441_.nextFloat();
        Direction facing = (Direction)blockState.m_61143_((Property)FanBlock.FACING);
        double velocity = 0.2f + world.f_46441_.nextFloat() * 0.4f;
        double velX = (double)facing.m_122429_() * velocity;
        double velY = (double)facing.m_122430_() * velocity;
        double velZ = (double)facing.m_122431_() * velocity;
        world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, velX, velY, velZ);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.speed = nbt.m_128457_("speed");
        this.extraRange = nbt.m_128459_("extraRange");
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128350_("speed", this.speed);
        compound.m_128347_("extraRange", this.extraRange);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        super.onDataPacket(net, packet);
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        }
    }
}

