/*
 * Decompiled with CFR 0.152.
 */
package trapcraft.client.renders;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.minecraft.Util;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import trapcraft.TrapcraftBlocks;
import trapcraft.api.Constants;
import trapcraft.handler.ModelHandler;

public class TileEntityMagneticChestRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    public static final Material CHEST_TRAPPED_MATERIAL = (Material)Util.m_137537_(() -> new Material(Sheets.f_110740_, Constants.RES_BLOCK_MAGNETIC_CHEST));
    private static final String BOTTOM = "bottom";
    private static final String LID = "lid";
    private static final String LOCK = "lock";
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart lock;

    public TileEntityMagneticChestRenderer(BlockEntityRendererProvider.Context p_173607_) {
        ModelPart modelpart = p_173607_.m_173582_(ModelHandler.MAGNETIC_CHEST);
        this.bottom = modelpart.m_171324_(BOTTOM);
        this.lid = modelpart.m_171324_(LID);
        this.lock = modelpart.m_171324_(LOCK);
    }

    public static LayerDefinition createSingleBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_(BOTTOM, CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f), PartPose.f_171404_);
        partdefinition.m_171599_(LID, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        partdefinition.m_171599_(LOCK, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void m_6922_(T p_112363_, float p_112364_, PoseStack p_112365_, MultiBufferSource p_112366_, int p_112367_, int p_112368_) {
        Level level = p_112363_.m_58904_();
        boolean flag = level != null;
        BlockState blockstate = flag ? p_112363_.m_58900_() : (BlockState)((Block)TrapcraftBlocks.MAGNETIC_CHEST.get()).m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.SOUTH);
        ChestType chesttype = ChestType.SINGLE;
        Block block = blockstate.m_60734_();
        if (block instanceof AbstractChestBlock) {
            AbstractChestBlock abstractchestblock = (AbstractChestBlock)block;
            boolean flag1 = chesttype != ChestType.SINGLE;
            p_112365_.m_85836_();
            float f = ((Direction)blockstate.m_61143_((Property)ChestBlock.f_51478_)).m_122435_();
            p_112365_.m_85837_(0.5, 0.5, 0.5);
            p_112365_.m_85845_(Vector3f.f_122225_.m_122240_(-f));
            p_112365_.m_85837_(-0.5, -0.5, -0.5);
            DoubleBlockCombiner.NeighborCombineResult neighborcombineresult = flag ? abstractchestblock.m_5641_(blockstate, level, p_112363_.m_58899_(), true) : DoubleBlockCombiner.Combiner::m_6502_;
            float f1 = ((Float2FloatFunction)neighborcombineresult.m_5649_(ChestBlock.m_51517_((LidBlockEntity)((LidBlockEntity)p_112363_)))).get(p_112364_);
            f1 = 1.0f - f1;
            f1 = 1.0f - f1 * f1 * f1;
            int i = ((Int2IntFunction)neighborcombineresult.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(p_112367_);
            Material material = this.getMaterial(p_112363_, chesttype);
            VertexConsumer vertexconsumer = material.m_119194_(p_112366_, RenderType::m_110452_);
            this.render(p_112365_, vertexconsumer, this.lid, this.lock, this.bottom, f1, i, p_112368_);
            p_112365_.m_85849_();
        }
    }

    private void render(PoseStack p_112370_, VertexConsumer p_112371_, ModelPart p_112372_, ModelPart p_112373_, ModelPart p_112374_, float p_112375_, int p_112376_, int p_112377_) {
        p_112373_.f_104203_ = p_112372_.f_104203_ = -(p_112375_ * 1.5707964f);
        p_112372_.m_104301_(p_112370_, p_112371_, p_112376_, p_112377_);
        p_112373_.m_104301_(p_112370_, p_112371_, p_112376_, p_112377_);
        p_112374_.m_104301_(p_112370_, p_112371_, p_112376_, p_112377_);
    }

    protected Material getMaterial(T blockEntity, ChestType chestType) {
        return new Material(Sheets.f_110740_, Constants.RES_BLOCK_MAGNETIC_CHEST);
    }
}

