/*
 * Decompiled with CFR 0.152.
 */
package trapcraft.data;

import java.util.Arrays;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import trapcraft.TrapcraftBlocks;
import trapcraft.block.BearTrapBlock;
import trapcraft.block.FanBlock;

public class TrapcraftBlockstateProvider
extends BlockStateProvider {
    public TrapcraftBlockstateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "trapcraft", exFileHelper);
    }

    public ExistingFileHelper getExistingHelper() {
        return this.models().existingFileHelper;
    }

    @Nonnull
    public String m_6055_() {
        return "Trapcraft Blockstates/Block Models";
    }

    protected void registerStatesAndModels() {
        this.registerOrientable((Supplier<? extends Block>)TrapcraftBlocks.FAN);
        this.registerOrientable((Supplier<? extends Block>)TrapcraftBlocks.IGNITER);
        this.registerGrassCovering((Supplier<? extends Block>)TrapcraftBlocks.GRASS_COVERING);
        this.registerParticleOnly((Supplier<? extends Block>)TrapcraftBlocks.MAGNETIC_CHEST, (Supplier<? extends Block>)Blocks.f_50705_.delegate);
        this.registerCross((Supplier<? extends Block>)TrapcraftBlocks.SPIKES);
        this.registerBearTrap((Supplier<? extends Block>)TrapcraftBlocks.BEAR_TRAP);
    }

    protected void registerBearTrap(Supplier<? extends Block> blockIn) {
        BlockModelBuilder modelClosed = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.extend(blockIn, "_closed"))).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/block")))).texture("particle", this.blockTexture(blockIn))).texture("base", this.blockTexture(blockIn));
        modelClosed.element().from(1.6f, 0.0f, 5.6f).to(2.4f, 7.2f, 6.4f).cube("#base");
        modelClosed.element().from(1.6f, 0.0f, 9.6f).to(2.4f, 7.2f, 10.4f).cube("#base");
        modelClosed.element().from(13.6f, 0.0f, 5.6f).to(14.4f, 7.2f, 6.4f).cube("#base");
        modelClosed.element().from(13.6f, 0.0f, 9.6f).to(14.4f, 7.2f, 10.4f).cube("#base");
        modelClosed.element().from(13.6f, 0.0f, 6.4f).to(14.4f, 0.8f, 9.6f).cube("#base");
        modelClosed.element().from(1.6f, 0.0f, 6.4f).to(2.4f, 0.8f, 9.6f).cube("#base");
        modelClosed.element().from(2.4f, 0.0f, 6.4f).to(13.6f, 0.48f, 9.6f).cube("#base");
        modelClosed.element().from(2.4f, 6.4f, 5.6f).to(13.6f, 7.2f, 6.4f).cube("#base");
        modelClosed.element().from(2.4f, 6.4f, 9.6f).to(13.6f, 7.2f, 10.4f).cube("#base");
        modelClosed.element().from(4.0f, 6.4f, 6.4f).to(4.8f, 7.2f, 9.6f).cube("#base");
        modelClosed.element().from(6.4f, 6.4f, 6.4f).to(7.2f, 7.2f, 9.6f).cube("#base");
        modelClosed.element().from(8.8f, 6.4f, 6.4f).to(9.6f, 7.2f, 9.6f).cube("#base");
        modelClosed.element().from(11.2f, 6.4f, 6.4f).to(12.0f, 7.2f, 9.6f).cube("#base");
        BlockModelBuilder modelOpen = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.extend(blockIn, "_open"))).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/block")))).texture("particle", this.blockTexture(blockIn))).texture("base", this.blockTexture(blockIn));
        modelOpen.element().from(13.6f, 0.0f, 0.0f).to(14.4f, 0.8f, 16.0f).cube("#base");
        modelOpen.element().from(1.6f, 0.0f, 0.0f).to(2.4f, 0.8f, 16.0f).cube("#base");
        modelOpen.element().from(2.4f, 0.0f, 0.0f).to(13.6f, 0.8f, 0.8f).cube("#base");
        modelOpen.element().from(2.4f, 0.0f, 0.0f).to(13.6f, 0.8f, 0.8f).cube("#base");
        modelOpen.element().from(2.4f, 0.0f, 15.2f).to(13.6f, 0.8f, 16.0f).cube("#base");
        modelOpen.element().from(4.0f, 0.8f, 0.0f).to(4.8f, 2.4f, 0.8f).cube("#base");
        modelOpen.element().from(6.4f, 0.8f, 0.0f).to(7.2f, 2.4f, 0.8f).cube("#base");
        modelOpen.element().from(8.8f, 0.8f, 0.0f).to(9.6f, 2.4f, 0.8f).cube("#base");
        modelOpen.element().from(11.2f, 0.8f, 0.0f).to(12.0f, 2.4f, 0.8f).cube("#base");
        modelOpen.element().from(4.0f, 0.8f, 15.2f).to(4.8f, 2.4f, 16.0f).cube("#base");
        modelOpen.element().from(6.4f, 0.8f, 15.2f).to(7.2f, 2.4f, 16.0f).cube("#base");
        modelOpen.element().from(8.8f, 0.8f, 15.2f).to(9.6f, 2.4f, 16.0f).cube("#base");
        modelOpen.element().from(11.2f, 0.8f, 15.2f).to(12.0f, 2.4f, 16.0f).cube("#base");
        modelOpen.element().from(2.4f, 0.0f, 6.4f).to(13.6f, 0.48f, 9.6f).cube("#base");
        this.getVariantBuilder(blockIn.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)((Boolean)state.m_61143_((Property)BearTrapBlock.TRIGGERED) != false ? modelClosed : modelOpen)).build(), new Property[]{BearTrapBlock.WATERLOGGED});
    }

    protected void registerGrassCovering(Supplier<? extends Block> blockIn) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(blockIn))).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/block")))).texture("top", this.extend(this.blockTexture((Supplier<? extends Block>)Blocks.f_50440_.delegate), "_top"))).texture("side", this.extend(this.blockTexture((Supplier<? extends Block>)Blocks.f_50440_.delegate), "_top"))).texture("overlay", this.extend(this.blockTexture((Supplier<? extends Block>)Blocks.f_50440_.delegate), "_top"))).texture("particle", this.blockTexture((Supplier<? extends Block>)Blocks.f_50493_.delegate))).texture("bottom", this.blockTexture((Supplier<? extends Block>)Blocks.f_50493_.delegate));
        model.element().from(0.0f, 15.0f, 0.0f).to(16.0f, 16.0f, 16.0f).allFaces((d, b) -> b.texture(d.m_122434_().m_122479_() ? "#side" : (d == Direction.UP ? "#top" : "#bottom")).cullface(d).tintindex(d == Direction.UP ? 0 : -1));
        ModelBuilder.ElementBuilder overlayBuilder = model.element();
        Arrays.stream(Direction.values()).filter(d -> d.m_122434_().m_122479_()).forEach(arg_0 -> ((ModelBuilder.ElementBuilder)overlayBuilder).face(arg_0));
        overlayBuilder.from(0.0f, 15.0f, 0.0f).to(16.0f, 16.0f, 16.0f).faces((d, b) -> b.texture("#overlay").cullface(d).tintindex(0));
        this.simpleBlock(blockIn.get(), (ModelFile)model);
    }

    protected void registerOrientable(Supplier<? extends Block> blockIn) {
        BlockModelBuilder model = (BlockModelBuilder)this.models().withExistingParent(this.name(blockIn), "block/block");
        model.element().allFaces((dir, f) -> {
            if (dir.m_122434_() == Direction.Axis.Z) {
                f = f.texture(dir == Direction.NORTH ? "#top" : "#bottom");
            } else {
                f = f.texture("#side");
                f = f.rotation(dir == Direction.UP ? ModelBuilder.FaceRotation.ZERO : (dir == Direction.EAST ? ModelBuilder.FaceRotation.CLOCKWISE_90 : (dir == Direction.DOWN ? ModelBuilder.FaceRotation.UPSIDE_DOWN : ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90)));
            }
            f = f.cullface(dir);
        });
        model.texture("side", this.extend(this.blockTexture(blockIn), "_side"));
        model.texture("top", this.extend(this.blockTexture(blockIn), "_top"));
        model.texture("bottom", this.extend(this.blockTexture(blockIn), "_bottom"));
        model.texture("particle", this.extend(this.blockTexture(blockIn), "_side"));
        ModelBuilder modelVertical = this.models().orientableWithBottom(this.name(blockIn) + "_vertical", this.extend(this.blockTexture(blockIn), "_side"), this.extend(this.blockTexture(blockIn), "_side"), this.extend(this.blockTexture(blockIn), "_bottom"), this.extend(this.blockTexture(blockIn), "_top"));
        this.getVariantBuilder(blockIn.get()).forAllStatesExcept(arg_0 -> TrapcraftBlockstateProvider.lambda$registerOrientable$5((ModelFile)modelVertical, model, arg_0), new Property[]{FanBlock.POWERED});
    }

    private void registerParticleOnly(Supplier<? extends Block> blockIn, Supplier<? extends Block> particle) {
        ModelBuilder model = ((BlockModelBuilder)this.models().getBuilder(this.name(blockIn))).texture("particle", this.blockTexture(particle));
        this.simpleBlock(blockIn.get(), (ModelFile)model);
    }

    private void registerCross(Supplier<? extends Block> block) {
        ModelBuilder model = this.models().cross(this.name(block), this.blockTexture(block));
        this.simpleBlock(block.get(), (ModelFile)model);
    }

    private String name(Supplier<? extends IForgeRegistryEntry<?>> forgeEntry) {
        return forgeEntry.get().getRegistryName().m_135815_();
    }

    private ResourceLocation blockTexture(Supplier<? extends Block> block) {
        ResourceLocation base = block.get().getRegistryName();
        return this.prepend(base, "block/");
    }

    private ResourceLocation prepend(ResourceLocation rl, String prefix) {
        return new ResourceLocation(rl.m_135827_(), prefix + rl.m_135815_());
    }

    private String extend(Supplier<? extends IForgeRegistryEntry<?>> forgeEntry, String suffix) {
        return this.extend(forgeEntry.get().getRegistryName(), suffix).m_135815_();
    }

    private ResourceLocation extend(ResourceLocation rl, String suffix) {
        return new ResourceLocation(rl.m_135827_(), rl.m_135815_() + suffix);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerOrientable$5(ModelFile modelVertical, BlockModelBuilder model, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)FanBlock.FACING);
        int xRot = 0;
        int yRot = (int)facing.m_122435_() + 180;
        boolean vertical = facing.m_122434_().m_122478_();
        if (vertical) {
            xRot = facing.m_122421_() == Direction.AxisDirection.NEGATIVE ? 180 : 0;
            yRot = 0;
        }
        return ConfiguredModel.builder().modelFile((ModelFile)(vertical ? modelVertical : model)).rotationX(xRot).rotationY(yRot %= 360).build();
    }
}

