/*
 * Decompiled with CFR 0.152.
 */
package trapcraft;

import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.core.BlockPos;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import trapcraft.TrapcraftBlocks;
import trapcraft.TrapcraftContainerTypes;
import trapcraft.TrapcraftEntityTypes;
import trapcraft.TrapcraftItems;
import trapcraft.TrapcraftTileEntityTypes;
import trapcraft.api.Constants;
import trapcraft.client.gui.IgniterScreen;
import trapcraft.config.ConfigHandler;
import trapcraft.data.TrapcraftBlockstateProvider;
import trapcraft.data.TrapcraftItemModelProvider;
import trapcraft.data.TrapcraftLootTableProvider;
import trapcraft.data.TrapcraftRecipeProvider;
import trapcraft.handler.ActionHandler;
import trapcraft.handler.ModelHandler;
import trapcraft.network.PacketHandler;

@Mod(value="trapcraft")
public final class TrapcraftMod {
    public static final Logger LOGGER = LogManager.getLogger((String)"Trapcraft");
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    public static final SimpleChannel HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("trapcraft", "channel")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    public static TrapcraftMod INSTANCE;

    public TrapcraftMod() {
        INSTANCE = this;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        TrapcraftBlocks.BLOCKS.register(modEventBus);
        TrapcraftTileEntityTypes.TILE_ENTITIES.register(modEventBus);
        TrapcraftItems.ITEMS.register(modEventBus);
        TrapcraftEntityTypes.ENTITIES.register(modEventBus);
        TrapcraftContainerTypes.CONTAINERS.register(modEventBus);
        modEventBus.addListener(this::gatherData);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::interModProcess);
        modEventBus.addListener(TrapcraftEntityTypes::addEntityAttributes);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modEventBus.addListener(this::clientSetup);
            modEventBus.addListener(this::registerBlockColors);
            modEventBus.addListener(this::registerItemColors);
            modEventBus.addListener(this::addTexturesToAtlas);
            modEventBus.register((Object)new ModelHandler());
        });
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.register((Object)new ActionHandler());
        ConfigHandler.init(modEventBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        PacketHandler.register();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSetup(FMLClientSetupEvent event) {
        MenuScreens.m_96206_((MenuType)((MenuType)TrapcraftContainerTypes.IGNITER.get()), IgniterScreen::new);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TrapcraftBlocks.SPIKES.get()), (RenderType)RenderType.m_110463_());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerBlockColors(ColorHandlerEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        blockColors.m_92589_((state, blockAccess, pos, tintIndex) -> blockAccess != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)blockAccess, (BlockPos)pos) : -1, new Block[]{(Block)TrapcraftBlocks.GRASS_COVERING.get()});
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerItemColors(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        itemColors.m_92689_((stack, tintIndex) -> GrassColor.m_46415_((double)0.5, (double)1.0), new ItemLike[]{(ItemLike)TrapcraftBlocks.GRASS_COVERING.get()});
    }

    @OnlyIn(value=Dist.CLIENT)
    private void addTexturesToAtlas(TextureStitchEvent.Pre event) {
        if (event.getAtlas().m_118330_().equals((Object)Sheets.f_110740_)) {
            event.addSprite(Constants.RES_BLOCK_MAGNETIC_CHEST);
        }
    }

    private void interModProcess(InterModProcessEvent event) {
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeClient()) {
            TrapcraftBlockstateProvider blockstates = new TrapcraftBlockstateProvider(gen, event.getExistingFileHelper());
            gen.m_123914_((DataProvider)blockstates);
            gen.m_123914_((DataProvider)new TrapcraftItemModelProvider(gen, blockstates.getExistingHelper()));
        }
        if (event.includeServer()) {
            gen.m_123914_((DataProvider)new TrapcraftRecipeProvider(gen));
            gen.m_123914_((DataProvider)new TrapcraftLootTableProvider(gen));
        }
    }
}

