/*
 * Decompiled with CFR 0.152.
 */
package trapcraft.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkHooks;
import trapcraft.TrapcraftTileEntityTypes;
import trapcraft.block.tileentity.IgniterTileEntity;

public class IgniterBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;

    public IgniterBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(3.5f, 2.0f).m_60918_(SoundType.f_56742_));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.WEST));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        IgniterTileEntity tileentityigniter = (IgniterTileEntity)worldIn.m_7702_(pos);
        if (tileentityigniter != null && player instanceof ServerPlayer && !(player instanceof FakePlayer)) {
            ServerPlayer entityPlayerMP = (ServerPlayer)player;
            NetworkHooks.openGui((ServerPlayer)entityPlayerMP, (MenuProvider)tileentityigniter, (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        this.updateIgniterState((Level)world, pos);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!worldIn.f_46443_) {
            this.updateIgniterState(worldIn, pos);
        }
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.f_46443_) {
            this.updateIgniterState(worldIn, pos);
        }
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.m_60734_() != state.m_60734_() && !worldIn.f_46443_) {
            this.updateIgniterState(worldIn, pos);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_());
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public void updateIgniterState(Level world, BlockPos pos) {
        IgniterTileEntity igniter;
        Direction facing = (Direction)world.m_8055_(pos).m_61143_((Property)FACING);
        int distance = 1;
        int oldDistance = 1;
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof IgniterTileEntity) {
            igniter = (IgniterTileEntity)world.m_7702_(pos);
            distance = igniter.getRangeUpgrades() + 1;
            oldDistance = igniter.lastUpgrades + 1;
        }
        this.updateIgniterState(world, pos, world.m_46753_(pos), facing, distance, oldDistance);
        if (tileEntity instanceof IgniterTileEntity) {
            igniter = (IgniterTileEntity)world.m_7702_(pos);
            igniter.lastUpgrades = distance - 1;
        }
    }

    private void updateIgniterState(Level world, BlockPos pos, boolean powered, Direction direction, int newDistance, int previousDistance) {
        if (newDistance != previousDistance) {
            BlockPos oldPos = pos.m_5484_(direction, previousDistance);
            this.removePossibleFire(world, oldPos);
        }
        BlockPos firePos = pos.m_5484_(direction, newDistance);
        if (powered) {
            BlockState fire = Blocks.f_50083_.m_49966_();
            if (!world.m_8055_(firePos).m_60713_(Blocks.f_50083_) && world.m_46859_(firePos) && fire.m_60710_((LevelReader)world, firePos)) {
                world.m_46597_(firePos, fire);
            }
        } else if (!powered) {
            this.removePossibleFire(world, firePos);
        }
    }

    public void removePossibleFire(Level world, BlockPos pos) {
        if (world.m_8055_(pos).m_60734_() == Blocks.f_50083_) {
            world.m_46597_(pos, Blocks.f_50016_.m_49966_());
            world.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)((float)pos.m_123343_() + 0.5f), SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (world.f_46441_.nextFloat() - world.f_46441_.nextFloat()) * 0.8f, true);
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState blockState) {
        return new IgniterTileEntity(pos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return IgniterBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)TrapcraftTileEntityTypes.IGNITER.get()), IgniterTileEntity::tick);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileentity;
        if (state.m_60734_() != newState.m_60734_() && (tileentity = worldIn.m_7702_(pos)) instanceof IgniterTileEntity) {
            int upgrades = ((IgniterTileEntity)tileentity).getRangeUpgrades() + 1;
            this.updateIgniterState(worldIn, pos, false, (Direction)state.m_61143_((Property)FACING), upgrades, upgrades);
            Containers.m_19002_((Level)worldIn, (BlockPos)pos, (Container)((IgniterTileEntity)tileentity).inventory);
            worldIn.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }
}

