/*
 * Decompiled with CFR 0.152.
 */
package trapcraft.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import trapcraft.TrapcraftTileEntityTypes;
import trapcraft.block.tileentity.BearTrapTileEntity;

public class BearTrapBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final BooleanProperty TRIGGERED = BooleanProperty.m_61465_((String)"triggered");

    public BearTrapBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60955_().m_60913_(2.0f, 2.0f).m_60918_(SoundType.f_56743_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState blockState) {
        return new BearTrapTileEntity(pos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return BearTrapBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)TrapcraftTileEntityTypes.BEAR_TRAP.get()), BearTrapTileEntity::tick);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BearTrapTileEntity bearTrap = (BearTrapTileEntity)worldIn.m_7702_(pos);
        if (((Boolean)state.m_61143_((Property)TRIGGERED)).booleanValue()) {
            if (worldIn.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (!bearTrap.hasTrappedEntity()) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 3);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext selectionContext) {
        return SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext selectionContext) {
        return Shapes.m_83040_();
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (((Boolean)state.m_61143_((Property)TRIGGERED)).booleanValue()) {
            return;
        }
        if (entity instanceof Player || !(entity instanceof Mob)) {
            return;
        }
        Mob livingEntity = (Mob)entity;
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 3);
        BearTrapTileEntity bearTrap = (BearTrapTileEntity)world.m_7702_(pos);
        bearTrap.setTrappedEntity(livingEntity);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState ifluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return Block.m_49863_((LevelReader)worldIn, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return (Boolean)blockState.m_61143_((Property)TRIGGERED) != false ? 15 : 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TRIGGERED, WATERLOGGED});
    }

    public boolean m_7899_(BlockState state) {
        return (Boolean)state.m_61143_((Property)TRIGGERED);
    }

    public int m_6378_(BlockState blockState, BlockGetter blockReader, BlockPos pos, Direction side) {
        if (!blockState.m_60803_()) {
            return 0;
        }
        return 15;
    }

    public int m_6376_(BlockState blockState, BlockGetter blockReader, BlockPos pos, Direction side) {
        return side == Direction.UP ? blockState.m_60746_(blockReader, pos, side) : 0;
    }
}

