/*
 * Decompiled with CFR 0.152.
 */
package trapcraft;

import java.util.function.Supplier;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import trapcraft.TrapcraftBlocks;
import trapcraft.TrapcraftContainerTypes;
import trapcraft.TrapcraftEntityTypes;
import trapcraft.TrapcraftItems;
import trapcraft.TrapcraftTileEntityTypes;
import trapcraft.client.gui.IgniterScreen;
import trapcraft.config.ConfigHandler;
import trapcraft.data.TrapcraftBlockstateProvider;
import trapcraft.data.TrapcraftItemModelProvider;
import trapcraft.data.TrapcraftLootTableProvider;
import trapcraft.data.TrapcraftRecipeProvider;
import trapcraft.handler.ActionHandler;
import trapcraft.handler.ModelHandler;
import trapcraft.network.PacketHandler;

@Mod(value="trapcraft")
public final class TrapcraftMod {
    public static final Logger LOGGER = LogManager.getLogger((String)"Trapcraft");
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    public static final SimpleChannel HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("trapcraft", "channel")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    public static TrapcraftMod INSTANCE;

    public TrapcraftMod() {
        INSTANCE = this;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        TrapcraftBlocks.BLOCKS.register(modEventBus);
        TrapcraftTileEntityTypes.TILE_ENTITIES.register(modEventBus);
        TrapcraftItems.ITEMS.register(modEventBus);
        TrapcraftEntityTypes.ENTITIES.register(modEventBus);
        TrapcraftContainerTypes.CONTAINERS.register(modEventBus);
        modEventBus.addListener(this::gatherData);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::interModProcess);
        modEventBus.addListener(this::creativeModeTabBuildEvent);
        modEventBus.addListener(TrapcraftEntityTypes::addEntityAttributes);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modEventBus.addListener(this::clientSetup);
            modEventBus.addListener(this::registerBlockColors);
            modEventBus.addListener(this::registerItemColors);
            modEventBus.register((Object)new ModelHandler());
        });
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.register((Object)new ActionHandler());
        ConfigHandler.init(modEventBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        PacketHandler.register();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSetup(FMLClientSetupEvent event) {
        MenuScreens.m_96206_((MenuType)((MenuType)TrapcraftContainerTypes.IGNITER.get()), IgniterScreen::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((state, blockAccess, pos, tintIndex) -> blockAccess != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)blockAccess, (BlockPos)pos) : -1, new Block[]{(Block)TrapcraftBlocks.GRASS_COVERING.get()});
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> GrassColor.m_46415_((double)0.5, (double)1.0), new ItemLike[]{(ItemLike)TrapcraftBlocks.GRASS_COVERING.get()});
    }

    private void interModProcess(InterModProcessEvent event) {
    }

    public void creativeModeTabBuildEvent(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_257028_) {
            for (RegistryObject item : TrapcraftItems.ITEMS.getEntries()) {
                event.accept((Supplier)item);
            }
            for (RegistryObject blockItem : TrapcraftBlocks.ITEMS.getEntries()) {
                event.accept((Supplier)blockItem);
            }
        }
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        if (event.includeClient()) {
            TrapcraftBlockstateProvider blockstates = new TrapcraftBlockstateProvider(packOutput, event.getExistingFileHelper());
            gen.addProvider(true, (DataProvider)blockstates);
            gen.addProvider(true, (DataProvider)new TrapcraftItemModelProvider(packOutput, blockstates.getExistingHelper()));
        }
        if (event.includeServer()) {
            gen.addProvider(true, (DataProvider)new TrapcraftRecipeProvider(packOutput));
            gen.addProvider(true, (DataProvider)new TrapcraftLootTableProvider(packOutput));
        }
    }
}

