/*
 * Decompiled with CFR 0.152.
 */
package trofers;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import trofers.common.init.ModBlockEntityTypes;
import trofers.common.init.ModBlocks;
import trofers.common.init.ModItems;
import trofers.common.trophy.Trophy;
import trofers.common.trophy.block.TrophyBlockEntity;
import trofers.common.trophy.block.TrophyBlockEntityRenderer;

public class TrofersClient {
    public TrofersClient() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::onClientSetup);
        modEventBus.addListener(this::onBlockColorHandler);
        modEventBus.addListener(this::onItemColorHandler);
    }

    public void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModBlockEntityTypes.TROPHY.get()), TrophyBlockEntityRenderer::new));
        ModBlocks.TROPHIES.forEach(trophy -> RenderTypeLookup.setRenderLayer((Block)((Block)trophy.get()), (RenderType)RenderType.func_228643_e_()));
    }

    public void onBlockColorHandler(ColorHandlerEvent.Block event) {
        event.getBlockColors().func_186722_a((state, level, pos, index) -> {
            TileEntity blockEntity;
            if (index >= 0 && index < 3 && level != null && pos != null && (blockEntity = level.func_175625_s(pos)) instanceof TrophyBlockEntity) {
                Trophy trophy = ((TrophyBlockEntity)blockEntity).getTrophy();
                if (trophy == null) {
                    return 0xFFFFFF;
                }
                if (index == 0) {
                    return trophy.colors().base();
                }
                if (index == 1) {
                    return trophy.colors().accent();
                }
            }
            return 0xFFFFFF;
        }, (Block[])ModBlocks.TROPHIES.stream().map(RegistryObject::get).toArray(Block[]::new));
    }

    public void onItemColorHandler(ColorHandlerEvent.Item event) {
        event.getItemColors().func_199877_a((stack, index) -> {
            Trophy trophy = Trophy.getTrophy(stack);
            if (trophy != null) {
                if (index == 0) {
                    return trophy.colors().base();
                }
                if (index == 1) {
                    return trophy.colors().accent();
                }
            }
            return 0xFFFFFF;
        }, (IItemProvider[])ModItems.TROPHIES.stream().map(RegistryObject::get).toArray(Item[]::new));
    }
}

