/*
 * Decompiled with CFR 0.152.
 */
package trofers.common.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import trofers.common.trophy.Trophy;
import trofers.common.trophy.TrophyManager;

public class TrophySyncPacket {
    private final Map<ResourceLocation, Trophy> trophies;

    public TrophySyncPacket(PacketBuffer buffer) {
        this.trophies = new HashMap<ResourceLocation, Trophy>();
        while (buffer.readBoolean()) {
            Trophy trophy = Trophy.fromNetwork(buffer);
            this.trophies.put(trophy.id(), trophy);
        }
    }

    public TrophySyncPacket(Map<ResourceLocation, Trophy> trophies) {
        this.trophies = trophies;
    }

    void encode(PacketBuffer buffer) {
        this.trophies.values().forEach(trophy -> {
            buffer.writeBoolean(true);
            trophy.toNetwork(buffer);
        });
        buffer.writeBoolean(false);
    }

    void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> TrophyManager.setTrophies(this.trophies));
        context.get().setPacketHandled(true);
    }
}

