/*
 * Decompiled with CFR 0.152.
 */
package trofers.common.trophy;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;
import trofers.common.trophy.TrophyManager;

public final class Trophy {
    private final ResourceLocation id;
    @Nullable
    private final ITextComponent name;
    private final DisplayInfo display;
    private final Animation animation;
    private final ItemStack item;
    @Nullable
    private final EntityInfo entity;
    private final ColorInfo colors;
    private final boolean isHidden;

    public Trophy(ResourceLocation id, @Nullable ITextComponent name, DisplayInfo display, Animation animation, ItemStack item, @Nullable EntityInfo entity, ColorInfo colors, boolean isHidden) {
        this.id = id;
        this.name = name;
        this.display = display;
        this.animation = animation;
        this.item = item;
        this.entity = entity;
        this.colors = colors;
        this.isHidden = isHidden;
    }

    @Nullable
    public static Trophy getTrophy(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return null;
        }
        CompoundNBT blockEntityTag = tag.func_74775_l("BlockEntityTag");
        if (!blockEntityTag.func_150297_b("Trophy", 8)) {
            return null;
        }
        try {
            return TrophyManager.get(new ResourceLocation(blockEntityTag.func_74779_i("Trophy")));
        }
        catch (ResourceLocationException resourceLocationException) {
            return null;
        }
    }

    public void toNetwork(PacketBuffer buffer) {
        buffer.func_192572_a(this.id);
        buffer.writeBoolean(this.name != null);
        if (this.name != null) {
            buffer.func_179256_a(this.name);
        }
        this.display.toNetwork(buffer);
        this.animation.toNetwork(buffer);
        buffer.func_150788_a(this.item);
        buffer.writeBoolean(this.entity != null);
        if (this.entity != null) {
            this.entity.toNetwork(buffer);
        }
        this.colors.toNetwork(buffer);
        buffer.writeBoolean(this.isHidden);
    }

    public static Trophy fromNetwork(PacketBuffer buffer) {
        ResourceLocation id = buffer.func_192575_l();
        ITextComponent name = null;
        if (buffer.readBoolean()) {
            name = buffer.func_179258_d();
        }
        DisplayInfo display = DisplayInfo.fromNetwork(buffer);
        Animation animation = Animation.fromNetwork(buffer);
        ItemStack item = buffer.func_150791_c();
        EntityInfo entity = null;
        if (buffer.readBoolean()) {
            entity = EntityInfo.fromNetwork(buffer);
        }
        ColorInfo colors = ColorInfo.fromNetwork(buffer);
        boolean isHidden = buffer.readBoolean();
        return new Trophy(id, name, display, animation, item, entity, colors, isHidden);
    }

    public JsonObject toJson() {
        JsonObject result = new JsonObject();
        result.add("name", ITextComponent.Serializer.func_200528_b((ITextComponent)this.name()));
        if (!this.display().equals(DisplayInfo.NONE)) {
            result.add("display", (JsonElement)this.display().toJson());
        }
        if (this.animation().type() != Animation.Type.FIXED) {
            result.add("animation", (JsonElement)this.animation().toJson());
        }
        if (!this.item().func_190926_b()) {
            result.add("item", (JsonElement)Trophy.serializeItem(this.item()));
        }
        if (this.entity() != null) {
            result.add("entity", (JsonElement)this.entity().toJson());
        }
        if (!this.colors().equals(ColorInfo.NONE)) {
            result.add("colors", (JsonElement)this.colors().toJson());
        }
        if (this.isHidden()) {
            result.addProperty("isHidden", Boolean.valueOf(true));
        }
        return result;
    }

    private static JsonObject serializeItem(ItemStack item) {
        JsonObject result = new JsonObject();
        result.addProperty("item", item.func_77973_b().getRegistryName().toString());
        if (item.func_190916_E() != 1) {
            result.addProperty("count", (Number)item.func_190916_E());
        }
        if (item.func_77942_o()) {
            result.addProperty("nbt", item.func_77978_p().toString());
        }
        return result;
    }

    public static Trophy fromJson(JsonElement element, ResourceLocation id) {
        JsonObject object = JSONUtils.func_151210_l((JsonElement)element, (String)"trophy");
        EntityInfo entity = null;
        if (object.has("entity")) {
            entity = EntityInfo.fromJson(JSONUtils.func_152754_s((JsonObject)object, (String)"entity"));
        }
        ItemStack item = ItemStack.field_190927_a;
        if (object.has("item")) {
            item = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)object, (String)"item"), (boolean)true);
        }
        Animation animation = Animation.STATIC;
        if (object.has("animation")) {
            animation = Animation.fromJson(JSONUtils.func_152754_s((JsonObject)object, (String)"animation"));
        }
        DisplayInfo display = DisplayInfo.NONE;
        if (object.has("display")) {
            display = DisplayInfo.fromJson(JSONUtils.func_152754_s((JsonObject)object, (String)"display"));
        }
        ColorInfo colors = ColorInfo.NONE;
        if (object.has("colors")) {
            colors = ColorInfo.fromJson(JSONUtils.func_152754_s((JsonObject)object, (String)"colors"));
        }
        IFormattableTextComponent name = null;
        if (object.has("name")) {
            name = ITextComponent.Serializer.func_240641_a_((JsonElement)object.get("name"));
        }
        boolean isHidden = false;
        if (object.has("isHidden")) {
            isHidden = JSONUtils.func_151212_i((JsonObject)object, (String)"isHidden");
        }
        return new Trophy(id, (ITextComponent)name, display, animation, item, entity, colors, isHidden);
    }

    private static CompoundNBT readNBT(JsonElement element) {
        try {
            if (element.isJsonObject()) {
                return JsonToNBT.func_180713_a((String)TrophyManager.GSON.toJson(element));
            }
            return JsonToNBT.func_180713_a((String)JSONUtils.func_151206_a((JsonElement)element, (String)"nbt"));
        }
        catch (CommandSyntaxException exception) {
            throw new JsonSyntaxException(String.format("Invalid NBT Entry: %s", new Object[]{exception}));
        }
    }

    private static float readOptionalFloat(JsonObject object, String memberName, int defaultValue) {
        if (object.has(memberName)) {
            return JSONUtils.func_151217_k((JsonObject)object, (String)memberName);
        }
        return defaultValue;
    }

    public ResourceLocation id() {
        return this.id;
    }

    @Nullable
    public ITextComponent name() {
        return this.name;
    }

    public DisplayInfo display() {
        return this.display;
    }

    public Animation animation() {
        return this.animation;
    }

    public ItemStack item() {
        return this.item;
    }

    @Nullable
    public EntityInfo entity() {
        return this.entity;
    }

    public ColorInfo colors() {
        return this.colors;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Trophy trophy = (Trophy)obj;
        return Objects.equals(this.id, trophy.id) && Objects.equals(this.name, trophy.name) && Objects.equals(this.display, trophy.display) && Objects.equals(this.animation, trophy.animation) && Objects.equals(this.item, trophy.item) && Objects.equals(this.entity, trophy.entity) && Objects.equals(this.colors, trophy.colors) && this.isHidden == trophy.isHidden;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.display, this.animation, this.item, this.entity, this.colors, this.isHidden);
    }

    public String toString() {
        return "Trophy[id=" + this.id + ", name=" + this.name + ", display=" + this.display + ", animation=" + this.animation + ", item=" + this.item + ", entity=" + this.entity + ", colors=" + this.colors + ", isHidden=" + this.isHidden + ']';
    }

    public static class EntityInfo {
        private final EntityType<?> type;
        private final CompoundNBT nbt;
        private final boolean isAnimated;
        @Nullable
        private Entity entity;

        public EntityInfo(EntityType<?> type, CompoundNBT nbt, boolean isAnimated) {
            this.type = type;
            this.nbt = nbt;
            this.isAnimated = isAnimated;
        }

        @Nullable
        public EntityType<?> getType() {
            return this.type;
        }

        public CompoundNBT getTag() {
            return this.nbt;
        }

        public boolean isAnimated() {
            return this.isAnimated;
        }

        @Nullable
        public Entity getOrCreateEntity(World level) {
            if (this.entity == null || this.entity.field_70170_p != level) {
                this.createEntity(level);
            }
            return this.entity;
        }

        private void createEntity(World level) {
            if (this.type == null) {
                return;
            }
            this.entity = this.type.func_200721_a(level);
            if (this.entity != null) {
                this.entity.func_145769_d(0);
                this.entity.func_70020_e(this.nbt);
                if (!this.nbt.func_186855_b("UUID")) {
                    this.entity.func_184221_a(Util.field_240973_b_);
                }
            }
        }

        public void toNetwork(PacketBuffer buffer) {
            buffer.func_192572_a(this.type.getRegistryName());
            buffer.func_150786_a(this.nbt);
            buffer.writeBoolean(this.isAnimated);
        }

        public static EntityInfo fromNetwork(PacketBuffer buffer) {
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(buffer.func_192575_l());
            return new EntityInfo(type, buffer.func_150793_b(), buffer.readBoolean());
        }

        public JsonObject toJson() {
            JsonObject result = new JsonObject();
            result.addProperty("type", this.getType().getRegistryName().toString());
            if (!this.getTag().isEmpty()) {
                result.addProperty("nbt", this.getTag().toString());
            }
            if (this.isAnimated()) {
                result.addProperty("animated", Boolean.valueOf(this.isAnimated()));
            }
            return result;
        }

        public static EntityInfo fromJson(JsonObject object) {
            ResourceLocation typeID = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"type"));
            if (!ForgeRegistries.ENTITIES.containsKey(typeID)) {
                throw new JsonParseException(String.format("Unknown entity type %s", typeID));
            }
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(typeID);
            CompoundNBT nbt = new CompoundNBT();
            if (object.has("nbt")) {
                JsonElement nbtElement = object.get("nbt");
                nbt = Trophy.readNBT(nbtElement);
            }
            boolean isAnimated = false;
            if (object.has("animated")) {
                isAnimated = JSONUtils.func_151212_i((JsonObject)object, (String)"animated");
            }
            return new EntityInfo(type, nbt, isAnimated);
        }
    }

    public static final class ColorInfo {
        public static final ColorInfo NONE = new ColorInfo(0xFFFFFF, 0xFFFFFF);
        private final int base;
        private final int accent;

        public ColorInfo(int base, int accent) {
            this.base = base;
            this.accent = accent;
        }

        public void toNetwork(PacketBuffer buffer) {
            buffer.writeInt(this.base);
            buffer.writeInt(this.accent);
        }

        public static ColorInfo fromNetwork(PacketBuffer buffer) {
            return new ColorInfo(buffer.readInt(), buffer.readInt());
        }

        public JsonObject toJson() {
            JsonObject result = new JsonObject();
            if (this.base() != 0xFFFFFF) {
                result.add("base", ColorInfo.serializeColor(this.base()));
            }
            if (this.accent() != this.base()) {
                result.add("accent", ColorInfo.serializeColor(this.accent()));
            }
            return result;
        }

        private static JsonElement serializeColor(int color) {
            return new JsonPrimitive(String.format("#%06X", color));
        }

        public static ColorInfo fromJson(JsonObject object) {
            int accent = 0xFFFFFF;
            int base = 0xFFFFFF;
            if (object.has("base")) {
                base = accent = ColorInfo.readColor(object.get("base"));
            }
            if (object.has("accent")) {
                accent = ColorInfo.readColor(object.get("accent"));
            }
            return new ColorInfo(base, accent);
        }

        private static int readColor(JsonElement element) {
            if (element.isJsonObject()) {
                JsonObject object = element.getAsJsonObject();
                int red = JSONUtils.func_151203_m((JsonObject)object, (String)"red");
                int green = JSONUtils.func_151203_m((JsonObject)object, (String)"green");
                int blue = JSONUtils.func_151203_m((JsonObject)object, (String)"blue");
                return red << 16 | green << 8 | blue;
            }
            if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                return ColorInfo.parseColor(element.getAsString());
            }
            throw new JsonParseException(String.format("Expected color to be json object or string, got %s", element));
        }

        private static int parseColor(String string) {
            if (string.startsWith("#")) {
                return Integer.parseInt(string.substring(1), 16);
            }
            throw new JsonParseException(String.format("Couldn't parse color string: %s", string));
        }

        public int base() {
            return this.base;
        }

        public int accent() {
            return this.accent;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ColorInfo colorInfo = (ColorInfo)obj;
            return this.base == colorInfo.base && this.accent == colorInfo.accent;
        }

        public int hashCode() {
            return Objects.hash(this.base, this.accent);
        }

        public String toString() {
            return "ColorInfo[base=" + this.base + ", accent=" + this.accent + ']';
        }
    }

    public static final class DisplayInfo {
        public static final DisplayInfo NONE = new DisplayInfo(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        private final float xOffset;
        private final float yOffset;
        private final float zOffset;
        private final float xRotation;
        private final float yRotation;
        private final float zRotation;
        private final float scale;

        public DisplayInfo(float xOffset, float yOffset, float zOffset, float xRotation, float yRotation, float zRotation, float scale) {
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.zOffset = zOffset;
            this.xRotation = xRotation;
            this.yRotation = yRotation;
            this.zRotation = zRotation;
            this.scale = scale;
        }

        public DisplayInfo(float scale) {
            this(0.0f, 0.0f, 0.0f, scale);
        }

        public DisplayInfo(float xOffset, float yOffset, float zOffset, float scale) {
            this(xOffset, yOffset, zOffset, 0.0f, 0.0f, 0.0f, scale);
        }

        public void toNetwork(PacketBuffer buffer) {
            buffer.writeFloat(this.xOffset);
            buffer.writeFloat(this.yOffset);
            buffer.writeFloat(this.zOffset);
            buffer.writeFloat(this.xRotation);
            buffer.writeFloat(this.yRotation);
            buffer.writeFloat(this.zRotation);
            buffer.writeFloat(this.scale);
        }

        public static DisplayInfo fromNetwork(PacketBuffer buffer) {
            return new DisplayInfo(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }

        public JsonObject toJson() {
            JsonObject result = new JsonObject();
            if (this.xOffset() != 0.0f || this.yOffset() != 0.0f || this.zOffset() != 0.0f) {
                result.add("offset", (JsonElement)DisplayInfo.serializeVector(this.xOffset(), this.yOffset(), this.zOffset()));
            }
            if (this.xRotation() != 0.0f || this.yRotation() != 0.0f || this.zRotation() != 0.0f) {
                result.add("rotation", (JsonElement)DisplayInfo.serializeVector(this.xRotation(), this.yRotation(), this.zRotation()));
            }
            if (this.scale() != 0.0f) {
                result.addProperty("scale", (Number)Float.valueOf(this.scale()));
            }
            return result;
        }

        private static JsonObject serializeVector(float x, float y, float z) {
            JsonObject result = new JsonObject();
            if (x != 0.0f) {
                result.addProperty("x", (Number)Float.valueOf(x));
            }
            if (y != 0.0f) {
                result.addProperty("y", (Number)Float.valueOf(y));
            }
            if (z != 0.0f) {
                result.addProperty("z", (Number)Float.valueOf(z));
            }
            return result;
        }

        private static DisplayInfo fromJson(JsonObject object) {
            float zOffset = 0.0f;
            float yOffset = 0.0f;
            float xOffset = 0.0f;
            if (object.has("offset")) {
                JsonObject offset = JSONUtils.func_152754_s((JsonObject)object, (String)"offset");
                xOffset = Trophy.readOptionalFloat(offset, "x", 0);
                yOffset = Trophy.readOptionalFloat(offset, "y", 0);
                zOffset = Trophy.readOptionalFloat(offset, "z", 0);
            }
            float zRotation = 0.0f;
            float yRotation = 0.0f;
            float xRotation = 0.0f;
            if (object.has("rotation")) {
                JsonObject rotation = JSONUtils.func_152754_s((JsonObject)object, (String)"rotation");
                xRotation = Trophy.readOptionalFloat(rotation, "x", 0);
                yRotation = Trophy.readOptionalFloat(rotation, "y", 0);
                zRotation = Trophy.readOptionalFloat(rotation, "z", 0);
            }
            float scale = Trophy.readOptionalFloat(object, "scale", 1);
            return new DisplayInfo(xOffset, yOffset, zOffset, xRotation, yRotation, zRotation, scale);
        }

        public float xOffset() {
            return this.xOffset;
        }

        public float yOffset() {
            return this.yOffset;
        }

        public float zOffset() {
            return this.zOffset;
        }

        public float xRotation() {
            return this.xRotation;
        }

        public float yRotation() {
            return this.yRotation;
        }

        public float zRotation() {
            return this.zRotation;
        }

        public float scale() {
            return this.scale;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            DisplayInfo displayInfo = (DisplayInfo)obj;
            return Float.floatToIntBits(this.xOffset) == Float.floatToIntBits(displayInfo.xOffset) && Float.floatToIntBits(this.yOffset) == Float.floatToIntBits(displayInfo.yOffset) && Float.floatToIntBits(this.zOffset) == Float.floatToIntBits(displayInfo.zOffset) && Float.floatToIntBits(this.xRotation) == Float.floatToIntBits(displayInfo.xRotation) && Float.floatToIntBits(this.yRotation) == Float.floatToIntBits(displayInfo.yRotation) && Float.floatToIntBits(this.zRotation) == Float.floatToIntBits(displayInfo.zRotation) && Float.floatToIntBits(this.scale) == Float.floatToIntBits(displayInfo.scale);
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.xOffset), Float.valueOf(this.yOffset), Float.valueOf(this.zOffset), Float.valueOf(this.xRotation), Float.valueOf(this.yRotation), Float.valueOf(this.zRotation), Float.valueOf(this.scale));
        }

        public String toString() {
            return "DisplayInfo[xOffset=" + this.xOffset + ", yOffset=" + this.yOffset + ", zOffset=" + this.zOffset + ", xRotation=" + this.xRotation + ", yRotation=" + this.yRotation + ", zRotation=" + this.zRotation + ", scale=" + this.scale + ']';
        }
    }

    public static final class Animation {
        public static final Animation STATIC = new Animation(Type.FIXED, 1.0f);
        private final Type type;
        private final float speed;

        public Animation(Type type, float speed) {
            this.type = type;
            this.speed = speed;
        }

        public void toNetwork(PacketBuffer buffer) {
            buffer.writeByte(this.type.ordinal());
            buffer.writeFloat(this.speed);
        }

        public static Animation fromNetwork(PacketBuffer buffer) {
            Type type = Type.values()[buffer.readByte()];
            float speed = buffer.readFloat();
            if (type == Type.FIXED) {
                return STATIC;
            }
            return new Animation(type, speed);
        }

        public JsonObject toJson() {
            JsonObject result = new JsonObject();
            result.addProperty("type", this.type().name());
            if (this.speed() != 1.0f) {
                result.addProperty("speed", (Number)Float.valueOf(this.speed()));
            }
            return result;
        }

        private static Animation fromJson(JsonObject object) {
            Type type = Type.fromJson(object.get("type"));
            float speed = Trophy.readOptionalFloat(object, "speed", 1);
            return new Animation(type, speed);
        }

        public Type type() {
            return this.type;
        }

        public float speed() {
            return this.speed;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Animation animation = (Animation)obj;
            return Objects.equals((Object)this.type, (Object)animation.type) && Float.floatToIntBits(this.speed) == Float.floatToIntBits(animation.speed);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, Float.valueOf(this.speed)});
        }

        public String toString() {
            return "Animation[type=" + (Object)((Object)this.type) + ", speed=" + this.speed + ']';
        }

        public static enum Type {
            FIXED("fixed"),
            SPINNING("spinning"),
            TUMBLING("tumbling");

            private final String name;

            private Type(String name) {
                this.name = name;
            }

            public static Type fromJson(JsonElement element) {
                String name = JSONUtils.func_151206_a((JsonElement)element, (String)"animation");
                for (Type animation : Type.values()) {
                    if (!animation.name.equals(name)) continue;
                    return animation;
                }
                throw new JsonParseException(String.format("Invalid trophy animation type: %s", name));
            }
        }
    }
}

