/*
 * Decompiled with CFR 0.152.
 */
package trofers.common.trophy.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import trofers.common.trophy.block.TrophyBlock;

public class PillarTrophyBlock
extends TrophyBlock {
    private final VoxelShape shape;

    public PillarTrophyBlock(AbstractBlock.Properties properties, int size) {
        super(properties, size);
        this.shape = this.createShape(size);
    }

    @Override
    public int getHeight() {
        return this.getSize();
    }

    private VoxelShape createShape(int size) {
        int width = 2 * (size - 2);
        return VoxelShapes.func_216384_a((VoxelShape)PillarTrophyBlock.centeredBox(width, 0, 2), (VoxelShape[])new VoxelShape[]{PillarTrophyBlock.centeredBox(width - 2, 2, size - 2), PillarTrophyBlock.centeredBox(width, size - 2, size)});
    }

    private static VoxelShape centeredBox(int width, int minY, int maxY) {
        return Block.func_208617_a((double)(8.0 - (double)width / 2.0), (double)minY, (double)(8.0 - (double)width / 2.0), (double)(8.0 + (double)width / 2.0), (double)maxY, (double)(8.0 + (double)width / 2.0));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader level, BlockPos pos, ISelectionContext context) {
        return this.shape;
    }
}

