/*
 * Decompiled with CFR 0.152.
 */
package trofers.common.trophy.block;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import trofers.common.init.ModBlockEntityTypes;
import trofers.common.trophy.block.TrophyBlockEntity;
import trofers.common.trophy.block.TrophyScreen;

public abstract class TrophyBlock
extends Block {
    private final int size;

    public TrophyBlock(AbstractBlock.Properties properties, int size) {
        super(properties);
        this.size = size;
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH));
    }

    public abstract int getHeight();

    public int getSize() {
        return this.size;
    }

    public String func_149739_a() {
        return "block.trofers.trophy";
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208198_y});
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208157_J});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean isWaterlogged = context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(isWaterlogged));
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld level, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            level.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)level));
        }
        return super.func_196271_a(state, facing, facingState, level, pos, facingPos);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)ModBlockEntityTypes.TROPHY.get()).func_200968_a();
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TrophyBlockEntity blockEntity;
        ItemStack result = super.getPickBlock(state, target, world, pos, player);
        if (world.func_175625_s(pos) instanceof TrophyBlockEntity && (blockEntity = (TrophyBlockEntity)world.func_175625_s(pos)).getTrophyID() != null) {
            result.func_190925_c("BlockEntityTag").func_74778_a("Trophy", blockEntity.getTrophyID().toString());
        }
        return result;
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hitResult) {
        if (player.func_184812_l_()) {
            if (level.func_201670_d()) {
                TrophyScreen.open(state.func_177230_c().func_199767_j(), pos);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }
}

