/*
 * Decompiled with CFR 0.152.
 */
package trofers.common.trophy.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.math.AxisAlignedBB;
import trofers.Trofers;
import trofers.common.init.ModBlockEntityTypes;
import trofers.common.trophy.Trophy;
import trofers.common.trophy.TrophyManager;
import trofers.common.trophy.block.TrophyBlock;

public class TrophyBlockEntity
extends TileEntity {
    @Nullable
    private Trophy trophy;
    @Nullable
    private ResourceLocation trophyID;
    private float animationOffset;

    public TrophyBlockEntity() {
        super((TileEntityType)ModBlockEntityTypes.TROPHY.get());
    }

    @Nullable
    public Trophy getTrophy() {
        return this.trophy;
    }

    public void setTrophy(@Nullable Trophy trophy) {
        this.trophy = trophy;
        this.trophyID = trophy != null ? trophy.id() : null;
        this.onContentsChanged();
    }

    @Nullable
    public ResourceLocation getTrophyID() {
        return this.trophyID;
    }

    public float getAnimationOffset() {
        if (this.animationOffset == 0.0f && this.field_145850_b != null) {
            this.animationOffset = this.field_145850_b.func_201674_k().nextFloat() * 4000.0f;
        }
        return this.animationOffset;
    }

    public int getTrophyHeight() {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof TrophyBlock) {
            return ((TrophyBlock)block).getHeight();
        }
        return 0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v().func_177982_a(-1, 0, -1), this.func_174877_v().func_177982_a(1, 16, 1));
    }

    private void onContentsChanged() {
        if (this.field_145850_b != null) {
            if (!this.field_145850_b.func_201670_d()) {
                this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
                this.func_70296_d();
            } else {
                this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 8);
            }
        }
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager connection, SUpdateTileEntityPacket packet) {
        if (this.field_145850_b != null) {
            this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.loadTrophy(tag);
    }

    public void loadTrophy(CompoundNBT tag) {
        this.trophy = null;
        this.trophyID = null;
        if (tag.func_150297_b("Trophy", 8)) {
            try {
                this.trophyID = new ResourceLocation(tag.func_74779_i("Trophy"));
            }
            catch (ResourceLocationException exception) {
                Trofers.LOGGER.error(String.format("Failed to load trophy for block entity at %s", this.func_174877_v()), (Throwable)exception);
            }
            this.trophy = TrophyManager.get(this.trophyID);
            if (this.trophy == null) {
                Trofers.LOGGER.error(String.format("Invalid trophy id for block entity at %s: %s", this.func_174877_v(), this.trophyID));
            }
        }
        if (this.func_145831_w() != null && this.func_145831_w().func_201670_d()) {
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 8);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        this.saveTrophy(tag);
        return super.func_189515_b(tag);
    }

    public void saveTrophy(CompoundNBT tag) {
        if (this.trophyID != null) {
            tag.func_74778_a("Trophy", this.trophyID.toString());
        }
    }
}

