/*
 * Decompiled with CFR 0.152.
 */
package trofers.common.trophy.block;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import trofers.common.trophy.Trophy;
import trofers.common.trophy.block.TrophyBlockEntity;

public class TrophyBlockEntityRenderer
extends TileEntityRenderer<TrophyBlockEntity> {
    public TrophyBlockEntityRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public boolean shouldRenderOffScreen(TrophyBlockEntity blockEntity) {
        return true;
    }

    public void render(TrophyBlockEntity blockEntity, float partialTicks, MatrixStack poseStack, IRenderTypeBuffer multiBufferSource, int light, int overlay) {
        poseStack.func_227860_a_();
        poseStack.func_227861_a_(0.5, 0.0, 0.5);
        Direction direction = ((Direction)blockEntity.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176734_d();
        poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-direction.func_185119_l()));
        Trophy trophy = blockEntity.getTrophy();
        if (trophy != null && Minecraft.func_71410_x().field_71439_g != null) {
            float ticks = (float)Minecraft.func_71410_x().field_71439_g.field_70173_aa + partialTicks + blockEntity.getAnimationOffset();
            TrophyBlockEntityRenderer.render(trophy, ticks, blockEntity.getTrophyHeight(), poseStack, multiBufferSource, light, overlay);
        }
        poseStack.func_227865_b_();
    }

    public static void render(Trophy trophy, float ticks, int trophyHeight, MatrixStack poseStack, IRenderTypeBuffer multiBufferSource, int light, int overlay) {
        TrophyBlockEntityRenderer.renderItem(trophy, ticks, trophyHeight, poseStack, multiBufferSource, light, overlay);
        TrophyBlockEntityRenderer.renderEntity(trophy, ticks, trophyHeight, poseStack, multiBufferSource, light);
    }

    private static void renderItem(Trophy trophy, float ticks, int trophyHeight, MatrixStack poseStack, IRenderTypeBuffer multiBufferSource, int light, int overlay) {
        poseStack.func_227860_a_();
        ItemRenderer renderer = Minecraft.func_71410_x().func_175599_af();
        IBakedModel model = renderer.func_184393_a(trophy.item(), (World)Minecraft.func_71410_x().field_71441_e, null);
        float yOffset = 0.25f;
        TrophyBlockEntityRenderer.translateRotate(poseStack, trophy, trophyHeight, yOffset, ticks);
        poseStack.func_227861_a_(0.0, 0.25, 0.0);
        if (!model.func_177556_c()) {
            poseStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        }
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(trophy.item(), ItemCameraTransforms.TransformType.FIXED, light, overlay, poseStack, multiBufferSource);
        poseStack.func_227865_b_();
    }

    private static void renderEntity(Trophy trophy, float ticks, int trophyHeight, MatrixStack poseStack, IRenderTypeBuffer multiBufferSource, int light) {
        if (Minecraft.func_71410_x().field_71441_e == null || trophy.entity() == null) {
            return;
        }
        Entity entity = trophy.entity().getOrCreateEntity((World)Minecraft.func_71410_x().field_71441_e);
        if (entity == null) {
            return;
        }
        poseStack.func_227860_a_();
        float entityHeight = entity.func_213302_cg();
        TrophyBlockEntityRenderer.translateRotate(poseStack, trophy, trophyHeight, entityHeight / 2.0f, ticks);
        if (!trophy.entity().isAnimated()) {
            ticks = 0.0f;
        }
        poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        Minecraft.func_71410_x().func_175598_ae().func_229084_a_(entity, 0.0, 0.0, 0.0, 0.0f, ticks, poseStack, multiBufferSource, light);
        poseStack.func_227865_b_();
    }

    private static void translateRotate(MatrixStack poseStack, Trophy trophy, int trophyHeight, float yRotationOffset, float ticks) {
        float animationProgress = 6.0f * ticks * trophy.animation().speed();
        poseStack.func_227861_a_(0.0, (double)((float)trophyHeight + trophy.display().yOffset()) / 16.0, 0.0);
        poseStack.func_227861_a_(0.0, (double)(yRotationOffset *= trophy.display().scale()), 0.0);
        if (trophy.animation().type() == Trophy.Animation.Type.SPINNING) {
            poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(animationProgress));
        } else if (trophy.animation().type() == Trophy.Animation.Type.TUMBLING) {
            poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(animationProgress));
            poseStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(animationProgress * 0.8f));
            poseStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(animationProgress * 0.6f));
        }
        poseStack.func_227861_a_(0.0, (double)(-yRotationOffset), 0.0);
        poseStack.func_227861_a_((double)trophy.display().xOffset() / 16.0, 0.0, 0.0);
        poseStack.func_227861_a_(0.0, 0.0, (double)trophy.display().zOffset() / 16.0);
        poseStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(trophy.display().xRotation()));
        poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(trophy.display().yRotation()));
        poseStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(trophy.display().zRotation()));
        float scale = trophy.display().scale();
        poseStack.func_227862_a_(scale, scale, scale);
    }
}

