/*
 * Decompiled with CFR 0.152.
 */
package trofers.common.trophy.block;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.util.InputMappings;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;
import trofers.common.network.NetworkHandler;
import trofers.common.network.SetTrophyPacket;
import trofers.common.trophy.Trophy;
import trofers.common.trophy.TrophyManager;
import trofers.common.trophy.block.TrophyBlockEntity;

public class TrophyScreen
extends Screen {
    private static final int HORIZONTAL_PADDING = 80;
    private static final int VERTICAL_PADDING = 20;
    private static final int BUTTON_SIZE = 40;
    private static final int BUTTON_SPACING = 8;
    private static final int CANCEL_BUTTON_WIDTH = 96;
    private static final int UPPER_BUTTON_SIZE = 20;
    private static final int MIN_ROWS = 2;
    private static final int MIN_COLUMNS = 2;
    private static final int MAX_COLUMNS = 16;
    private static final float ITEM_SCALE = 2.0f;
    private Button previousButton;
    private Button nextButton;
    private final Set<Button> trophyButtons = new HashSet<Button>();
    private int currentPage;
    private int rows;
    private int columns;
    private int rowStart;
    private int columnStart;
    private final Item trophyItem;
    private final BlockPos blockPos;

    public TrophyScreen(Item trophyItem, BlockPos blockPos) {
        super(StringTextComponent.field_240750_d_);
        this.trophyItem = trophyItem;
        this.blockPos = blockPos;
    }

    public static void open(Item item, BlockPos pos) {
        Minecraft.func_71410_x().func_147108_a((Screen)new TrophyScreen(item, pos));
    }

    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(poseStack);
        super.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        InputMappings.Input mouseKey = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (super.func_231046_a_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.field_230706_i_ != null && this.field_230706_i_.field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey)) {
            this.func_231175_as__();
            return true;
        }
        return false;
    }

    protected void func_231160_c_() {
        int previousRows = this.rows;
        int previousColumns = this.columns;
        this.columns = (this.field_230708_k_ - 160 - 40) / 48 + 1;
        this.columns = Math.max(this.columns, 2);
        this.columns = Math.min(this.columns, 16);
        this.columnStart = this.field_230708_k_ / 2 - (40 * this.columns + 8 * (this.columns - 1)) / 2;
        this.rowStart = 56;
        this.rows = (this.field_230709_l_ - this.rowStart - 20 - 40) / 48 + 1;
        this.rows = Math.max(this.rows, 2);
        this.createUpperButtons();
        if (this.columns == previousColumns && this.rows == previousRows) {
            this.setCurrentPage(this.currentPage);
        } else {
            this.setCurrentPage(0);
        }
    }

    private void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
        this.trophyButtons.forEach(button -> {
            this.field_230710_m_.remove(button);
            this.field_230705_e_.remove(button);
        });
        List trophies = TrophyManager.values().stream().filter(trophy -> !trophy.isHidden()).sorted(Comparator.comparing(trophy -> trophy.id().toString())).collect(Collectors.toCollection(ArrayList::new));
        int index = currentPage * this.columns * this.rows;
        for (int row = 0; row < this.rows; ++row) {
            for (int column = 0; column < this.columns && index < trophies.size(); ++column) {
                ItemStack stack = new ItemStack((IItemProvider)this.trophyItem);
                Trophy trophy2 = (Trophy)trophies.get(index++);
                stack.func_190925_c("BlockEntityTag").func_74778_a("Trophy", trophy2.id().toString());
                int x = this.columnStart + column * 48;
                int y = this.rowStart + row * 48;
                this.trophyButtons.add((Button)this.func_230480_a_((Widget)new ItemButton(x, y, 40, stack, button -> this.setTrophy(trophy2))));
            }
        }
        this.nextButton.field_230693_o_ = false;
        this.previousButton.field_230693_o_ = false;
        if (index < trophies.size() - 1) {
            this.nextButton.field_230693_o_ = true;
        }
        if (currentPage > 0) {
            this.previousButton.field_230693_o_ = true;
        }
    }

    private void createUpperButtons() {
        this.func_230480_a_((Widget)new ExtendedButton(this.field_230708_k_ / 2 - 48, 20, 96, 20, (ITextComponent)new TranslationTextComponent(String.format("button.%s.cancel", "trofers")), button -> this.func_231175_as__()));
        this.previousButton = (Button)this.func_230480_a_((Widget)new ExtendedButton(this.field_230708_k_ / 2 - 48 - 8 - 20, 20, 20, 20, (ITextComponent)new StringTextComponent("<"), button -> this.setCurrentPage(this.currentPage - 1)));
        this.nextButton = (Button)this.func_230480_a_((Widget)new ExtendedButton(this.field_230708_k_ / 2 + 48 + 8, 20, 20, 20, (ITextComponent)new StringTextComponent(">"), button -> this.setCurrentPage(this.currentPage + 1)));
    }

    public boolean func_231177_au__() {
        return false;
    }

    private void setTrophy(Trophy trophy) {
        NetworkHandler.INSTANCE.sendToServer((Object)new SetTrophyPacket(trophy, this.blockPos));
        if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.field_70170_p.func_175625_s(this.blockPos) instanceof TrophyBlockEntity) {
            ((TrophyBlockEntity)Minecraft.func_71410_x().field_71439_g.field_70170_p.func_175625_s(this.blockPos)).setTrophy(trophy);
        }
        this.func_231175_as__();
    }

    private class ItemButton
    extends ExtendedButton {
        private final ItemStack item;

        public ItemButton(int xPos, int yPos, int size, ItemStack item, Button.IPressable handler) {
            super(xPos, yPos, size, size, StringTextComponent.field_240750_d_, handler);
            this.item = item;
        }

        public void func_230431_b_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
            super.func_230431_b_(poseStack, mouseX, mouseY, partialTicks);
            this.renderScaledGuiItem(this.item, this.field_230690_l_ + (int)((float)this.field_230688_j_ - 32.0f) / 2, this.field_230691_m_ + (int)((float)this.field_230689_k_ - 32.0f) / 2, 2.0f);
            if (this.func_230449_g_()) {
                this.func_230443_a_(poseStack, mouseX, mouseY);
            }
        }

        public void func_230443_a_(MatrixStack poseStack, int mouseX, int mouseY) {
            TrophyScreen.this.func_230457_a_(poseStack, this.item, mouseX, mouseY);
        }

        private void renderScaledGuiItem(ItemStack item, int x, int y, float scale) {
            if (!item.func_190926_b()) {
                IBakedModel bakedmodel = TrophyScreen.this.field_230707_j_.func_184393_a(item, null, (LivingEntity)Minecraft.func_71410_x().field_71439_g);
                ((TrophyScreen)TrophyScreen.this).field_230707_j_.field_77023_b += 50.0f;
                try {
                    this.renderGuiItem(item, x, y, scale, bakedmodel);
                }
                catch (Exception exception) {
                    CrashReport crashReport = CrashReport.func_85055_a((Throwable)exception, (String)"Rendering item");
                    CrashReportCategory category = crashReport.func_85058_a("Item being rendered");
                    category.func_189529_a("Item Type", () -> String.valueOf(item.func_77973_b()));
                    category.func_189529_a("Registry Name", () -> String.valueOf(item.func_77973_b().getRegistryName()));
                    category.func_189529_a("Item Damage", () -> String.valueOf(item.func_77952_i()));
                    category.func_189529_a("Item NBT", () -> String.valueOf(item.func_77978_p()));
                    category.func_189529_a("Item Foil", () -> String.valueOf(item.func_77962_s()));
                    throw new ReportedException(crashReport);
                }
                ((TrophyScreen)TrophyScreen.this).field_230707_j_.field_77023_b -= 50.0f;
            }
        }

        protected void renderGuiItem(ItemStack item, int x, int y, float scale, IBakedModel model) {
            boolean flag;
            RenderSystem.pushMatrix();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
            Minecraft.func_71410_x().field_71446_o.func_229267_b_(AtlasTexture.field_110575_b).func_174937_a(false, false);
            RenderSystem.enableRescaleNormal();
            RenderSystem.enableAlphaTest();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.translatef((float)x, (float)y, (float)(100.0f + ((TrophyScreen)TrophyScreen.this).field_230707_j_.field_77023_b));
            RenderSystem.translatef((float)(16.0f * scale / 2.0f), (float)(16.0f * scale / 2.0f), (float)0.0f);
            RenderSystem.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
            RenderSystem.scalef((float)scale, (float)scale, (float)scale);
            RenderSystem.scalef((float)16.0f, (float)16.0f, (float)16.0f);
            MatrixStack matrixstack = new MatrixStack();
            IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            boolean bl = flag = !model.func_230044_c_();
            if (flag) {
                RenderHelper.func_227783_c_();
            }
            TrophyScreen.this.field_230707_j_.func_229111_a_(item, ItemCameraTransforms.TransformType.GUI, false, matrixstack, (IRenderTypeBuffer)buffer, 0xF000F0, OverlayTexture.field_229196_a_, model);
            buffer.func_228461_a_();
            RenderSystem.enableDepthTest();
            if (flag) {
                RenderHelper.func_227784_d_();
            }
            RenderSystem.disableAlphaTest();
            RenderSystem.disableRescaleNormal();
            RenderSystem.popMatrix();
        }
    }
}

