/*
 * Decompiled with CFR 0.152.
 */
package trofers.data;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.KilledByPlayer;
import net.minecraft.loot.functions.CopyNbt;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import trofers.common.init.ModBlocks;
import trofers.common.init.ModItems;
import trofers.common.loot.RandomTrophyChanceCondition;
import trofers.common.trophy.block.TrophyBlock;
import trofers.data.Trophies;

public class LootTables
extends LootTableProvider {
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> lootTables = new ArrayList<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>>();
    private final Trophies trophies;

    public LootTables(DataGenerator generator, Trophies trophies) {
        super(generator);
        this.trophies = trophies;
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        this.lootTables.clear();
        this.addBlockLootTables();
        this.addEntityLootTables();
        return this.lootTables;
    }

    private void addBlockLootTables() {
        CopyNbt.Builder copyNbtBuilder = CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY).func_216056_a("Trophy", "BlockEntityTag.Trophy");
        for (RegistryObject<TrophyBlock> trophy : ModBlocks.TROPHIES) {
            ResourceLocation location = new ResourceLocation("trofers", "blocks/" + trophy.getId().func_110623_a());
            LootTable.Builder lootTable = LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)trophy.get())).func_212841_b_((ILootFunction.IBuilder)copyNbtBuilder)));
            this.lootTables.add((Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>)Pair.of(() -> builder -> builder.accept(location, lootTable), (Object)LootParameterSets.field_216267_h));
        }
    }

    private void addEntityLootTables() {
        this.trophies.trophies.forEach((id, trophy) -> {
            String entityName = trophy.entity().getType().getRegistryName().func_110623_a();
            ResourceLocation location = new ResourceLocation("trofers", "inject/entities/" + entityName);
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_218657_a("BlockEntityTag", (INBT)new CompoundNBT());
            nbt.func_74775_l("BlockEntityTag").func_74778_a("Trophy", String.format("%s:%s", "trofers", entityName));
            LootTable.Builder lootTable = LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_212840_b_(RandomTrophyChanceCondition.randomTrophyChance()).func_212840_b_(KilledByPlayer.func_215994_b()).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.SMALL_PLATE.get()))).func_212841_b_((ILootFunction.IBuilder)SetNBT.func_215952_a((CompoundNBT)nbt)));
            this.lootTables.add((Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>)Pair.of(() -> builder -> builder.accept(location, lootTable), (Object)LootParameterSets.field_216263_d));
        });
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationTracker) {
        map.forEach((location, lootTable) -> LootTableManager.func_227508_a_((ValidationTracker)validationTracker, (ResourceLocation)location, (LootTable)lootTable));
    }
}

