/*
 * Decompiled with CFR 0.152.
 */
package trofers.data;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TranslationTextComponent;
import trofers.Trofers;
import trofers.common.trophy.Trophy;

public class Trophies
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final Map<ResourceLocation, Trophy> trophies = new HashMap<ResourceLocation, Trophy>();
    private final DataGenerator generator;

    protected Trophies(DataGenerator dataGenerator) {
        this.generator = dataGenerator;
    }

    protected void addTrophies() {
        this.trophies.clear();
        HashMap<EntityType, Integer> entityColors = new HashMap<EntityType, Integer>();
        HashMap<EntityType, Trophy.DisplayInfo> displayInfos = new HashMap<EntityType, Trophy.DisplayInfo>();
        HashMap entityData = new HashMap();
        entityColors.put(EntityType.field_200791_e, 7693631);
        entityColors.put(EntityType.field_226289_e_, 15451458);
        entityColors.put(EntityType.field_200792_f, 15591238);
        entityColors.put(EntityType.field_220360_g, 9662805);
        entityColors.put(EntityType.field_200794_h, 1342314);
        entityColors.put(EntityType.field_200795_i, 0xFFFFFF);
        entityColors.put(EntityType.field_203780_j, 11966572);
        entityColors.put(EntityType.field_200796_j, 7098932);
        entityColors.put(EntityType.field_200797_k, 4764218);
        entityColors.put(EntityType.field_205137_n, 11584728);
        entityColors.put(EntityType.field_200798_l, 8483172);
        entityColors.put(EntityType.field_204724_o, 5670014);
        entityColors.put(EntityType.field_200800_n, 0xBFBBAA);
        entityColors.put(EntityType.field_200803_q, 10571702);
        entityColors.put(EntityType.field_200804_r, 6572932);
        entityColors.put(EntityType.field_200806_t, 0x959C9C);
        entityColors.put(EntityType.field_220356_B, 14908449);
        entityColors.put(EntityType.field_200811_y, 0xF0F0F0);
        entityColors.put(EntityType.field_200761_A, 6983815);
        entityColors.put(EntityType.field_233588_G_, 13997435);
        entityColors.put(EntityType.field_200762_B, 9594419);
        entityColors.put(EntityType.field_200763_C, 13085551);
        entityColors.put(EntityType.field_200757_aw, 13480599);
        entityColors.put(EntityType.field_200769_I, 14935252);
        entityColors.put(EntityType.field_200771_K, 16729600);
        entityColors.put(EntityType.field_200780_T, 10752018);
        entityColors.put(EntityType.field_200779_S, 8997164);
        entityColors.put(EntityType.field_200781_U, 15577698);
        entityColors.put(EntityType.field_220353_aa, 0xE4E4E4);
        entityColors.put(EntityType.field_200783_W, 0xE60000);
        entityColors.put(EntityType.field_203097_aH, 5333413);
        entityColors.put(EntityType.field_200784_X, 15836068);
        entityColors.put(EntityType.field_233591_ai_, 15710599);
        entityColors.put(EntityType.field_242287_aj, 15710599);
        entityColors.put(EntityType.field_220350_aJ, 0x929C9C);
        entityColors.put(EntityType.field_200786_Z, 0xF2F2F4);
        entityColors.put(EntityType.field_203779_Z, 14915339);
        entityColors.put(EntityType.field_200736_ab, 10652530);
        entityColors.put(EntityType.field_220352_aU, 9546923);
        entityColors.put(EntityType.field_203778_ae, 11024181);
        entityColors.put(EntityType.field_200737_ac, 0xFFFFFF);
        entityColors.put(EntityType.field_200738_ad, 9988759);
        entityColors.put(EntityType.field_200740_af, 7834777);
        entityColors.put(EntityType.field_200741_ag, 0xBDBDBD);
        entityColors.put(EntityType.field_200742_ah, 0xD0D0D2);
        entityColors.put(EntityType.field_200743_ai, 7848548);
        entityColors.put(EntityType.field_200745_ak, 0xFFFFFF);
        entityColors.put(EntityType.field_200748_an, 8021845);
        entityColors.put(EntityType.field_200749_ao, 5533056);
        entityColors.put(EntityType.field_200750_ap, 6321526);
        entityColors.put(EntityType.field_233589_aE_, 0xB44040);
        entityColors.put(EntityType.field_220354_ax, 4349840);
        entityColors.put(EntityType.field_204262_at, 0xFF4040);
        entityColors.put(EntityType.field_203099_aq, 4104768);
        entityColors.put(EntityType.field_200755_au, 9019574);
        entityColors.put(EntityType.field_200756_av, 12552301);
        entityColors.put(EntityType.field_200758_ax, 0x929C9C);
        entityColors.put(EntityType.field_220351_aK, 4349840);
        entityColors.put(EntityType.field_200759_ay, 10720386);
        entityColors.put(EntityType.field_200722_aA, 0x626565);
        entityColors.put(EntityType.field_200724_aC, 14473947);
        entityColors.put(EntityType.field_233590_aW_, 15046550);
        entityColors.put(EntityType.field_200725_aD, 7378268);
        entityColors.put(EntityType.field_200727_aF, 7774277);
        entityColors.put(EntityType.field_233592_ba_, 15046550);
        entityColors.keySet().forEach(type -> {
            displayInfos.put((EntityType)type, new Trophy.DisplayInfo(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f));
            entityData.put(type, new CompoundNBT());
        });
        displayInfos.put(EntityType.field_200811_y, new Trophy.DisplayInfo(0.0f, 5.0f, 0.0f, 0.075f));
        displayInfos.put(EntityType.field_200749_ao, new Trophy.DisplayInfo(0.0f, 5.0f, 0.0f, 0.25f));
        displayInfos.put(EntityType.field_203097_aH, new Trophy.DisplayInfo(0.0f, 1.0f, 0.0f, 0.25f));
        displayInfos.put(EntityType.field_200800_n, new Trophy.DisplayInfo(0.10625f));
        displayInfos.put(EntityType.field_220352_aU, new Trophy.DisplayInfo(0.175f));
        displayInfos.put(EntityType.field_220356_B, new Trophy.DisplayInfo(0.75f, 0.0f, 0.5f, 0.0f, -90.0f, 0.0f, 0.25f));
        displayInfos.put(EntityType.field_203780_j, new Trophy.DisplayInfo(-0.375f, 1.0f, 0.0f, 0.0f, 0.0f, -90.0f, 0.25f));
        displayInfos.put(EntityType.field_203778_ae, new Trophy.DisplayInfo(-0.375f, 1.0f, 0.0f, 0.0f, 0.0f, -90.0f, 0.25f));
        displayInfos.put(EntityType.field_204262_at, new Trophy.DisplayInfo(-0.375f, 1.0f, 0.0f, 0.0f, 0.0f, -90.0f, 0.25f));
        ((CompoundNBT)entityData.get(EntityType.field_220360_g)).func_74768_a("CatType", 0);
        ((CompoundNBT)entityData.get(EntityType.field_220360_g)).func_74757_a("Sitting", true);
        ((CompoundNBT)entityData.get(EntityType.field_200803_q)).func_218657_a("carriedBlockState", (INBT)new CompoundNBT());
        ((CompoundNBT)entityData.get(EntityType.field_200803_q)).func_74775_l("carriedBlockState").func_74778_a("Name", "minecraft:tnt");
        ((CompoundNBT)entityData.get(EntityType.field_220356_B)).func_74778_a("Type", "red");
        ((CompoundNBT)entityData.get(EntityType.field_220356_B)).func_74757_a("Sleeping", true);
        ((CompoundNBT)entityData.get(EntityType.field_233588_G_)).func_74757_a("IsImmuneToZombification", true);
        ((CompoundNBT)entityData.get(EntityType.field_200762_B)).func_74768_a("Variant", 257);
        ((CompoundNBT)entityData.get(EntityType.field_200769_I)).func_74768_a("Variant", 3);
        ((CompoundNBT)entityData.get(EntityType.field_200771_K)).func_74768_a("Size", 1);
        ((CompoundNBT)entityData.get(EntityType.field_220353_aa)).func_74778_a("MainGene", "playful");
        ((CompoundNBT)entityData.get(EntityType.field_200783_W)).func_74768_a("Variant", 0);
        ((CompoundNBT)entityData.get(EntityType.field_233591_ai_)).func_74757_a("IsImmuneToZombification", true);
        this.putHandItem((CompoundNBT)entityData.get(EntityType.field_242287_aj), Items.field_151006_E);
        this.putHandItem((CompoundNBT)entityData.get(EntityType.field_220350_aJ), Items.field_222114_py);
        ((CompoundNBT)entityData.get(EntityType.field_203779_Z)).func_74768_a("PuffState", 2);
        ((CompoundNBT)entityData.get(EntityType.field_200736_ab)).func_74768_a("RabbitType", 0);
        ((CompoundNBT)entityData.get(EntityType.field_200738_ad)).func_74774_a("Color", (byte)16);
        this.putHandItem((CompoundNBT)entityData.get(EntityType.field_200741_ag), Items.field_151031_f);
        ((CompoundNBT)entityData.get(EntityType.field_200743_ai)).func_74768_a("Size", 1);
        this.putHandItem((CompoundNBT)entityData.get(EntityType.field_200750_ap), Items.field_151031_f);
        ((CompoundNBT)entityData.get(EntityType.field_220354_ax)).func_74768_a("Variant", 2);
        ((CompoundNBT)entityData.get(EntityType.field_204262_at)).func_74768_a("Variant", 0xE0E0101);
        ((CompoundNBT)entityData.get(EntityType.field_200756_av)).func_218657_a("VillagerData", (INBT)new CompoundNBT());
        ((CompoundNBT)entityData.get(EntityType.field_200756_av)).func_74775_l("VillagerData").func_74768_a("level", 1);
        ((CompoundNBT)entityData.get(EntityType.field_200756_av)).func_74775_l("VillagerData").func_74778_a("profession", "minecraft:weaponsmith");
        ((CompoundNBT)entityData.get(EntityType.field_200756_av)).func_74775_l("VillagerData").func_74778_a("type", "minecraft:plains");
        ((CompoundNBT)entityData.get(EntityType.field_200724_aC)).func_74757_a("Sitting", true);
        ((CompoundNBT)entityData.get(EntityType.field_200724_aC)).func_186854_a("Owner", Util.field_240973_b_);
        this.putHandItem((CompoundNBT)entityData.get(EntityType.field_200722_aA), Items.field_151052_q);
        ((CompoundNBT)entityData.get(EntityType.field_200727_aF)).func_218657_a("VillagerData", (INBT)new CompoundNBT());
        ((CompoundNBT)entityData.get(EntityType.field_200727_aF)).func_74775_l("VillagerData").func_74768_a("level", 1);
        ((CompoundNBT)entityData.get(EntityType.field_200727_aF)).func_74775_l("VillagerData").func_74778_a("profession", "minecraft:weaponsmith");
        ((CompoundNBT)entityData.get(EntityType.field_200727_aF)).func_74775_l("VillagerData").func_74778_a("type", "minecraft:plains");
        this.putHandItem((CompoundNBT)entityData.get(EntityType.field_233592_ba_), Items.field_151010_B);
        entityColors.keySet().forEach(type -> this.addTrophy(new Trophy(new ResourceLocation("trofers", type.getRegistryName().func_110623_a()), this.createName((EntityType<?>)type, (Integer)entityColors.get(type)), (Trophy.DisplayInfo)displayInfos.get(type), Trophy.Animation.STATIC, ItemStack.field_190927_a, new Trophy.EntityInfo((EntityType<?>)type, (CompoundNBT)entityData.get(type), false), new Trophy.ColorInfo(0x606060, (Integer)entityColors.get(type)), false)));
    }

    private void putHandItem(CompoundNBT tag, Item item) {
        tag.func_218657_a("HandItems", (INBT)new ListNBT());
        tag.func_150295_c("HandItems", 10).add((Object)new ItemStack((IItemProvider)item).func_77955_b(new CompoundNBT()));
        tag.func_150295_c("HandItems", 10).add((Object)new CompoundNBT());
    }

    private ITextComponent createName(EntityType<?> entityType, int color) {
        return TextComponentUtils.func_240648_a_((IFormattableTextComponent)new TranslationTextComponent("trophy.trofers.composed", new Object[]{entityType.func_212546_e()}), (Style)Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)color)));
    }

    private void addTrophy(Trophy trophy) {
        this.trophies.put(trophy.id(), trophy);
    }

    public void func_200398_a(DirectoryCache cache) {
        this.addTrophies();
        Path outputFolder = this.generator.func_200391_b();
        HashSet set = Sets.newHashSet();
        Consumer<Trophy> consumer = trophy -> {
            if (!set.add(trophy.id())) {
                throw new IllegalStateException("Duplicate trophy " + trophy.id());
            }
            Path path = Trophies.createPath(outputFolder, trophy);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)trophy.toJson(), (Path)path);
            }
            catch (IOException ioexception) {
                Trofers.LOGGER.error("Couldn't save trophy {}", (Object)path, (Object)ioexception);
            }
        };
        this.trophies.forEach((resourceLocation, trophy) -> consumer.accept((Trophy)trophy));
    }

    private static Path createPath(Path path, Trophy trophy) {
        return path.resolve("data/" + trophy.id().func_110624_b() + "/trofers/" + trophy.id().func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "Trophies";
    }
}

