/*
 * Decompiled with CFR 0.152.
 */
package trofers;

import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmllegacy.RegistryObject;
import trofers.common.init.ModBlockEntityTypes;
import trofers.common.init.ModBlocks;
import trofers.common.init.ModItems;
import trofers.common.trophy.Trophy;
import trofers.common.trophy.block.TrophyBlockEntity;
import trofers.common.trophy.block.TrophyBlockEntityRenderer;

public class TrofersClient {
    public TrofersClient() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::onClientSetup);
        modEventBus.addListener(this::onBlockColorHandler);
        modEventBus.addListener(this::onItemColorHandler);
    }

    public void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntityTypes.TROPHY.get()), TrophyBlockEntityRenderer::new));
        ModBlocks.TROPHIES.forEach(trophy -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)trophy.get()), (RenderType)RenderType.m_110463_()));
    }

    public void onBlockColorHandler(ColorHandlerEvent.Block event) {
        event.getBlockColors().m_92589_((state, level, pos, index) -> {
            BlockEntity blockEntity;
            BlockEntity trophyBlockEntity$temp;
            if (index >= 0 && index < 3 && level != null && pos != null && (trophyBlockEntity$temp = (blockEntity = level.m_7702_(pos))) instanceof TrophyBlockEntity) {
                TrophyBlockEntity trophyBlockEntity = (TrophyBlockEntity)trophyBlockEntity$temp;
                Trophy trophy = trophyBlockEntity.getTrophy();
                if (trophy == null) {
                    return 0xFFFFFF;
                }
                if (index == 0) {
                    return trophy.colors().base();
                }
                if (index == 1) {
                    return trophy.colors().accent();
                }
            }
            return 0xFFFFFF;
        }, (Block[])ModBlocks.TROPHIES.stream().map(RegistryObject::get).toArray(Block[]::new));
    }

    public void onItemColorHandler(ColorHandlerEvent.Item event) {
        event.getItemColors().m_92689_((stack, index) -> {
            Trophy trophy = Trophy.getTrophy(stack);
            if (trophy != null) {
                if (index == 0) {
                    return trophy.colors().base();
                }
                if (index == 1) {
                    return trophy.colors().accent();
                }
            }
            return 0xFFFFFF;
        }, (ItemLike[])ModItems.TROPHIES.stream().map(RegistryObject::get).toArray(Item[]::new));
    }
}

