/*
 * Decompiled with CFR 0.152.
 */
package trofers.common.init;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import trofers.common.trophy.block.PillarTrophyBlock;
import trofers.common.trophy.block.PlateTrophyBlock;
import trofers.common.trophy.block.TrophyBlock;

public class ModBlocks {
    public static final DeferredRegister<Block> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"trofers");
    public static final Set<RegistryObject<TrophyBlock>> TROPHIES = new HashSet<RegistryObject<TrophyBlock>>();
    public static final RegistryObject<TrophyBlock> SMALL_PILLAR = ModBlocks.addPillar("small_pillar", 6);
    public static final RegistryObject<TrophyBlock> MEDIUM_PILLAR = ModBlocks.addPillar("medium_pillar", 7);
    public static final RegistryObject<TrophyBlock> LARGE_PILLAR = ModBlocks.addPillar("large_pillar", 8);
    public static final RegistryObject<TrophyBlock> SMALL_PLATE = ModBlocks.addPlate("small_plate", 6);
    public static final RegistryObject<TrophyBlock> MEDIUM_PLATE = ModBlocks.addPlate("medium_plate", 7);
    public static final RegistryObject<TrophyBlock> LARGE_PLATE = ModBlocks.addPlate("large_plate", 8);

    private static RegistryObject<TrophyBlock> addPillar(String name, int size) {
        return ModBlocks.addTrophy(name, () -> new PillarTrophyBlock(ModBlocks.createProperties(), size));
    }

    private static RegistryObject<TrophyBlock> addPlate(String name, int size) {
        return ModBlocks.addTrophy(name, () -> new PlateTrophyBlock(ModBlocks.createProperties(), size));
    }

    private static RegistryObject<TrophyBlock> addTrophy(String name, Supplier<TrophyBlock> block) {
        RegistryObject trophy = REGISTRY.register(name, block);
        TROPHIES.add((RegistryObject<TrophyBlock>)trophy);
        return trophy;
    }

    private static BlockBehaviour.Properties createProperties() {
        return BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f);
    }
}

