/*
 * Decompiled with CFR 0.152.
 */
package trofers.common.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import trofers.common.trophy.Trophy;
import trofers.common.trophy.TrophyManager;

public class TrophySyncPacket {
    private final Map<ResourceLocation, Trophy> trophies;

    public TrophySyncPacket(FriendlyByteBuf buffer) {
        this.trophies = new HashMap<ResourceLocation, Trophy>();
        while (buffer.readBoolean()) {
            Trophy trophy = Trophy.fromNetwork(buffer);
            this.trophies.put(trophy.id(), trophy);
        }
    }

    public TrophySyncPacket(Map<ResourceLocation, Trophy> trophies) {
        this.trophies = trophies;
    }

    void encode(FriendlyByteBuf buffer) {
        this.trophies.values().forEach(trophy -> {
            buffer.writeBoolean(true);
            trophy.toNetwork(buffer);
        });
        buffer.writeBoolean(false);
    }

    void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> TrophyManager.setTrophies(this.trophies));
        context.get().setPacketHandled(true);
    }
}

