/*
 * Decompiled with CFR 0.152.
 */
package trofers.common.trophy;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;
import trofers.common.trophy.TrophyManager;

public record Trophy(ResourceLocation id, @Nullable Component name, DisplayInfo display, Animation animation, ItemStack item, @Nullable EntityInfo entity, ColorInfo colors, boolean isHidden) {
    @Nullable
    public static Trophy getTrophy(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return null;
        }
        CompoundTag blockEntityTag = tag.m_128469_("BlockEntityTag");
        if (!blockEntityTag.m_128425_("Trophy", 8)) {
            return null;
        }
        try {
            return TrophyManager.get(new ResourceLocation(blockEntityTag.m_128461_("Trophy")));
        }
        catch (ResourceLocationException resourceLocationException) {
            return null;
        }
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.id);
        buffer.writeBoolean(this.name != null);
        if (this.name != null) {
            buffer.m_130083_(this.name);
        }
        this.display.toNetwork(buffer);
        this.animation.toNetwork(buffer);
        buffer.m_130055_(this.item);
        buffer.writeBoolean(this.entity != null);
        if (this.entity != null) {
            this.entity.toNetwork(buffer);
        }
        this.colors.toNetwork(buffer);
        buffer.writeBoolean(this.isHidden);
    }

    public static Trophy fromNetwork(FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.m_130281_();
        Component name = null;
        if (buffer.readBoolean()) {
            name = buffer.m_130238_();
        }
        DisplayInfo display = DisplayInfo.fromNetwork(buffer);
        Animation animation = Animation.fromNetwork(buffer);
        ItemStack item = buffer.m_130267_();
        EntityInfo entity = null;
        if (buffer.readBoolean()) {
            entity = EntityInfo.fromNetwork(buffer);
        }
        ColorInfo colors = ColorInfo.fromNetwork(buffer);
        boolean isHidden = buffer.readBoolean();
        return new Trophy(id, name, display, animation, item, entity, colors, isHidden);
    }

    public JsonObject toJson() {
        JsonObject result = new JsonObject();
        result.add("name", Component.Serializer.m_130716_((Component)this.name()));
        if (!this.display().equals(DisplayInfo.NONE)) {
            result.add("display", (JsonElement)this.display().toJson());
        }
        if (this.animation().type() != Animation.Type.FIXED) {
            result.add("animation", (JsonElement)this.animation().toJson());
        }
        if (!this.item().m_41619_()) {
            result.add("item", (JsonElement)Trophy.serializeItem(this.item()));
        }
        if (this.entity() != null) {
            result.add("entity", (JsonElement)this.entity().toJson());
        }
        if (!this.colors().equals(ColorInfo.NONE)) {
            result.add("colors", (JsonElement)this.colors().toJson());
        }
        if (this.isHidden()) {
            result.addProperty("isHidden", Boolean.valueOf(true));
        }
        return result;
    }

    private static JsonObject serializeItem(ItemStack item) {
        JsonObject result = new JsonObject();
        result.addProperty("item", item.m_41720_().getRegistryName().toString());
        if (item.m_41613_() != 1) {
            result.addProperty("count", (Number)item.m_41613_());
        }
        if (item.m_41782_()) {
            result.addProperty("nbt", item.m_41783_().toString());
        }
        return result;
    }

    public static Trophy fromJson(JsonElement element, ResourceLocation id) {
        JsonObject object = GsonHelper.m_13918_((JsonElement)element, (String)"trophy");
        EntityInfo entity = null;
        if (object.has("entity")) {
            entity = EntityInfo.fromJson(GsonHelper.m_13930_((JsonObject)object, (String)"entity"));
        }
        ItemStack item = ItemStack.f_41583_;
        if (object.has("item")) {
            item = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)object, (String)"item"), (boolean)true);
        }
        Animation animation = Animation.STATIC;
        if (object.has("animation")) {
            animation = Animation.fromJson(GsonHelper.m_13930_((JsonObject)object, (String)"animation"));
        }
        DisplayInfo display = DisplayInfo.NONE;
        if (object.has("display")) {
            display = DisplayInfo.fromJson(GsonHelper.m_13930_((JsonObject)object, (String)"display"));
        }
        ColorInfo colors = ColorInfo.NONE;
        if (object.has("colors")) {
            colors = ColorInfo.fromJson(GsonHelper.m_13930_((JsonObject)object, (String)"colors"));
        }
        MutableComponent name = null;
        if (object.has("name")) {
            name = Component.Serializer.m_130691_((JsonElement)object.get("name"));
        }
        boolean isHidden = false;
        if (object.has("isHidden")) {
            isHidden = GsonHelper.m_13912_((JsonObject)object, (String)"isHidden");
        }
        return new Trophy(id, (Component)name, display, animation, item, entity, colors, isHidden);
    }

    private static CompoundTag readNBT(JsonElement element) {
        try {
            if (element.isJsonObject()) {
                return TagParser.m_129359_((String)TrophyManager.GSON.toJson(element));
            }
            return TagParser.m_129359_((String)GsonHelper.m_13805_((JsonElement)element, (String)"nbt"));
        }
        catch (CommandSyntaxException exception) {
            throw new JsonSyntaxException(String.format("Invalid NBT Entry: %s", new Object[]{exception}));
        }
    }

    private static float readOptionalFloat(JsonObject object, String memberName, int defaultValue) {
        if (object.has(memberName)) {
            return GsonHelper.m_13915_((JsonObject)object, (String)memberName);
        }
        return defaultValue;
    }

    public record DisplayInfo(float xOffset, float yOffset, float zOffset, float xRotation, float yRotation, float zRotation, float scale) {
        public static final DisplayInfo NONE = new DisplayInfo(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);

        public DisplayInfo(float scale) {
            this(0.0f, 0.0f, 0.0f, scale);
        }

        public DisplayInfo(float xOffset, float yOffset, float zOffset, float scale) {
            this(xOffset, yOffset, zOffset, 0.0f, 0.0f, 0.0f, scale);
        }

        public void toNetwork(FriendlyByteBuf buffer) {
            buffer.writeFloat(this.xOffset);
            buffer.writeFloat(this.yOffset);
            buffer.writeFloat(this.zOffset);
            buffer.writeFloat(this.xRotation);
            buffer.writeFloat(this.yRotation);
            buffer.writeFloat(this.zRotation);
            buffer.writeFloat(this.scale);
        }

        public static DisplayInfo fromNetwork(FriendlyByteBuf buffer) {
            return new DisplayInfo(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }

        public JsonObject toJson() {
            JsonObject result = new JsonObject();
            if (this.xOffset() != 0.0f || this.yOffset() != 0.0f || this.zOffset() != 0.0f) {
                result.add("offset", (JsonElement)DisplayInfo.serializeVector(this.xOffset(), this.yOffset(), this.zOffset()));
            }
            if (this.xRotation() != 0.0f || this.yRotation() != 0.0f || this.zRotation() != 0.0f) {
                result.add("rotation", (JsonElement)DisplayInfo.serializeVector(this.xRotation(), this.yRotation(), this.zRotation()));
            }
            if (this.scale() != 0.0f) {
                result.addProperty("scale", (Number)Float.valueOf(this.scale()));
            }
            return result;
        }

        private static JsonObject serializeVector(float x, float y, float z) {
            JsonObject result = new JsonObject();
            if (x != 0.0f) {
                result.addProperty("x", (Number)Float.valueOf(x));
            }
            if (y != 0.0f) {
                result.addProperty("y", (Number)Float.valueOf(y));
            }
            if (z != 0.0f) {
                result.addProperty("z", (Number)Float.valueOf(z));
            }
            return result;
        }

        private static DisplayInfo fromJson(JsonObject object) {
            float zOffset = 0.0f;
            float yOffset = 0.0f;
            float xOffset = 0.0f;
            if (object.has("offset")) {
                JsonObject offset = GsonHelper.m_13930_((JsonObject)object, (String)"offset");
                xOffset = Trophy.readOptionalFloat(offset, "x", 0);
                yOffset = Trophy.readOptionalFloat(offset, "y", 0);
                zOffset = Trophy.readOptionalFloat(offset, "z", 0);
            }
            float zRotation = 0.0f;
            float yRotation = 0.0f;
            float xRotation = 0.0f;
            if (object.has("rotation")) {
                JsonObject rotation = GsonHelper.m_13930_((JsonObject)object, (String)"rotation");
                xRotation = Trophy.readOptionalFloat(rotation, "x", 0);
                yRotation = Trophy.readOptionalFloat(rotation, "y", 0);
                zRotation = Trophy.readOptionalFloat(rotation, "z", 0);
            }
            float scale = Trophy.readOptionalFloat(object, "scale", 1);
            return new DisplayInfo(xOffset, yOffset, zOffset, xRotation, yRotation, zRotation, scale);
        }
    }

    public record Animation(Type type, float speed) {
        public static final Animation STATIC = new Animation(Type.FIXED, 1.0f);

        public void toNetwork(FriendlyByteBuf buffer) {
            buffer.writeByte(this.type.ordinal());
            buffer.writeFloat(this.speed);
        }

        public static Animation fromNetwork(FriendlyByteBuf buffer) {
            Type type = Type.values()[buffer.readByte()];
            float speed = buffer.readFloat();
            if (type == Type.FIXED) {
                return STATIC;
            }
            return new Animation(type, speed);
        }

        public JsonObject toJson() {
            JsonObject result = new JsonObject();
            result.addProperty("type", this.type().name());
            if (this.speed() != 1.0f) {
                result.addProperty("speed", (Number)Float.valueOf(this.speed()));
            }
            return result;
        }

        private static Animation fromJson(JsonObject object) {
            Type type = Type.fromJson(object.get("type"));
            float speed = Trophy.readOptionalFloat(object, "speed", 1);
            return new Animation(type, speed);
        }

        public static enum Type {
            FIXED("fixed"),
            SPINNING("spinning"),
            TUMBLING("tumbling");

            private final String name;

            private Type(String name) {
                this.name = name;
            }

            public static Type fromJson(JsonElement element) {
                String name = GsonHelper.m_13805_((JsonElement)element, (String)"animation");
                for (Type animation : Type.values()) {
                    if (!animation.name.equals(name)) continue;
                    return animation;
                }
                throw new JsonParseException(String.format("Invalid trophy animation type: %s", name));
            }
        }
    }

    public static class EntityInfo {
        private final EntityType<?> type;
        private final CompoundTag nbt;
        private final boolean isAnimated;
        @Nullable
        private Entity entity;

        public EntityInfo(EntityType<?> type, CompoundTag nbt, boolean isAnimated) {
            this.type = type;
            this.nbt = nbt;
            this.isAnimated = isAnimated;
        }

        @Nullable
        public EntityType<?> getType() {
            return this.type;
        }

        public CompoundTag getTag() {
            return this.nbt;
        }

        public boolean isAnimated() {
            return this.isAnimated;
        }

        @Nullable
        public Entity getOrCreateEntity(Level level) {
            if (this.entity == null || this.entity.f_19853_ != level) {
                this.createEntity(level);
            }
            return this.entity;
        }

        private void createEntity(Level level) {
            if (this.type == null) {
                return;
            }
            this.entity = this.type.m_20615_(level);
            if (this.entity != null) {
                this.entity.m_20234_(0);
                this.entity.m_20258_(this.nbt);
                if (!this.nbt.m_128403_("UUID")) {
                    this.entity.m_20084_(Util.f_137441_);
                }
            }
        }

        public void toNetwork(FriendlyByteBuf buffer) {
            buffer.m_130085_(this.type.getRegistryName());
            buffer.m_130079_(this.nbt);
            buffer.writeBoolean(this.isAnimated);
        }

        public static EntityInfo fromNetwork(FriendlyByteBuf buffer) {
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(buffer.m_130281_());
            return new EntityInfo(type, buffer.m_130260_(), buffer.readBoolean());
        }

        public JsonObject toJson() {
            JsonObject result = new JsonObject();
            result.addProperty("type", this.getType().getRegistryName().toString());
            if (!this.getTag().m_128456_()) {
                result.addProperty("nbt", this.getTag().toString());
            }
            if (this.isAnimated()) {
                result.addProperty("animated", Boolean.valueOf(this.isAnimated()));
            }
            return result;
        }

        public static EntityInfo fromJson(JsonObject object) {
            ResourceLocation typeID = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"type"));
            if (!ForgeRegistries.ENTITIES.containsKey(typeID)) {
                throw new JsonParseException(String.format("Unknown entity type %s", typeID));
            }
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(typeID);
            CompoundTag nbt = new CompoundTag();
            if (object.has("nbt")) {
                JsonElement nbtElement = object.get("nbt");
                nbt = Trophy.readNBT(nbtElement);
            }
            boolean isAnimated = false;
            if (object.has("animated")) {
                isAnimated = GsonHelper.m_13912_((JsonObject)object, (String)"animated");
            }
            return new EntityInfo(type, nbt, isAnimated);
        }
    }

    public record ColorInfo(int base, int accent) {
        public static final ColorInfo NONE = new ColorInfo(0xFFFFFF, 0xFFFFFF);

        public void toNetwork(FriendlyByteBuf buffer) {
            buffer.writeInt(this.base);
            buffer.writeInt(this.accent);
        }

        public static ColorInfo fromNetwork(FriendlyByteBuf buffer) {
            return new ColorInfo(buffer.readInt(), buffer.readInt());
        }

        public JsonObject toJson() {
            JsonObject result = new JsonObject();
            if (this.base() != 0xFFFFFF) {
                result.add("base", ColorInfo.serializeColor(this.base()));
            }
            if (this.accent() != this.base()) {
                result.add("accent", ColorInfo.serializeColor(this.accent()));
            }
            return result;
        }

        private static JsonElement serializeColor(int color) {
            return new JsonPrimitive(String.format("#%06X", color));
        }

        public static ColorInfo fromJson(JsonObject object) {
            int accent = 0xFFFFFF;
            int base = 0xFFFFFF;
            if (object.has("base")) {
                base = accent = ColorInfo.readColor(object.get("base"));
            }
            if (object.has("accent")) {
                accent = ColorInfo.readColor(object.get("accent"));
            }
            return new ColorInfo(base, accent);
        }

        private static int readColor(JsonElement element) {
            if (element.isJsonObject()) {
                JsonObject object = element.getAsJsonObject();
                int red = GsonHelper.m_13927_((JsonObject)object, (String)"red");
                int green = GsonHelper.m_13927_((JsonObject)object, (String)"green");
                int blue = GsonHelper.m_13927_((JsonObject)object, (String)"blue");
                return red << 16 | green << 8 | blue;
            }
            if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                return ColorInfo.parseColor(element.getAsString());
            }
            throw new JsonParseException(String.format("Expected color to be json object or string, got %s", element));
        }

        private static int parseColor(String string) {
            if (string.startsWith("#")) {
                return Integer.parseInt(string.substring(1), 16);
            }
            throw new JsonParseException(String.format("Couldn't parse color string: %s", string));
        }
    }
}

