/*
 * Decompiled with CFR 0.152.
 */
package trofers.common.trophy.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import trofers.common.trophy.block.TrophyBlock;

public class PillarTrophyBlock
extends TrophyBlock {
    private final VoxelShape shape;

    public PillarTrophyBlock(BlockBehaviour.Properties properties, int size) {
        super(properties, size);
        this.shape = this.createShape(size);
    }

    @Override
    public int getHeight() {
        return this.getSize();
    }

    private VoxelShape createShape(int size) {
        int width = 2 * (size - 2);
        return Shapes.m_83124_((VoxelShape)PillarTrophyBlock.centeredBox(width, 0, 2), (VoxelShape[])new VoxelShape[]{PillarTrophyBlock.centeredBox(width - 2, 2, size - 2), PillarTrophyBlock.centeredBox(width, size - 2, size)});
    }

    private static VoxelShape centeredBox(int width, int minY, int maxY) {
        return Block.m_49796_((double)(8.0 - (double)width / 2.0), (double)minY, (double)(8.0 - (double)width / 2.0), (double)(8.0 + (double)width / 2.0), (double)maxY, (double)(8.0 + (double)width / 2.0));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shape;
    }
}

