/*
 * Decompiled with CFR 0.152.
 */
package trofers.common.trophy.block;

import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import trofers.Trofers;
import trofers.common.init.ModBlockEntityTypes;
import trofers.common.trophy.Trophy;
import trofers.common.trophy.TrophyManager;
import trofers.common.trophy.block.TrophyBlock;

public class TrophyBlockEntity
extends BlockEntity {
    @Nullable
    private Trophy trophy;
    @Nullable
    private ResourceLocation trophyID;
    private float animationOffset;

    public TrophyBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.TROPHY.get(), pos, state);
    }

    @Nullable
    public Trophy getTrophy() {
        return this.trophy;
    }

    public void setTrophy(@Nullable Trophy trophy) {
        this.trophy = trophy;
        this.trophyID = trophy != null ? trophy.id() : null;
        this.onContentsChanged();
    }

    @Nullable
    public ResourceLocation getTrophyID() {
        return this.trophyID;
    }

    public float getAnimationOffset() {
        if (this.animationOffset == 0.0f && this.f_58857_ != null) {
            this.animationOffset = this.f_58857_.m_5822_().nextFloat() * 4000.0f;
        }
        return this.animationOffset;
    }

    public int getTrophyHeight() {
        Block block = this.m_58900_().m_60734_();
        Block block2 = block;
        if (block2 instanceof TrophyBlock) {
            TrophyBlock trophy = (TrophyBlock)block2;
            return trophy.getHeight();
        }
        return 0;
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_().m_142082_(-1, 0, -1), this.m_58899_().m_142082_(1, 16, 1));
    }

    private void onContentsChanged() {
        if (this.f_58857_ != null) {
            if (!this.f_58857_.m_5776_()) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
                this.m_6596_();
            } else {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 8);
            }
        }
    }

    public CompoundTag m_5995_() {
        return this.m_6945_(new CompoundTag());
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.m_58899_(), 0, this.m_5995_());
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet) {
        if (this.f_58857_ != null) {
            this.m_142466_(packet.m_131708_());
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.loadTrophy(tag);
    }

    public void loadTrophy(CompoundTag tag) {
        this.trophy = null;
        this.trophyID = null;
        if (tag.m_128425_("Trophy", 8)) {
            try {
                this.trophyID = new ResourceLocation(tag.m_128461_("Trophy"));
            }
            catch (ResourceLocationException exception) {
                Trofers.LOGGER.error(String.format("Failed to load trophy for block entity at %s", this.m_58899_()), (Throwable)exception);
            }
            this.trophy = TrophyManager.get(this.trophyID);
            if (this.trophy == null) {
                Trofers.LOGGER.error(String.format("Invalid trophy id for block entity at %s: %s", this.m_58899_(), this.trophyID));
            }
        }
        if (this.m_58904_() != null && this.m_58904_().m_5776_()) {
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 8);
        }
    }

    public CompoundTag m_6945_(CompoundTag tag) {
        this.saveTrophy(tag);
        return super.m_6945_(tag);
    }

    public void saveTrophy(CompoundTag tag) {
        if (this.trophyID != null) {
            tag.m_128359_("Trophy", this.trophyID.toString());
        }
    }
}

