/*
 * Decompiled with CFR 0.152.
 */
package trofers.common.trophy.block;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fmlclient.gui.widget.ExtendedButton;
import trofers.common.network.NetworkHandler;
import trofers.common.network.SetTrophyPacket;
import trofers.common.trophy.Trophy;
import trofers.common.trophy.TrophyManager;
import trofers.common.trophy.block.TrophyBlockEntity;

public class TrophyScreen
extends Screen {
    private static final int HORIZONTAL_PADDING = 80;
    private static final int VERTICAL_PADDING = 20;
    private static final int BUTTON_SIZE = 40;
    private static final int BUTTON_SPACING = 8;
    private static final int CANCEL_BUTTON_WIDTH = 96;
    private static final int UPPER_BUTTON_SIZE = 20;
    private static final int MIN_ROWS = 2;
    private static final int MIN_COLUMNS = 2;
    private static final int MAX_COLUMNS = 16;
    private static final float ITEM_SCALE = 2.0f;
    private Button previousButton;
    private Button nextButton;
    private final Set<Button> trophyButtons = new HashSet<Button>();
    private int currentPage;
    private int rows;
    private int columns;
    private int rowStart;
    private int columnStart;
    private final Item trophyItem;
    private final BlockPos blockPos;

    public TrophyScreen(Item trophyItem, BlockPos blockPos) {
        super(TextComponent.f_131282_);
        this.trophyItem = trophyItem;
        this.blockPos = blockPos;
    }

    public static void open(Item item, BlockPos pos) {
        Minecraft.m_91087_().m_91152_((Screen)new TrophyScreen(item, pos));
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.f_96541_ != null && this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
            return true;
        }
        return false;
    }

    protected void m_7856_() {
        int previousRows = this.rows;
        int previousColumns = this.columns;
        this.columns = (this.f_96543_ - 160 - 40) / 48 + 1;
        this.columns = Math.max(this.columns, 2);
        this.columns = Math.min(this.columns, 16);
        this.columnStart = this.f_96543_ / 2 - (40 * this.columns + 8 * (this.columns - 1)) / 2;
        this.rowStart = 56;
        this.rows = (this.f_96544_ - this.rowStart - 20 - 40) / 48 + 1;
        this.rows = Math.max(this.rows, 2);
        this.createUpperButtons();
        if (this.columns == previousColumns && this.rows == previousRows) {
            this.setCurrentPage(this.currentPage);
        } else {
            this.setCurrentPage(0);
        }
    }

    private void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
        this.trophyButtons.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
        List trophies = TrophyManager.values().stream().filter(trophy -> !trophy.isHidden()).sorted(Comparator.comparing(trophy -> trophy.id().toString())).collect(Collectors.toCollection(ArrayList::new));
        int index = currentPage * this.columns * this.rows;
        for (int row = 0; row < this.rows; ++row) {
            for (int column = 0; column < this.columns && index < trophies.size(); ++column) {
                ItemStack stack = new ItemStack((ItemLike)this.trophyItem);
                Trophy trophy2 = (Trophy)trophies.get(index++);
                stack.m_41698_("BlockEntityTag").m_128359_("Trophy", trophy2.id().toString());
                int x = this.columnStart + column * 48;
                int y = this.rowStart + row * 48;
                this.trophyButtons.add((Button)this.m_142416_((GuiEventListener)new ItemButton(x, y, 40, stack, button -> this.setTrophy(trophy2))));
            }
        }
        this.nextButton.f_93623_ = false;
        this.previousButton.f_93623_ = false;
        if (index < trophies.size() - 1) {
            this.nextButton.f_93623_ = true;
        }
        if (currentPage > 0) {
            this.previousButton.f_93623_ = true;
        }
    }

    private void createUpperButtons() {
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 - 48, 20, 96, 20, (Component)new TranslatableComponent(String.format("button.%s.cancel", "trofers")), button -> this.m_7379_()));
        this.previousButton = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 - 48 - 8 - 20, 20, 20, 20, (Component)new TextComponent("<"), button -> this.setCurrentPage(this.currentPage - 1)));
        this.nextButton = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.f_96543_ / 2 + 48 + 8, 20, 20, 20, (Component)new TextComponent(">"), button -> this.setCurrentPage(this.currentPage + 1)));
    }

    public boolean m_7043_() {
        return false;
    }

    private void setTrophy(Trophy trophy) {
        BlockEntity blockEntity;
        NetworkHandler.INSTANCE.sendToServer((Object)new SetTrophyPacket(trophy, this.blockPos));
        if (Minecraft.m_91087_().f_91074_ != null && (blockEntity = Minecraft.m_91087_().f_91074_.f_19853_.m_7702_(this.blockPos)) instanceof TrophyBlockEntity) {
            TrophyBlockEntity blockEntity2 = (TrophyBlockEntity)blockEntity;
            blockEntity2.setTrophy(trophy);
        }
        this.m_7379_();
    }

    private class ItemButton
    extends ExtendedButton {
        private final ItemStack item;

        public ItemButton(int xPos, int yPos, int size, ItemStack item, Button.OnPress handler) {
            super(xPos, yPos, size, size, TextComponent.f_131282_, handler);
            this.item = item;
        }

        public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
            super.m_6303_(poseStack, mouseX, mouseY, partialTicks);
            this.renderScaledGuiItem(this.item, this.f_93620_ + (int)((float)this.f_93618_ - 32.0f) / 2, this.f_93621_ + (int)((float)this.f_93619_ - 32.0f) / 2, 2.0f);
            if (this.m_5702_()) {
                this.m_7428_(poseStack, mouseX, mouseY);
            }
        }

        public void m_7428_(PoseStack poseStack, int mouseX, int mouseY) {
            TrophyScreen.this.m_6057_(poseStack, this.item, mouseX, mouseY);
        }

        private void renderScaledGuiItem(ItemStack item, int x, int y, float scale) {
            if (!item.m_41619_()) {
                BakedModel bakedmodel = TrophyScreen.this.f_96542_.m_174264_(item, null, (LivingEntity)Minecraft.m_91087_().f_91074_, 0);
                ((TrophyScreen)TrophyScreen.this).f_96542_.f_115093_ += 50.0f;
                try {
                    this.renderGuiItem(item, x, y, scale, bakedmodel);
                }
                catch (Exception exception) {
                    CrashReport crashReport = CrashReport.m_127521_((Throwable)exception, (String)"Rendering item");
                    CrashReportCategory category = crashReport.m_127514_("Item being rendered");
                    category.m_128165_("Item Type", () -> String.valueOf(item.m_41720_()));
                    category.m_128165_("Registry Name", () -> String.valueOf(item.m_41720_().getRegistryName()));
                    category.m_128165_("Item Damage", () -> String.valueOf(item.m_41773_()));
                    category.m_128165_("Item NBT", () -> String.valueOf(item.m_41783_()));
                    category.m_128165_("Item Foil", () -> String.valueOf(item.m_41790_()));
                    throw new ReportedException(crashReport);
                }
                ((TrophyScreen)TrophyScreen.this).f_96542_.f_115093_ -= 50.0f;
            }
        }

        protected void renderGuiItem(ItemStack item, int x, int y, float scale, BakedModel model) {
            boolean flag;
            Minecraft.m_91087_().f_90987_.m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
            RenderSystem.m_69478_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            PoseStack modelViewStack = RenderSystem.m_157191_();
            modelViewStack.m_85836_();
            modelViewStack.m_85837_((double)x, (double)y, (double)(100.0f + ((TrophyScreen)TrophyScreen.this).f_96542_.f_115093_));
            modelViewStack.m_85837_((double)(16.0f * scale / 2.0f), (double)(16.0f * scale / 2.0f), 0.0);
            modelViewStack.m_85841_(1.0f, -1.0f, 1.0f);
            modelViewStack.m_85841_(scale, scale, scale);
            modelViewStack.m_85841_(16.0f, 16.0f, 16.0f);
            RenderSystem.m_157182_();
            PoseStack poseStack = new PoseStack();
            MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
            boolean bl = flag = !model.m_7547_();
            if (flag) {
                Lighting.m_84930_();
            }
            TrophyScreen.this.f_96542_.m_115143_(item, ItemTransforms.TransformType.GUI, false, poseStack, (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.f_118083_, model);
            buffer.m_109911_();
            RenderSystem.m_69482_();
            if (flag) {
                Lighting.m_84931_();
            }
            modelViewStack.m_85849_();
            RenderSystem.m_157182_();
        }
    }
}

