/*
 * Decompiled with CFR 0.152.
 */
package trofers.common.trophy.item;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.IItemRenderProperties;
import trofers.common.trophy.Trophy;
import trofers.common.trophy.block.TrophyBlock;
import trofers.common.trophy.block.TrophyBlockEntity;
import trofers.common.trophy.item.TrophyItemRenderer;

public class TrophyItem
extends BlockItem {
    public TrophyItem(TrophyBlock block, Item.Properties properties) {
        super((Block)block, properties);
    }

    protected boolean m_7429_(BlockPlaceContext context, BlockState state) {
        if (super.m_7429_(context, state)) {
            BlockEntity blockEntity = context.m_43725_().m_7702_(context.m_8083_());
            CompoundTag tag = context.m_43722_().m_41783_();
            BlockEntity blockEntity2 = blockEntity;
            if (blockEntity2 instanceof TrophyBlockEntity) {
                TrophyBlockEntity trophy = (TrophyBlockEntity)blockEntity2;
                if (tag != null) {
                    trophy.loadTrophy(tag.m_128469_("BlockEntityTag"));
                }
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public Component m_7626_(ItemStack stack) {
        Trophy trophy = Trophy.getTrophy(stack);
        if (trophy != null && trophy.name() != null) {
            return trophy.name();
        }
        return super.m_7626_(stack);
    }

    @Nullable
    public String getCreatorModId(ItemStack stack) {
        Trophy trophy = Trophy.getTrophy(stack);
        if (trophy != null) {
            return trophy.id().m_135827_();
        }
        return super.getCreatorModId(stack);
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){
            private final BlockEntityWithoutLevelRenderer renderer = new TrophyItemRenderer();

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return this.renderer;
            }
        });
    }
}

