/*
 * Decompiled with CFR 0.152.
 */
package trofers.data;

import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import trofers.common.init.ModBlocks;
import trofers.common.trophy.block.PillarTrophyBlock;
import trofers.common.trophy.block.PlateTrophyBlock;
import trofers.common.trophy.block.TrophyBlock;

public class BlockStates
extends BlockStateProvider {
    public BlockStates(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "trofers", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        ModBlocks.TROPHIES.forEach(trophy -> {
            String modelLocation = "trofers:block/" + trophy.getId().m_135815_();
            ModelBuilder builder = this.models().withExistingParent(modelLocation, "block");
            this.horizontalBlock((Block)trophy.get(), state -> builder);
            if (trophy.get() instanceof PillarTrophyBlock) {
                BlockStates.createPillar(builder, (TrophyBlock)trophy.get());
            } else if (trophy.get() instanceof PlateTrophyBlock) {
                BlockStates.createPlate(builder, (TrophyBlock)trophy.get());
            }
        });
    }

    public static void createPillar(ModelBuilder<?> modelBuilder, TrophyBlock block) {
        int size = block.getSize();
        int width = 2 * (size - 2);
        BlockStates.texturedCenteredBox(modelBuilder, width, 0, 2, 0);
        BlockStates.texturedCenteredBox(modelBuilder, width - 2, 2, size - 2, 1);
        BlockStates.texturedCenteredBox(modelBuilder, width, size - 2, size, 0);
        BlockStates.setTextures(modelBuilder, block);
    }

    public static void createPlate(ModelBuilder<?> modelBuilder, TrophyBlock block) {
        int size = block.getSize();
        int width = 2 * (size - 2);
        BlockStates.texturedCenteredBox(modelBuilder, width, 0, 2, 0);
        BlockStates.centeredBox(modelBuilder, width, 0, 2).face(Direction.UP).tintindex(1).texture("#overlay");
        BlockStates.setTextures(modelBuilder, block);
        String overlayTexture = "trofers:block/" + block.getRegistryName().m_135815_() + "_overlay";
        modelBuilder.texture("overlay", overlayTexture);
    }

    public static void setTextures(ModelBuilder<?> modelBuilder, TrophyBlock block) {
        String name = block.getRegistryName().m_135815_();
        String texturePath = "trofers:block/" + name.replace("plate", "pillar");
        modelBuilder.texture("particle", "#top").texture("top", texturePath + "_top").texture("side", texturePath + "_side");
    }

    public static void texturedCenteredBox(ModelBuilder<?> builder, int width, int minY, int maxY, int tintIndex) {
        BlockStates.centeredBox(builder, width, minY, maxY).allFaces((direction, face) -> face.tintindex(tintIndex).texture(direction.m_122434_() == Direction.Axis.Y ? "#top" : "#side"));
    }

    public static ModelBuilder.ElementBuilder centeredBox(ModelBuilder<?> builder, int width, int minY, int maxY) {
        return builder.element().from(8.0f - (float)width / 2.0f, (float)minY, 8.0f - (float)width / 2.0f).to(8.0f + (float)width / 2.0f, (float)maxY, 8.0f + (float)width / 2.0f);
    }
}

