/*
 * Decompiled with CFR 0.152.
 */
package trofers.data;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraftforge.fmllegacy.RegistryObject;
import trofers.common.init.ModBlocks;
import trofers.common.init.ModItems;
import trofers.common.loot.RandomTrophyChanceCondition;
import trofers.common.trophy.block.TrophyBlock;
import trofers.data.Trophies;

public class LootTables
extends LootTableProvider {
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> lootTables = new ArrayList<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>>();
    private final Trophies trophies;

    public LootTables(DataGenerator generator, Trophies trophies) {
        super(generator);
        this.trophies = trophies;
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        this.lootTables.clear();
        this.addBlockLootTables();
        this.addEntityLootTables();
        return this.lootTables;
    }

    private void addBlockLootTables() {
        CopyNbtFunction.Builder copyNbtBuilder = CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("Trophy", "BlockEntityTag.Trophy");
        for (RegistryObject<TrophyBlock> trophy : ModBlocks.TROPHIES) {
            ResourceLocation location = new ResourceLocation("trofers", "blocks/" + trophy.getId().m_135815_());
            LootTable.Builder lootTable = LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)trophy.get())).m_5577_((LootItemFunction.Builder)copyNbtBuilder)));
            this.lootTables.add((Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>)Pair.of(() -> builder -> builder.accept(location, lootTable), (Object)LootContextParamSets.f_81421_));
        }
    }

    private void addEntityLootTables() {
        this.trophies.trophies.forEach((id, trophy) -> {
            String entityName = trophy.entity().getType().getRegistryName().m_135815_();
            ResourceLocation location = new ResourceLocation("trofers", "inject/entities/" + entityName);
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("BlockEntityTag", (Tag)new CompoundTag());
            nbt.m_128469_("BlockEntityTag").m_128359_("Trophy", String.format("%s:%s", "trofers", entityName));
            LootTable.Builder lootTable = LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_6509_(RandomTrophyChanceCondition.randomTrophyChance()).m_6509_(LootItemKilledByPlayerCondition.m_81901_()).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.SMALL_PLATE.get()))).m_5577_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)nbt)));
            this.lootTables.add((Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>)Pair.of(() -> builder -> builder.accept(location, lootTable), (Object)LootContextParamSets.f_81415_));
        });
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationTracker) {
        map.forEach((location, lootTable) -> net.minecraft.world.level.storage.loot.LootTables.m_79202_((ValidationContext)validationTracker, (ResourceLocation)location, (LootTable)lootTable));
    }
}

