/*
 * Decompiled with CFR 0.152.
 */
package trofers.data;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import trofers.Trofers;
import trofers.common.trophy.Trophy;

public class Trophies
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final Map<ResourceLocation, Trophy> trophies = new HashMap<ResourceLocation, Trophy>();
    private final DataGenerator generator;

    protected Trophies(DataGenerator dataGenerator) {
        this.generator = dataGenerator;
    }

    protected void addTrophies() {
        this.trophies.clear();
        HashMap<EntityType, Integer> entityColors = new HashMap<EntityType, Integer>();
        HashMap<EntityType, Trophy.DisplayInfo> displayInfos = new HashMap<EntityType, Trophy.DisplayInfo>();
        HashMap entityData = new HashMap();
        entityColors.put(EntityType.f_147039_, 16499170);
        entityColors.put(EntityType.f_20549_, 7693631);
        entityColors.put(EntityType.f_20550_, 15451458);
        entityColors.put(EntityType.f_20551_, 15591238);
        entityColors.put(EntityType.f_20553_, 9662805);
        entityColors.put(EntityType.f_20554_, 1342314);
        entityColors.put(EntityType.f_20555_, 0xFFFFFF);
        entityColors.put(EntityType.f_20556_, 11966572);
        entityColors.put(EntityType.f_20557_, 7098932);
        entityColors.put(EntityType.f_20558_, 4764218);
        entityColors.put(EntityType.f_20559_, 11584728);
        entityColors.put(EntityType.f_20560_, 8483172);
        entityColors.put(EntityType.f_20562_, 5670014);
        entityColors.put(EntityType.f_20563_, 0xBFBBAA);
        entityColors.put(EntityType.f_20566_, 10571702);
        entityColors.put(EntityType.f_20567_, 6572932);
        entityColors.put(EntityType.f_20568_, 0x959C9C);
        entityColors.put(EntityType.f_20452_, 14908449);
        entityColors.put(EntityType.f_20453_, 0xF0F0F0);
        entityColors.put(EntityType.f_147034_, 3318177);
        entityColors.put(EntityType.f_147035_, 12757902);
        entityColors.put(EntityType.f_20455_, 6983815);
        entityColors.put(EntityType.f_20456_, 13997435);
        entityColors.put(EntityType.f_20457_, 9594419);
        entityColors.put(EntityType.f_20458_, 13085551);
        entityColors.put(EntityType.f_20460_, 13480599);
        entityColors.put(EntityType.f_20466_, 14935252);
        entityColors.put(EntityType.f_20468_, 16729600);
        entityColors.put(EntityType.f_20504_, 10752018);
        entityColors.put(EntityType.f_20503_, 8997164);
        entityColors.put(EntityType.f_20505_, 15577698);
        entityColors.put(EntityType.f_20507_, 0xE4E4E4);
        entityColors.put(EntityType.f_20508_, 0xE60000);
        entityColors.put(EntityType.f_20509_, 5333413);
        entityColors.put(EntityType.f_20510_, 15836068);
        entityColors.put(EntityType.f_20511_, 15710599);
        entityColors.put(EntityType.f_20512_, 15710599);
        entityColors.put(EntityType.f_20513_, 0x929C9C);
        entityColors.put(EntityType.f_20514_, 0xF2F2F4);
        entityColors.put(EntityType.f_20516_, 14915339);
        entityColors.put(EntityType.f_20517_, 10652530);
        entityColors.put(EntityType.f_20518_, 9546923);
        entityColors.put(EntityType.f_20519_, 11024181);
        entityColors.put(EntityType.f_20520_, 0xFFFFFF);
        entityColors.put(EntityType.f_20521_, 9988759);
        entityColors.put(EntityType.f_20523_, 7834777);
        entityColors.put(EntityType.f_20524_, 0xBDBDBD);
        entityColors.put(EntityType.f_20525_, 0xD0D0D2);
        entityColors.put(EntityType.f_20526_, 7848548);
        entityColors.put(EntityType.f_20528_, 0xFFFFFF);
        entityColors.put(EntityType.f_20479_, 8021845);
        entityColors.put(EntityType.f_20480_, 5533056);
        entityColors.put(EntityType.f_20481_, 6321526);
        entityColors.put(EntityType.f_20482_, 0xB44040);
        entityColors.put(EntityType.f_20488_, 4349840);
        entityColors.put(EntityType.f_20489_, 0xFF4040);
        entityColors.put(EntityType.f_20490_, 4104768);
        entityColors.put(EntityType.f_20491_, 9019574);
        entityColors.put(EntityType.f_20492_, 12552301);
        entityColors.put(EntityType.f_20493_, 0x929C9C);
        entityColors.put(EntityType.f_20494_, 4349840);
        entityColors.put(EntityType.f_20495_, 10720386);
        entityColors.put(EntityType.f_20497_, 0x626565);
        entityColors.put(EntityType.f_20499_, 14473947);
        entityColors.put(EntityType.f_20500_, 15046550);
        entityColors.put(EntityType.f_20501_, 7378268);
        entityColors.put(EntityType.f_20530_, 7774277);
        entityColors.put(EntityType.f_20531_, 15046550);
        entityColors.keySet().forEach(type -> {
            displayInfos.put((EntityType)type, new Trophy.DisplayInfo(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f));
            entityData.put(type, new CompoundTag());
        });
        displayInfos.put(EntityType.f_20453_, new Trophy.DisplayInfo(0.0f, 5.0f, 0.0f, 0.075f));
        displayInfos.put(EntityType.f_147034_, new Trophy.DisplayInfo(0.0f, 5.0f, 0.0f, 0.25f));
        displayInfos.put(EntityType.f_20480_, new Trophy.DisplayInfo(0.0f, 5.0f, 0.0f, 0.25f));
        displayInfos.put(EntityType.f_20509_, new Trophy.DisplayInfo(0.0f, 1.0f, 0.0f, 0.25f));
        displayInfos.put(EntityType.f_20563_, new Trophy.DisplayInfo(0.10625f));
        displayInfos.put(EntityType.f_20518_, new Trophy.DisplayInfo(0.175f));
        displayInfos.put(EntityType.f_20452_, new Trophy.DisplayInfo(0.75f, 0.0f, 0.5f, 0.0f, -90.0f, 0.0f, 0.25f));
        displayInfos.put(EntityType.f_20556_, new Trophy.DisplayInfo(-0.375f, 1.0f, 0.0f, 0.0f, 0.0f, -90.0f, 0.25f));
        displayInfos.put(EntityType.f_20519_, new Trophy.DisplayInfo(-0.375f, 1.0f, 0.0f, 0.0f, 0.0f, -90.0f, 0.25f));
        displayInfos.put(EntityType.f_20489_, new Trophy.DisplayInfo(-0.375f, 1.0f, 0.0f, 0.0f, 0.0f, -90.0f, 0.25f));
        ((CompoundTag)entityData.get(EntityType.f_147039_)).m_128405_("Variant", 0);
        ((CompoundTag)entityData.get(EntityType.f_20553_)).m_128405_("CatType", 0);
        ((CompoundTag)entityData.get(EntityType.f_20553_)).m_128379_("Sitting", true);
        ((CompoundTag)entityData.get(EntityType.f_20566_)).m_128365_("carriedBlockState", (Tag)new CompoundTag());
        ((CompoundTag)entityData.get(EntityType.f_20566_)).m_128469_("carriedBlockState").m_128359_("Name", "minecraft:tnt");
        ((CompoundTag)entityData.get(EntityType.f_20452_)).m_128359_("Type", "red");
        ((CompoundTag)entityData.get(EntityType.f_20452_)).m_128379_("Sleeping", true);
        ((CompoundTag)entityData.get(EntityType.f_147034_)).m_128405_("DarkTicksRemaining", 1);
        ((CompoundTag)entityData.get(EntityType.f_20456_)).m_128379_("IsImmuneToZombification", true);
        ((CompoundTag)entityData.get(EntityType.f_20457_)).m_128405_("Variant", 257);
        ((CompoundTag)entityData.get(EntityType.f_20466_)).m_128405_("Variant", 3);
        ((CompoundTag)entityData.get(EntityType.f_20468_)).m_128405_("Size", 1);
        ((CompoundTag)entityData.get(EntityType.f_20507_)).m_128359_("MainGene", "playful");
        ((CompoundTag)entityData.get(EntityType.f_20508_)).m_128405_("Variant", 0);
        ((CompoundTag)entityData.get(EntityType.f_20511_)).m_128379_("IsImmuneToZombification", true);
        this.putHandItem((CompoundTag)entityData.get(EntityType.f_20512_), Items.f_42433_);
        this.putHandItem((CompoundTag)entityData.get(EntityType.f_20513_), Items.f_42717_);
        ((CompoundTag)entityData.get(EntityType.f_20516_)).m_128405_("PuffState", 2);
        ((CompoundTag)entityData.get(EntityType.f_20517_)).m_128405_("RabbitType", 0);
        this.putHandItem((CompoundTag)entityData.get(EntityType.f_20524_), Items.f_42411_);
        ((CompoundTag)entityData.get(EntityType.f_20526_)).m_128405_("Size", 1);
        this.putHandItem((CompoundTag)entityData.get(EntityType.f_20481_), Items.f_42411_);
        ((CompoundTag)entityData.get(EntityType.f_20488_)).m_128405_("Variant", 2);
        ((CompoundTag)entityData.get(EntityType.f_20489_)).m_128405_("Variant", 0xE0E0101);
        ((CompoundTag)entityData.get(EntityType.f_20492_)).m_128365_("VillagerData", (Tag)new CompoundTag());
        ((CompoundTag)entityData.get(EntityType.f_20492_)).m_128469_("VillagerData").m_128405_("level", 1);
        ((CompoundTag)entityData.get(EntityType.f_20492_)).m_128469_("VillagerData").m_128359_("profession", "minecraft:weaponsmith");
        ((CompoundTag)entityData.get(EntityType.f_20492_)).m_128469_("VillagerData").m_128359_("type", "minecraft:plains");
        ((CompoundTag)entityData.get(EntityType.f_20499_)).m_128379_("Sitting", true);
        ((CompoundTag)entityData.get(EntityType.f_20499_)).m_128362_("Owner", Util.f_137441_);
        this.putHandItem((CompoundTag)entityData.get(EntityType.f_20497_), Items.f_42425_);
        ((CompoundTag)entityData.get(EntityType.f_20530_)).m_128365_("VillagerData", (Tag)new CompoundTag());
        ((CompoundTag)entityData.get(EntityType.f_20530_)).m_128469_("VillagerData").m_128405_("level", 1);
        ((CompoundTag)entityData.get(EntityType.f_20530_)).m_128469_("VillagerData").m_128359_("profession", "minecraft:weaponsmith");
        ((CompoundTag)entityData.get(EntityType.f_20530_)).m_128469_("VillagerData").m_128359_("type", "minecraft:plains");
        this.putHandItem((CompoundTag)entityData.get(EntityType.f_20531_), Items.f_42430_);
        entityColors.keySet().forEach(type -> this.addTrophy(new Trophy(new ResourceLocation("trofers", type.getRegistryName().m_135815_()), this.createName((EntityType<?>)type, (Integer)entityColors.get(type)), (Trophy.DisplayInfo)displayInfos.get(type), Trophy.Animation.STATIC, ItemStack.f_41583_, new Trophy.EntityInfo((EntityType<?>)type, (CompoundTag)entityData.get(type), false), new Trophy.ColorInfo(0x606060, (Integer)entityColors.get(type)), false)));
    }

    private void putHandItem(CompoundTag tag, Item item) {
        tag.m_128365_("HandItems", (Tag)new ListTag());
        tag.m_128437_("HandItems", 10).add((Object)new ItemStack((ItemLike)item).m_41739_(new CompoundTag()));
        tag.m_128437_("HandItems", 10).add((Object)new CompoundTag());
    }

    private Component createName(EntityType<?> entityType, int color) {
        return ComponentUtils.m_130750_((MutableComponent)new TranslatableComponent("trophy.trofers.composed", new Object[]{entityType.m_20676_()}), (Style)Style.f_131099_.m_178520_(color));
    }

    private void addTrophy(Trophy trophy) {
        this.trophies.put(trophy.id(), trophy);
    }

    public void m_6865_(HashCache cache) {
        this.addTrophies();
        Path outputFolder = this.generator.m_123916_();
        HashSet set = Sets.newHashSet();
        Consumer<Trophy> consumer = trophy -> {
            if (!set.add(trophy.id())) {
                throw new IllegalStateException("Duplicate trophy " + trophy.id());
            }
            Path path = Trophies.createPath(outputFolder, trophy);
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)trophy.toJson(), (Path)path);
            }
            catch (IOException ioexception) {
                Trofers.LOGGER.error("Couldn't save trophy {}", (Object)path, (Object)ioexception);
            }
        };
        this.trophies.forEach((resourceLocation, trophy) -> consumer.accept((Trophy)trophy));
    }

    private static Path createPath(Path path, Trophy trophy) {
        return path.resolve("data/" + trophy.id().m_135827_() + "/trofers/" + trophy.id().m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Trophies";
    }
}

