/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.veinmining.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import top.theillusivec4.veinmining.veinmining.VeinMiningEnchantment;

public class VeinMiningConfig {
    public static final ForgeConfigSpec CONFIG_SPEC;
    public static final Config CONFIG;
    private static final String CONFIG_PREFIX = "gui.veinmining.config.";

    public static void bake() {
        Enchantment.bake();
        VeinMining.bake();
    }

    public static List<String> generateDefaultGroups() {
        return Lists.newArrayList((Object[])new String[]{"#forge:obsidian", "#forge:ores/coal", "#forge:ores/diamond", "#forge:ores/emerald", "#forge:ores/gold", "#forge:ores/iron", "#forge:ores/lapis", "#forge:ores/redstone", "#forge:ores/quartz", "#forge:ores/netherite_scrap", "#forge:ores/copper", "#forge:ores/tin", "#forge:ores/osmium", "#forge:ores/uranium", "#forge:ores/fluorite", "#forge:ores/lead", "#forge:ores/zinc", "#forge:ores/aluminum", "#forge:ores/nickel", "#forge:ores/silver", "#forge:ores/apatite", "#forge:ores/cinnabar", "#forge:ores/niter", "#forge:ores/ruby", "#forge:ores/sapphire", "#forge:ores/sulfur"});
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
        CONFIG = (Config)specPair.getLeft();
    }

    public static enum ActivationState {
        STANDING,
        CROUCHING,
        KEYBINDING;

    }

    public static enum PermissionType {
        BLACKLIST,
        WHITELIST;

    }

    public static class Config {
        public final ForgeConfigSpec.EnumValue<Enchantment.Rarity> rarity;
        public final ForgeConfigSpec.IntValue levels;
        public final ForgeConfigSpec.BooleanValue isTreasure;
        public final ForgeConfigSpec.BooleanValue isVillagerTrade;
        public final ForgeConfigSpec.BooleanValue isLootable;
        public final ForgeConfigSpec.BooleanValue canApplyAtEnchantingTable;
        public final ForgeConfigSpec.BooleanValue canApplyOnBooks;
        public final ForgeConfigSpec.IntValue minEnchantabilityBase;
        public final ForgeConfigSpec.IntValue minEnchantabilityPerLevel;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> incompatibleEnchantments;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> items;
        public final ForgeConfigSpec.BooleanValue requireEffectiveTool;
        public final ForgeConfigSpec.IntValue maxBlocksBase;
        public final ForgeConfigSpec.IntValue maxDistanceBase;
        public final ForgeConfigSpec.IntValue maxBlocksPerLevel;
        public final ForgeConfigSpec.IntValue maxDistancePerLevel;
        public final ForgeConfigSpec.BooleanValue diagonalMining;
        public final ForgeConfigSpec.BooleanValue relocateDrops;
        public final ForgeConfigSpec.BooleanValue preventToolDestruction;
        public final ForgeConfigSpec.BooleanValue addToolDamage;
        public final ForgeConfigSpec.IntValue toolDamageMultiplier;
        public final ForgeConfigSpec.BooleanValue addPlayerExhaustion;
        public final ForgeConfigSpec.DoubleValue playerExhaustionMultiplier;
        public final ForgeConfigSpec.BooleanValue limitedByDurability;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> blocks;
        public final ForgeConfigSpec.EnumValue<PermissionType> blocksPermission;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> groups;

        public Config(ForgeConfigSpec.Builder builder) {
            builder.push("enchantment");
            this.rarity = builder.comment("The rarity of the enchantment").translation("gui.veinmining.config.rarity").defineEnum("rarity", (Enum)Enchantment.Rarity.RARE);
            this.levels = builder.comment("The number of levels of the enchantment").translation("gui.veinmining.config.levels").defineInRange("levels", 1, 1, 5);
            this.isTreasure = builder.comment("Whether or not to consider this enchantment as a treasure").translation("gui.veinmining.config.isTreasure").define("isTreasure", false);
            this.isVillagerTrade = builder.comment("Whether or not this enchantment can be offered by villagers for trade").translation("gui.veinmining.config.isVillagerTrade").define("isVillagerTrade", true);
            this.isLootable = builder.comment("Whether or not this enchantment can generate in loot").translation("gui.veinmining.config.isLootable").define("isLootable", true);
            this.canApplyAtEnchantingTable = builder.comment("Whether or not this enchantment can be applied at the enchanting table").translation("gui.veinmining.config.canApplyAtEnchantingTable").define("canApplyAtEnchantingTable", true);
            this.canApplyOnBooks = builder.comment("Whether or not this enchantment can be applied on books").translation("gui.veinmining.config.canApplyOnBooks").define("canApplyOnBooks", true);
            this.minEnchantabilityBase = builder.comment("The minimum enchantability requirement for the first enchantment level").translation("gui.veinmining.config.minEnchantabilityBase").defineInRange("minEnchantabilityBase", 15, 1, 100);
            this.minEnchantabilityPerLevel = builder.comment("The additional enchantability requirement for each enchantment level after the first").translation("gui.veinmining.config.minEnchantabilityPerLevel").defineInRange("minEnchantabilityPerLevel", 5, 1, 100);
            this.incompatibleEnchantments = builder.comment("List of enchantments that cannot be applied together with this enchantment").translation("gui.veinmining.config.incompatibleEnchantments").defineList("incompatibleEnchantments", new ArrayList(), s -> s instanceof String);
            this.items = builder.comment("List of items that the enchantment can be applied on").translation("gui.veinmining.config.items").defineList("items", Arrays.asList("is:tool", "quark:pickarang", "quark:flamarang"), s -> s instanceof String);
            builder.pop();
            builder.push("vein mining");
            this.requireEffectiveTool = builder.comment("Whether or not to require an effective tool to vein mine blocks").translation("gui.veinmining.config.requireEffectiveTool").define("requireEffectiveTool", false);
            this.maxBlocksBase = builder.comment("The maximum number of blocks to mine without the enchantment").translation("gui.veinmining.config.maxBlocksBase").defineInRange("maxBlocksBase", 0, 0, 1000);
            this.maxDistanceBase = builder.comment("The maximum distance from the source block without the enchantment").translation("gui.veinmining.config.maxDistanceBase").defineInRange("maxDistanceBase", 0, 0, 1000);
            this.maxBlocksPerLevel = builder.comment("The maximum number of blocks to mine per level of the enchantment").translation("gui.veinmining.config.maxBlocksPerLevel").defineInRange("maxBlocksPerLevel", 50, 1, 1000);
            this.maxDistancePerLevel = builder.comment("The maximum distance from the source block per level of the enchantment").translation("gui.veinmining.config.maxDistancePerLevel").defineInRange("maxDistancePerLevel", 15, 1, 100);
            this.diagonalMining = builder.comment("Whether or not to vein mine diagonally, note this may lead to hidden drops if relocateDrops is false").translation("gui.veinmining.config.diagonalMining").define("diagonalMining", true);
            this.limitedByDurability = builder.comment("Whether or not to stop vein mining when the tool can no longer be used").translation("gui.veinmining.config.limitedByDurability").define("limitedByDurability", true);
            this.relocateDrops = builder.comment("Whether or not to move all drops to the same location").translation("gui.veinmining.config.relocateDrops").define("relocateDrops", true);
            this.preventToolDestruction = builder.comment("Whether or not the tool can break while mining additional blocks").translation("gui.veinmining.config.preventToolDestruction").define("preventToolDestruction", true);
            this.addToolDamage = builder.comment("Whether or not the tool takes damage from mining additional blocks").translation("gui.veinmining.config.addToolDamage").define("addToolDamage", true);
            this.toolDamageMultiplier = builder.comment("The multiplier to tool damage from mining additional blocks").translation("gui.veinmining.config.toolDamageMultiplier").defineInRange("toolDamageMultiplier", 1, 0, 1000);
            this.addPlayerExhaustion = builder.comment("Whether or not the player gets exhaustion from mining additional blocks").translation("gui.veinmining.config.addPlayerExhaustion").define("addPlayerExhaustion", true);
            this.playerExhaustionMultiplier = builder.comment("The multiplier to player exhaustion from mining additional blocks").translation("gui.veinmining.config.playerExhaustionMultiplier").defineInRange("playerExhaustionMultiplier", 1.0, 0.0, 1000.0);
            this.blocks = builder.comment("List of whitelisted/blacklisted blocks or block tags").translation("gui.veinmining.config.blocks").defineList("blocks", new ArrayList(), s -> s instanceof String);
            this.blocksPermission = builder.comment("Whether the blocks configuration is a whitelist or a blacklist").translation("gui.veinmining.config.blocksPermission").defineEnum("blocksPermission", (Enum)PermissionType.BLACKLIST);
            builder.pop();
            builder.push("groups");
            this.groups = builder.comment("List of groupings by block IDs or block tags, comma-separated").translation("gui.veinmining.config.groups").defineList("groups", VeinMiningConfig.generateDefaultGroups(), s -> s instanceof String);
            builder.pop();
        }
    }

    public static class VeinMining {
        public static boolean requireEffectiveTool;
        public static int maxBlocksBase;
        public static int maxDistanceBase;
        public static int maxBlocksPerLevel;
        public static int maxDistancePerLevel;
        public static boolean diagonalMining;
        public static boolean relocateDrops;
        public static boolean preventToolDestruction;
        public static boolean addToolDamage;
        public static int toolDamageMultiplier;
        public static boolean addPlayerExhaustion;
        public static double playerExhaustionMultiplier;
        public static boolean limitedByDurability;
        public static Set<String> blocks;
        public static PermissionType blocksPermission;
        public static Set<String> groups;

        public static void bake() {
            requireEffectiveTool = (Boolean)VeinMiningConfig.CONFIG.requireEffectiveTool.get();
            maxBlocksBase = (Integer)VeinMiningConfig.CONFIG.maxBlocksBase.get();
            maxDistanceBase = (Integer)VeinMiningConfig.CONFIG.maxDistanceBase.get();
            maxBlocksPerLevel = (Integer)VeinMiningConfig.CONFIG.maxBlocksPerLevel.get();
            maxDistancePerLevel = (Integer)VeinMiningConfig.CONFIG.maxDistancePerLevel.get();
            diagonalMining = (Boolean)VeinMiningConfig.CONFIG.diagonalMining.get();
            relocateDrops = (Boolean)VeinMiningConfig.CONFIG.relocateDrops.get();
            preventToolDestruction = (Boolean)VeinMiningConfig.CONFIG.preventToolDestruction.get();
            addToolDamage = (Boolean)VeinMiningConfig.CONFIG.addToolDamage.get();
            toolDamageMultiplier = (Integer)VeinMiningConfig.CONFIG.toolDamageMultiplier.get();
            addPlayerExhaustion = (Boolean)VeinMiningConfig.CONFIG.addPlayerExhaustion.get();
            playerExhaustionMultiplier = (Double)VeinMiningConfig.CONFIG.playerExhaustionMultiplier.get();
            limitedByDurability = (Boolean)VeinMiningConfig.CONFIG.limitedByDurability.get();
            blocks = new HashSet<String>();
            blocks.addAll((Collection)VeinMiningConfig.CONFIG.blocks.get());
            blocksPermission = (PermissionType)((Object)VeinMiningConfig.CONFIG.blocksPermission.get());
            groups = new HashSet<String>();
            groups.addAll((Collection)VeinMiningConfig.CONFIG.groups.get());
        }

        static {
            blocks = new HashSet<String>();
            blocksPermission = PermissionType.BLACKLIST;
            groups = new HashSet<String>();
        }
    }

    public static class Enchantment {
        public static Enchantment.Rarity rarity = Enchantment.Rarity.RARE;
        public static int levels = 1;
        public static boolean isTreasure = false;
        public static boolean isVillagerTrade = true;
        public static boolean isLootable = true;
        public static boolean canApplyAtEnchantingTable = true;
        public static boolean canApplyOnBooks = true;
        public static int minEnchantabilityBase = 15;
        public static int minEnchantabilityPerLevel = 5;
        public static Set<String> incompatibleEnchantments = new HashSet<String>();
        public static Set<String> items = new HashSet<String>();

        public static void bake() {
            rarity = (Enchantment.Rarity)VeinMiningConfig.CONFIG.rarity.get();
            levels = (Integer)VeinMiningConfig.CONFIG.levels.get();
            isTreasure = (Boolean)VeinMiningConfig.CONFIG.isTreasure.get();
            isVillagerTrade = (Boolean)VeinMiningConfig.CONFIG.isVillagerTrade.get();
            isLootable = (Boolean)VeinMiningConfig.CONFIG.isLootable.get();
            canApplyAtEnchantingTable = (Boolean)VeinMiningConfig.CONFIG.canApplyAtEnchantingTable.get();
            canApplyOnBooks = (Boolean)VeinMiningConfig.CONFIG.canApplyOnBooks.get();
            minEnchantabilityBase = (Integer)VeinMiningConfig.CONFIG.minEnchantabilityBase.get();
            minEnchantabilityPerLevel = (Integer)VeinMiningConfig.CONFIG.minEnchantabilityPerLevel.get();
            incompatibleEnchantments.clear();
            for (String enchantment : (List)VeinMiningConfig.CONFIG.incompatibleEnchantments.get()) {
                if (!ForgeRegistries.ENCHANTMENTS.containsKey(new ResourceLocation(enchantment))) continue;
                incompatibleEnchantments.add(enchantment);
            }
            items.clear();
            for (String item : (List)VeinMiningConfig.CONFIG.items.get()) {
                if (!VeinMiningEnchantment.PREDICATE_MAP.containsKey(item) && !ForgeRegistries.ITEMS.containsKey(new ResourceLocation(item))) continue;
                items.add(item);
            }
        }
    }
}

